@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Leauges Details</h4>
                <span class="ml-1">Layout</span>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin_dashboard')}}">Dashbaord</a></li>
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.promoterSeriesList')}}">Series List</a></li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
       <div class="col-lg-12">
            <div class="card" data-aos="fade-up">

                <div class="card-header">
                    <h6 class="card-title1"><b>Series Name : </b> {{$leaderboard_data->series_name}}</h4>
                    <h6 class="card-title1"><b>Promoter Name : </b> {{$leaderboard_data->username}}</h6>
                    <h6 class="card-title1"><b>Mobile: </b> {{$leaderboard_data->mobile}}</h6>
                    <h6 class="card-title1"><b>Team: </b> {{$leaderboard_data->team}}</h6>
                    <h6 class="card-title1"><b>Refercode: </b> {{$leaderboard_data->refercode}}</h6>
                </div>

                <div class="card-header">
                    <h4 class="card-title">Price cards Detail</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive mb-3 pb-3">

                        <table class="table table-bordered table-responsive-sm">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Min Position</th>
                                        <th>Max Position</th>
                                        <th>wining users</th>
                                        <th>Prize</th>
                                        <th>Total amount</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(!empty($findallpricecards))
                                    <?php
                                        $snoo=1;
                                        $countpricecards = count($findallpricecards);
                                    ?>
                                    @foreach($findallpricecards as $pricecars)
                                    <tr>
                                        <th>{{$snoo}}</th>
                                        <td>{{$pricecars->min_position}}</td>
                                        <td>{{$pricecars->max_position}}</td>
                                        <td>{{$pricecars->winners}}</td>
                                        <td>
                                          @if(!empty($pricecars->is_gadgets))
                                            {{$pricecars->gadgets_name}}
                                          @else
                                          {{$pricecars->price}}
                                          @endif
                                        </td>
                                        <td>{{$pricecars->total}}</td>
                                        @if($snoo==$countpricecards)
                                        <td>
                                            <a class="delbtn btn btn-danger" href="{{route($modelName.'.deletePromootrSeriesLeaderboardPricecard',base64_encode(serialize($pricecars->id)))}}" onclick="return confirm('Do you really want to delete?');" > Delete </a>
                                        </td>
                                        @else
                                        <td></td>
                                        @endif
                                    </tr>
                                    <?php  $snoo ++; ?>
                                    @endforeach
                                    @endif
                                </tbody>
                        </table>

                        <div class="col-md-12">
                            <div class="card-header">
                                <h4 class="card-title">Add New Promoter Price Card</h4>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                    <form method="post" action="{{route($modelName.'.addSeriesPromotorLeaderboardPricecard')}}" id="price_cardAddForm" enctype="multipart/form" >
                                        @csrf
                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label class="lbl_frm py-2">Start Position</label>
                                                <input type="number" min="{{$min_position}}" id="min_position" name="min_position" class="form-control in_text" value="{{$min_position}}">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('min_position'); ?>
                                                </div>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label class="lbl_frm">Number of winners</label>
                                                <input type="number" min="1" id="winners" name="winners" class="form-control in_text" value="{{old('winners')}}" placeholder="Enter number of winnners here">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('winners'); ?>
                                                </div>
                                            </div>

                                            <div class="form-group col-md-4">
                                                <label class="lbl_frm py-2">Price Amount</label>
                                                <input type="number" min="0" id="price" name="price" class="form-control in_text" value="{{old('price')}}" placeholder="Enter wining amount">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('price'); ?>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-4">
                                              <!-- <label>Multi Entry</label> -->
                                              <div class="form-check mb-2">
                                                <input type="checkbox" class="form-check-input" onchange="showHideGadgetFields(event)" id="is_gadgets" name="is_gadgets" value="1" >
                                                <label class="form-check-label" for="is_gadgets">Is Gadgets ?</label>
                                              </div>
                                            </div>
                                            </div>
                                            <div class="form-row" style="display:none" id="toggleGadgetFields">

                                            <div class="form-group col-md-6">
                                                <label class="lbl_frm py-2">Gadgets Name</label>
                                                <input type="text"  name="gadgets_name" class="form-control in_text" placeholder="Enter Gadgets Name">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('gadgets_name'); ?>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                              <label class="lbl_frm">Gadgets Image </label>
                                              <!-- <input class="form-control in_text" name="gadget_image" id="gadget_image" type="file"> -->
                                              <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="contest_type_image[]" class="imageUpload form-control in_text" />
                                              <input type="hidden" name="base64image" name="base64image" id="base64image">
                                              <label for="imageUpload"></label>
                                            </div>


                                        </div>
                                        <div class="py-2">
                                        <input type="hidden" name="series_id" value="{{$leaderboard_data->series_id}}">
                                        <input type="hidden" name="promoter_leaderboard_id" value="{{$leaderboard_data->id}}">
                                        <input type="hidden" name="user_id" value="{{$leaderboard_data->user_id}}">
                                        <button type="submit" class="btn btn-primary mr-2">Add Price Card</button>
                                        <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button></div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <!-- /# card -->
        </div>
    </div>
</div>
<div class="modal fade bd-example-modal-lg imagecrop" id="model" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">New message</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <!-- <span aria-hidden="true">&times;</span> -->
                </button>
            </div>
            <div class="modal-body">
                <div class="img-container">
                    <div class="row">
                        <div class="col-md-11">
                            <img id="image" src="https://avatars0.githubusercontent.com/u/3456749">
                        </div>
                    </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" id="crop1">Close</button>
                <button type="button" class="btn btn-primary crop" id="crop">Crop</button>
              </div>
          </div>
        </div>
      </div>
<!--**********************************
    Content body end
***********************************-->

<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });
    });

</script>

<script>
    var $modal = $('.imagecrop');
    var image = document.getElementById('image');
    var cropper;
    $("body").on("change", ".imageUpload", function(e){
        var files = e.target.files;
        var done = function(url) {
            image.src = url;
            $modal.modal('show');
        };
        var reader;
        var file;
        var url;
        if (files && files.length > 0) {
            file = files[0];
            if (URL) {
                done(URL.createObjectURL(file));
            } else if (FileReader) {
                reader = new FileReader();
                reader.onload = function(e) {
                    done(reader.result);
                };
                reader.readAsDataURL(file);
            }
        }
    });
    $modal.on('shown.bs.modal', function() {
        cropper = new Cropper(image, {
            aspectRatio: 0,
            viewMode: 0,
        });
    }).on('hidden.bs.modal', function() {
        cropper.destroy();
        cropper = null;
    });
    $("body").on("click","#crop,#crop1", function() {
        canvas = cropper.getCroppedCanvas({
            width: 160,
            height: 160,
        });
        canvas.toBlob(function(blob) {
            url = URL.createObjectURL(blob);
            var reader = new FileReader();
            reader.readAsDataURL(blob);
            reader.onloadend = function() {
                 var base64data = reader.result;
                 $('#base64image').val(base64data);
                 // document.getElementById('imagePreview').style.backgroundImage = "url("+base64data+")";
                 $modal.modal('hide');
            }
        });
    })

    $(document).ready(function () {

               $("#gadget_image").validate({
                   rules: {
                       Name: {
                           required: true,
                           minlength: 3
                       },
                       gadget_image_Image: {
                           required: true,
                           extension: "jpg|jpeg|png"

                       }
                   },
                   messages: {
                       gadget_image_Image: {
                           extension:"Please select only jpg , jpeg and png images"
                       }
                   }

               });


               //validate file extension custom  method.
               jQuery.validator.addMethod("extension", function (value, element, param) {
                   param = typeof param === "string" ? param.replace(/,/g, '|') : "pdf|doc";
                   return this.optional(element) || value.match(new RegExp(".(" + param + ")$", "i"));
               }, jQuery.format("Please enter a value with a valid extension."));


           });

   function showHideGadgetFields(event){
     if(event.target.checked){
       $("#toggleGadgetFields").show();
     }else{
       $("#toggleGadgetFields").hide();
     }
   }

</script>

@endsection
