@extends('admin.elements.common.login_layout')
@section('title', 'Login')
@section('content')
    <?php
    $email_cookie = Cookie::get('email');
    $remember_cookie = Cookie::get('remember');
    ?>
    <!-- BEGIN LOGIN FORM -->
    <form method="POST" id="adminLoginForm" action="{{ route('Admin.login') }}">
        @csrf
        <div class="form-group">
            <label><strong>Username</strong></label>
            <input type="email" name="email" class="form-control" placeholder="Enter your email"
                class="form-control form-control-solid placeholder-no-fix"
                value="{{ isset($email_cookie) ? $email_cookie : '' }}" />
        </div>
        <div class="form-group">
            <label><strong>Password</strong></label>
            <input type="password" name="password" placeholder="Password"
                class="form-control form-control-solid placeholder-no-fix" />
        </div>
        <div class="form-row d-flex justify-content-between mt-4 mb-2">
            <div class="form-group">
                <div class="form-check ml-2">
                    <!--  <input class="form-check-input" type="checkbox" id="basic_checkbox_1"> -->
                    <!--  <label class="form-check-label" for="basic_checkbox_1">Remember me</label> -->
                    <input type="checkbox" name="remember" id="rememberme" class="filled-in chk-col-pink"
                        {{ old('remember', $remember_cookie) === 'on' ? 'checked' : '' }}> Remember me
                </div>
            </div>
            <div class="form-group">
                <a href="{{ route('admin.forgotPassword') }}" id="forget-password">Forgot Password?</a>
            </div>
        </div>
        <div class="text-center">
            <button type="submit" class="btn btn-primary btn-block">Login</button>
        </div>
    </form>
    <!-- END LOGIN FORM -->
    <!--  <div class="new-account mt-3">
            <p>Don't have an account? <a class="text-primary" href="page-register.html">Sign up</a></p>
        </div> -->
@endsection
