@extends('admin.elements.common.login_layout')
@section('title', 'Reset Password')
@section('content')
    <style>
        .error-message.error.forgot-password {
            color: red !important;
        }
    </style>
    <!-- BEGIN LOGIN FORM -->
    <form role="form" method="POST" action="{{ route('Admin.save_password') }}" id="adminResetForm">
        @csrf
        <input type="hidden" value="{{ $validate_string }}" name="validate_string" />
        <div class="form-title">
            <p class="text-center">Reset Password</p>
        </div>
        <div>
            <div class="form-group">
                <label class="control-label visible-ie8 visible-ie9">New Password</label>
                <input type="password" name="new_password" placeholder="Enter New Password"
                    class="form-control form-control-solid placeholder-no-fix" />
                <div class="error-message error forgot-password">
                    <?php echo $errors->first('new_password'); ?>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label visible-ie8 visible-ie9">Confirm Password</label>
                <input type="password" name="new_password_confirmation" placeholder="Enter Confirm Password"
                    class="form-control form-control-solid placeholder-no-fix" />
                <div class="error-message error forgot-password">
                    <?php echo $errors->first('new_password_confirmation'); ?>
                </div>
            </div>
            <div class="form-actions">
                <button type="submit" class="btn red btn-block uppercase">{{ trans('messages.global.submit') }}</button>
            </div>
    </form>
    <!-- END LOGIN FORM -->
@endsection
