@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<style type="text/css">
  #team_one_added_player,#team_two_added_player {
    padding: 5px;
  }
</style>
<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.matchmapping')}}">View all Upcoming Matches</a></li>
                <li class="breadcrumb-item">Edit</li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Edit Match</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form action="{{route($modelName.'.edit_match',['matchkey' =>$matchkey])}}" id="matchAddForm" method="post" >
                            @csrf
                            <div class="form-row">

                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Select Series</label>
                                    <select class="form-control in_text" name="series" id="series">
                                        <option value="">Select Series</option>
                                        @foreach($findallseries as $key => $value)
                                            <option value="{{$value->id}}" <?php if($value->id == $match_detail->series) { echo 'selected';} ?> >{{$value->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Select Match Format</label>
                                    <select class="form-control in_text" name="format">
                                        <option value="t10" <?php if($match_detail->format == 't10'){echo "selected";} ?>>T10</option>
                                        <option value="t20" <?php if($match_detail->format == 't20'){echo "selected";} ?>>T20</option>
                                        <option value="t20" <?php if($match_detail->format == 'hundred'){echo "selected";} ?>>The Hundred</option>
                                        <option value="one-day"<?php if($match_detail->format == 'one-day'){echo "selected";} ?>>One-day</option>
                                        <option value="test"<?php if($match_detail->format == 'test'){echo "selected";} ?>>Test</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Select Team1</label>
                                    <select class="form-control in_text" name="team1" id="team1">
                                        <option value="">Select Team</option>
                                        @foreach($teams as $key => $value)
                                            <option value="{{$value->id}}" <?php if($value->id == $match_detail->team1) { echo 'selected';} ?> >{{$value->team}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Start Date</label>
                                    <input id="dob" type="text" name="start_date"  value="{{$match_detail->start_date}}" class="form-control datetimepickerget in_text" placeholder="Enter Match Start Date">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12 team1_players">
                                    <h4>Team 1 Players</h4>
                                    <select id='team_one' name='team1_player[]' multiple='multiple'>
                                        @foreach($team1players as $key => $value)
                                            <option value="{{$value->id}}"
                                                <?php foreach ($matchplayers as $keys => $values) {
                                                          if($value->id == $values->playerid){
                                                              echo "selected";
                                                          }
                                                } ?>
                                              >
                                              {{$value->player_name}}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div id="team_one_added_player" style="font-weight:bold;">
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Select Team2</label>
                                    <select class="form-control in_text" name="team2" id="team2">
                                        <option value="">Select Team</option>
                                        @foreach($teams as $key => $value)
                                            <option value="{{$value->id}}" <?php if($value->id == $match_detail->team2) { echo 'selected';} ?> >{{$value->team}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12 team1_players">
                                    <h4>Team 2 Players</h4>
                                    <select id='team_two' name='team2_player[]' multiple='multiple'>
                                        @foreach($team2players as $key => $value)
                                            <option value="{{$value->id}}"
                                                  <?php foreach ($matchplayers as $keys => $values) {
                                                            if($value->id == $values->playerid){
                                                                echo "selected";
                                                            }
                                                  } ?>
                                                >
                                                {{$value->player_name}}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div id="team_two_added_player" style="font-weight:bold;">
                                    </div>
                                </div>
                            </div>



                            <div class="py-2">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button></div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){
        $("#dob").datetimepicker();
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });
    });
</script>


<link rel="stylesheet" type="text/css" href="https://admin.real11.com//dist/multiselect/multi-select.css">
<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.0.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-alpha/js/bootstrap.min.js"></script> -->
<script src="https://admin.real11.com//dist/multiselect/jquery.multi-select.js"></script>

<script type="text/javascript">

  $('#team_one').multiSelect(
  {
    afterSelect: function(values)
    {
      var fooCount =  $('#team_one option:selected').length ;

      $("#team_one_added_player").html('Added Player: '+fooCount);

      // if(fooCount == 15)
      // {
      //   alert('Only 15 Options Allowed');
      // $('#ms-team_one .ms-selectable li').addClass('disabled');
      // }
    },

    afterDeselect: function(values)
    {
      // alert("Deselect value: "+values);

      var fooCount =  $('#team_one option:selected').length ;

      $("#team_one_added_player").html('Added Player: '+fooCount);

      // if(fooCount < 15)
      // {
      //   $('#ms-team_one .ms-selectable li').removeClass('disabled');
      // }

    }
  });

  $('#team_two').multiSelect(
  {

    afterSelect: function(values)
    {
      var fooCount =  $('#team_two option:selected').length ;

      $("#team_two_added_player").html('Added Player: '+fooCount);

     /* if(fooCount == 15)
      {
        alert('Only 15 Options Allowed');
      $('#ms-team_two .ms-selectable li').addClass('disabled');
      }*/
    },
    afterDeselect: function(values)
    {
      // alert("Deselect value: "+values);
      var fooCount =  $('#team_two option:selected').length ;

      $("#team_two_added_player").html('Added Player: '+fooCount);

      /*if(fooCount < 15)
      {
        $('#ms-team_two .ms-selectable li').removeClass('disabled');
      }*/
    }

  });
</script>
<!-- //Multiselect// -->

<style type="text/css">
.hide_one{ display: none; }
.hide_two{ display: none; }
</style>

<script type="text/javascript">
    $(document).ready(function(){

        $('#start_date').datetimepicker();

        $(document).on("change","#series",function(){
            $("#season").val($("#series :selected").text());
        });

        $(document).on("change","#team1",function(event){
            var team1 = $(this).val().trim();
            //$("#team1_name").val($("#team1 :selected").text());
            $(".team1_players").find("h4").text($("#team1 :selected").text());
            $("#team2").children('option').removeAttr('disabled');
            $('#team2').children('option[value="'+team1+'"]').attr('disabled','disabled');
            if (team1 != '' || team1 != 0) {
                $.ajax({
                    url: "{{route($modelName.'.getTeamPlayers')}}",
                    type: "post",
                    data: {"team_id":team1},
                    success: function(res){
                        console.log(res.players[2].id);
                        var output = [];
                        $.each(res.players, function(key, value)
                        {
                          output.push('<option value="'+ value.id +'">'+ value.player_name +'</option>');
                        });
                        $('#team_one').html(output.join(''));
                        $('#team_one').multiSelect('refresh');
                    },
                    error: function(err){
                        console.log(err);
                    }
                });
            }
        });

        $(document).on("change","#team2",function(event){
            var team2 = $(this).val().trim();
            //$("#team2_name").val($("#team2 :selected").text());
            $(".team2_players").find("h4").text($("#team2 :selected").text());
            $("#team1").children('option').removeAttr('disabled');
            $('#team1').children('option[value="'+team2+'"]').attr('disabled','disabled');
            if (team2 != '' || team2 != 0) {
                $.ajax({
                    url: "{{route($modelName.'.getTeamPlayers')}}",
                    type: "post",
                    data: {"team_id":team2},
                    success: function(res){
                        console.log(res);
                        var output = [];
                        $.each(res.players, function(key, value)
                        {
                          output.push('<option value="'+ value.id +'">'+ value.player_name +'</option>');
                        });
                        $('#team_two').html(output.join(''));
                        $('#team_two').multiSelect('refresh');
                    },
                    error: function(err){
                        console.log(err);
                    }
                });
            }
        });

    });
</script>




<!--**********************************
Content body end
***********************************-->
@endsection
