@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--*************** Content body start ******************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                                                <h4>Edit Sub Admin</h4>
                                                <span class="ml-1">Layout</span>
                                            </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <a href="">Edit bot team</a>
                    </li>
                    <li class="breadcrumb-item">Edit bot team</li>
                </ol>
            </div>
        </div>

        <?php //echo "<pre>"; print_r($selected_model);
        ?>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit bot team</h4>
                    </div>
                    <form method="POST" action="{{ route('Matches.join_bot_details.edit', ['id' => $id]) }}"
                        enctype="multipart/form-data" id="EditForm">
                        @csrf

                        <div class="card-body">
                            <div class="basic-form">
                               
                                    @csrf

                                    <div class="form-row">
                                        @php
                                            $roles = [
                                                'bowler' => 'Bowlers',
                                                'batsman' => 'Batsmen',
                                                'allrounder' => 'Allrounders',
                                                'keeper' => 'Wicket Keepers',
                                            ];
                                        @endphp

                                        @foreach ($roles as $role => $roleName)
                                            <div class="form-group col-md-3">
                                                <h5 class="text-center mb-2">{{ $roleName }}</h5>
                                                <ul class="list-group">
                                                    @foreach ($allPlayers as $player)
                                                        @if ($player->role == $role)
                                                            @php
                                                                // Define player status color
                                                                $statusColor = 'text-danger'; // Default red
                                                                if ($player->is_assumption == 1) {
                                                                    $statusColor = 'text-success'; // Green for playing
                                                                } elseif ($player->is_substitute == 1) {
                                                                    $statusColor = 'text-primary'; // Blue for substitute
                                                                }

                                                                // Check if player is selected
                                                                $isChecked = in_array($player->playerid, $selplayers)
                                                                    ? 'checked'
                                                                    : '';

                                                                // Check if player is Captain or Vice-Captain
                                                                $isCaptain =
                                                                    $player->playerid == $team_arr->captain
                                                                        ? 'checked'
                                                                        : '';
                                                                $isViceCaptain =
                                                                    $player->playerid == $team_arr->vicecaptain
                                                                        ? 'checked'
                                                                        : '';
                                                            @endphp

                                                            <li class="list-group-item d-flex align-items-center mb-2">
                                                                <!-- Checkbox for selecting the player -->
                                                                <input type="checkbox" name="selected_players[]"
                                                                    value="{{ $player->playerid }}" {{ $isChecked }}
                                                                    class="mr-2">

                                                                <!-- Player status dot and name (prevent name wrapping) -->
                                                                <span class="{{ $statusColor }} font-weight-bold">●</span>
                                                                <span class="ml-2 text-truncate w-100"
                                                                    style="max-width: 120px;">{{ $player->name }}</span>

                                                                <!-- Captain and Vice-Captain selection -->
                                                                <div class="ml-auto">
                                                                    <label class="mr-2">
                                                                        <input type="radio" name="captain"
                                                                            value="{{ $player->playerid }}"
                                                                            {{ $isCaptain }} class="captain-radio"> C
                                                                    </label>
                                                                    <label>
                                                                        <input type="radio" name="vicecaptain"
                                                                            value="{{ $player->playerid }}"
                                                                            {{ $isViceCaptain }} class="vicecaptain-radio">
                                                                        VC
                                                                    </label>
                                                                </div>
                                                            </li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endforeach
                                    </div>

                                    
                            </div>
                        </div>

                        <div class="card-footer py-4">
                            <button type="submit" class="btn btn-primary mr-2 submit-from">Submit</button>
                            <a href="{{route('Matches.join_bot_details', ['id' => $matchid])}}"> <button class="btn btn-gray" id="cancel_btn" type="button">Cancel</button> </a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const captainRadios = document.querySelectorAll(".captain-radio");
            const viceCaptainRadios = document.querySelectorAll(".vicecaptain-radio");

            captainRadios.forEach(radio => {
                radio.addEventListener("change", function() {
                    viceCaptainRadios.forEach(vcRadio => {
                        if (vcRadio.value === this.value) {
                            vcRadio.checked = false;
                        }
                    });
                });
            });

            viceCaptainRadios.forEach(radio => {
                radio.addEventListener("change", function() {
                    captainRadios.forEach(cRadio => {
                        if (cRadio.value === this.value) {
                            cRadio.checked = false;
                        }
                    });
                });
            });
        });
    </script>
@endsection
