@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <style type="text/css">
        .list-inline li {
            display: inline-table;
            padding: 5px 14px;
            /*background: #5d78ff;*/
            border-radius: 3px;
        }

        .list-inline li a {
            color: #fff;
        }
    </style>
    <?php //echo $battingfantasy; exit;
    ?>
    <div class="container-fluid">
        <div class="row leaguesMatches">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <!-- <a href="{{ route('Series.add') }}" class="btn btn-primary btn-sm"> Add New {{ $modelName }}</a> -->
                        <h4 class="form-inline">Select Challenges &ensp;
                            <form action="{{ route($modelName . '.submitleaguesforlaunch') }}" method=""
                                id="challengesDatatableForm" enctype="multipart/form-data" @csrf <input type="hidden"
                                name="matchId" value="{{ $matchkey }}">
                                <input type="hidden" name="sport_type" value="{{ $sport_type }}">
                                <input type="hidden" name="action_type" value="add_more_contest">
                                <button type="submit" class="btn btn-primary" id="launchButton" disabled>Update
                                    Contest</button>
                            </form>
                        </h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive ">
                            @if (!empty($allchallengecategory))
                                @foreach ($allchallengecategory as $challenge_category)
                                    <h4 style="margin-bottom:-46px;"> Category : {{ $challenge_category->name }}</h4>
                                    <table id="dataList_{{ $loop->index }}" class="display" style="min-width: 845px">
                                        <thead>
                                            <tr>
                                                <th><input type="checkbox"
                                                        onchange="checkAllCheckboxes({{ $loop->index }} , event)"></th>
                                                <th>S No.</th>
                                                <?php if($livefantasy==1){ ?>
                                                <th><input type="checkbox" name="livefantasy"
                                                        onchange="checkAllCheckboxes_livefantasy({{ $loop->index }},event)"><br />Live
                                                    Fantasy</th>
                                                <?php } ?>

                                                <?php if($battingfantasy==1){ ?>
                                                <th><input type="checkbox" name="battingfantasy"
                                                        onchange="checkAllCheckboxes_battingfantasy({{ $loop->index }},event)"><br />Batting
                                                    Fantasy</th>
                                                <?php } ?>

                                                <?php if($bowlingfantasy==1){ ?>
                                                <th><input type="checkbox" name="bowlingfantasy"
                                                        onchange="checkAllCheckboxes_bowlingfantasy({{ $loop->index }},event)"><br />Bowling
                                                    Fantasy</th>
                                                <?php } ?>

                                                <?php if($reversefantasy==1){ ?>
                                                <th><input type="checkbox" name="reversefantasy"
                                                        onchange="checkAllCheckboxes_reversefantasy({{ $loop->index }},event)"><br />Reverse
                                                    Fantasy</th>
                                                <?php } ?>

                                                <?php if($tenOneFantasy==1){ ?>
                                                <th><input type="checkbox" name="tenonefantasy"
                                                        onchange="checkAllCheckboxes_tenonefantasy({{ $loop->index }},event)"><br />Ten
                                                    One Fantasy</th>
                                                <?php } ?>
                                                <?php if($fiveOneFantasy==1){ ?>
                                                <th><input type="checkbox" name="fiveonefantasy"
                                                        onchange="checkAllCheckboxes_fiveonefantasy({{ $loop->index }},event)"><br />Five
                                                    One Fantasy</th>
                                                <?php } ?>

                                                <th>Sorting Order</th>
                                                <th>Wining amount</th>
                                                <th>Entry fees</th>
                                                <th>Sport Type</th>
                                                <th>Challenge Type</th>
                                                <th>Maximum users</th>
                                                <th>Winning Percentage</th>
                                                <th>Multiple Entry</th>
                                                <th>Can Use Bonus</th>
                                                <th>Is running</th>
                                                <th>Confirm Leauge</th>
                                                <th>Category</th>
                                            </tr>
                                        </thead>
                                        <tfoot>
                                            <tr>
                                                <th><input type="checkbox" name="livefantasy"
                                                        onchange="checkAllCheckboxes({{ $loop->index }})"></th>
                                                <th>S No.</th>
                                                <?php if($livefantasy==1){ ?>
                                                <th>Live Fantasy</th>
                                                <?php } ?>
                                                <?php if($battingfantasy==1){ ?>
                                                <th>Batting Fantasy</th>
                                                <?php } ?>
                                                <?php if($bowlingfantasy==1){ ?>
                                                <th>Bowling Fantasy</th>
                                                <?php } ?>
                                                <?php if($reversefantasy==1){ ?>
                                                <th>Reverse Fantasy</th>
                                                <?php } ?>
                                                <?php if($tenOneFantasy==1){ ?>
                                                <th>Ten One Fantasy</th>
                                                <?php } ?>
                                                <th>Sorting Order</th>
                                                <th>Wining amount</th>
                                                <th>Entry fees</th>
                                                <th>Sport Type</th>
                                                <th>Challenge Type</th>
                                                <th>Maximum users</th>
                                                <th>Winning Percentage</th>
                                                <th>Multiple Entry</th>
                                                <th>Can Use Bonus</th>
                                                <th>Is running</th>
                                                <th>Confirm Leauge</th>
                                                <th>Category</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var challengeIds = [];
        var livefantasy_challengeIds = [];
        var battingfantasy_challengeIds = [];
        var bowlingfantasy_challengeIds = [];
        var reversefantasy_challengeIds = [];
        var tenonefantasy_challengeIds = [];
        var fiveonefantasy_challengeIds = [];

        function checkAllCheckboxes(index, event) {
            var elementChecked = $("#dataList_" + index + " :input[type='checkbox']").first().prop("checked");
            if (elementChecked) {
                var checkboxes = document.querySelectorAll("#dataList_" + index +
                    " input[type='checkbox'][name='challenge_id']");
                // console.log(checkboxes); exit; live_fantasy_challenge_id
                for (var j = 0; j < checkboxes.length; j++) {
                    if (challengeIds.findIndex(x => x.challenge_id == checkboxes[j].value) === -1) {
                        let sort_order_val = document.getElementsByName('sort_order_' + checkboxes[j].value)[0].value;
                        challengeIds.push({
                            "challenge_id": checkboxes[j].value,
                            "sort_order": sort_order_val
                        });
                        checkboxes[j].checked = true;
                    }
                }
            } else {
                var checkboxes = document.querySelectorAll("#dataList_" + index +
                    " input[type='checkbox'][name='challenge_id']");
                for (var j = 0; j < checkboxes.length; j++) {
                    checkboxes[j].checked = false;
                    if (challengeIds.findIndex(x => x.challenge_id == checkboxes[j].value) !== -1) {
                        challengeIds.splice(challengeIds.findIndex(x => x.challenge_id === checkboxes[j].value), 1);
                    }
                }
            }
            console.log(challengeIds);
        }

        function checkAllCheckboxes_livefantasy(index, event) {
            var elementChecked = $("#dataList_" + index + " :input[name='livefantasy']").first().prop("checked");

            if (elementChecked) {
                var checkboxes_liveFantasy = document.querySelectorAll("#dataList_" + index +
                    "   input[type='checkbox'][name='live_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_liveFantasy.length; j++) {
                    if (livefantasy_challengeIds.findIndex(x => x.live_fantasy_challenge_id == checkboxes_liveFantasy[j]
                            .value) === -1) {
                        let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_liveFantasy[j].value)[0]
                            .value;
                        livefantasy_challengeIds.push({
                            "live_fantasy_challenge_id": checkboxes_liveFantasy[j].value,
                            "sort_order": sort_order_val
                        });
                        checkboxes_liveFantasy[j].checked = true;
                    }
                }
            } else {
                var checkboxes_liveFantasy = document.querySelectorAll("#dataList_" + index +
                    " input[type='checkbox'][name='live_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_liveFantasy.length; j++) {
                    checkboxes_liveFantasy[j].checked = false;
                    if (livefantasy_challengeIds.findIndex(x => x.live_fantasy_challenge_id == checkboxes_liveFantasy[j]
                            .value) !== -1) {
                        livefantasy_challengeIds.splice(livefantasy_challengeIds.findIndex(x => x
                            .live_fantasy_challenge_id === checkboxes_liveFantasy[j].value), 1);
                    }
                }
            }
            console.log(livefantasy_challengeIds);
        }

        // Batting fantasy
        function checkAllCheckboxes_battingfantasy(index, event) {
            var elementChecked = $("#dataList_" + index + " :input[name='battingfantasy']").first().prop("checked");

            if (elementChecked) {
                var checkboxes_battingfantasy = document.querySelectorAll("#dataList_" + index +
                    "   input[type='checkbox'][name='batting_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_battingfantasy.length; j++) {
                    if (battingfantasy_challengeIds.findIndex(x => x.batting_fantasy_challenge_id ==
                            checkboxes_battingfantasy[j].value) === -1) {
                        let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_battingfantasy[j].value)[
                            0].value;
                        battingfantasy_challengeIds.push({
                            "batting_fantasy_challenge_id": checkboxes_battingfantasy[j].value,
                            "sort_order": sort_order_val
                        });
                        checkboxes_battingfantasy[j].checked = true;
                    }
                }
            } else {
                var checkboxes_battingfantasy = document.querySelectorAll("#dataList_" + index +
                    " input[type='checkbox'][name='batting_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_battingfantasy.length; j++) {
                    checkboxes_battingfantasy[j].checked = false;
                    if (battingfantasy_challengeIds.findIndex(x => x.batting_fantasy_challenge_id ==
                            checkboxes_battingfantasy[j].value) !== -1) {
                        battingfantasy_challengeIds.splice(battingfantasy_challengeIds.findIndex(x => x
                            .batting_fantasy_challenge_id === checkboxes_battingfantasy[j].value), 1);
                    }
                }
            }
            console.log(battingfantasy_challengeIds);
        }

        // Bowling Fantasy
        function checkAllCheckboxes_bowlingfantasy(index, event) {
            var elementChecked = $("#dataList_" + index + " :input[name='bowlingfantasy']").first().prop("checked");
            if (elementChecked) {
                var checkboxes_bowlingfantasy = document.querySelectorAll("#dataList_" + index +
                    "   input[type='checkbox'][name='bowling_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_bowlingfantasy.length; j++) {
                    if (bowlingfantasy_challengeIds.findIndex(x => x.bowling_fantasy_challenge_id ==
                            checkboxes_bowlingfantasy[j].value) === -1) {
                        let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_bowlingfantasy[j].value)[
                            0].value;
                        bowlingfantasy_challengeIds.push({
                            "bowling_fantasy_challenge_id": checkboxes_bowlingfantasy[j].value,
                            "sort_order": sort_order_val
                        });
                        checkboxes_bowlingfantasy[j].checked = true;
                    }
                }
            } else {
                var checkboxes_bowlingfantasy = document.querySelectorAll("#dataList_" + index +
                    " input[type='checkbox'][name='bowling_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_bowlingfantasy.length; j++) {
                    checkboxes_bowlingfantasy[j].checked = false;
                    if (bowlingfantasy_challengeIds.findIndex(x => x.bowling_fantasy_challenge_id ==
                            checkboxes_bowlingfantasy[j].value) !== -1) {
                        bowlingfantasy_challengeIds.splice(bowlingfantasy_challengeIds.findIndex(x => x
                            .bowling_fantasy_challenge_id === checkboxes_bowlingfantasy[j].value), 1);
                    }
                }
            }
            console.log(bowlingfantasy_challengeIds);
        }

        // Reverse Fantasy
        function checkAllCheckboxes_reversefantasy(index, event) {
            var elementChecked = $("#dataList_" + index + " :input[name='reversefantasy']").first().prop("checked");
            if (elementChecked) {
                var checkboxes_reversefantasy = document.querySelectorAll("#dataList_" + index +
                    "   input[type='checkbox'][name='reverse_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_reversefantasy.length; j++) {
                    if (reversefantasy_challengeIds.findIndex(x => x.reverse_fantasy_challenge_id ==
                            checkboxes_reversefantasy[j].value) === -1) {
                        let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_reversefantasy[j].value)[
                            0].value;
                        reversefantasy_challengeIds.push({
                            "reverse_fantasy_challenge_id": checkboxes_reversefantasy[j].value,
                            "sort_order": sort_order_val
                        });
                        checkboxes_reversefantasy[j].checked = true;
                    }
                }
            } else {
                var checkboxes_reversefantasy = document.querySelectorAll("#dataList_" + index +
                    " input[type='checkbox'][name='reverse_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_reversefantasy.length; j++) {
                    checkboxes_reversefantasy[j].checked = false;
                    if (reversefantasy_challengeIds.findIndex(x => x.reverse_fantasy_challenge_id ==
                            checkboxes_reversefantasy[j].value) !== -1) {
                        reversefantasy_challengeIds.splice(reversefantasy_challengeIds.findIndex(x => x
                            .reverse_fantasy_challenge_id === checkboxes_reversefantasy[j].value), 1);
                    }
                }
            }
            console.log(reversefantasy_challengeIds);
        }

        // Ten One Fantasy
        function checkAllCheckboxes_tenonefantasy(index, event) {
            var elementChecked = $("#dataList_" + index + " :input[name='tenonefantasy']").first().prop("checked");
            if (elementChecked) {
                var checkboxes_tenonefantasy = document.querySelectorAll("#dataList_" + index +
                    "   input[type='checkbox'][name='ten_one_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_tenonefantasy.length; j++) {
                    if (tenonefantasy_challengeIds.findIndex(x => x.ten_one_fantasy_challenge_id ==
                            checkboxes_tenonefantasy[j].value) === -1) {
                        let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_tenonefantasy[j].value)[
                            0].value;
                        tenonefantasy_challengeIds.push({
                            "ten_one_fantasy_challenge_id": checkboxes_tenonefantasy[j].value,
                            "sort_order": sort_order_val
                        });
                        checkboxes_tenonefantasy[j].checked = true;
                    }
                }
            } else {
                var checkboxes_tenonefantasy = document.querySelectorAll("#dataList_" + index +
                    " input[type='checkbox'][name='ten_one_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_tenonefantasy.length; j++) {
                    checkboxes_tenonefantasy[j].checked = false;
                    if (tenonefantasy_challengeIds.findIndex(x => x.ten_one_fantasy_challenge_id ==
                            checkboxes_tenonefantasy[j].value) !== -1) {
                        tenonefantasy_challengeIds.splice(tenonefantasy_challengeIds.findIndex(x => x
                            .ten_one_fantasy_challenge_id === checkboxes_tenonefantasy[j].value), 1);
                    }
                }
            }
            console.log(tenonefantasy_challengeIds);
        }

        // Five One Fantasy
        function checkAllCheckboxes_fiveonefantasy(index, event) {

            var elementChecked = $("#dataList_" + index + " :input[name='fiveonefantasy']").first().prop("checked");

            if (elementChecked) {
                var checkboxes_fiveonefantasy = document.querySelectorAll("#dataList_" + index +
                    "   input[type='checkbox'][name='five_one_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_fiveonefantasy.length; j++) {
                    if (fiveonefantasy_challengeIds.findIndex(x => x.five_one_fantasy_challenge_id ==
                            checkboxes_fiveonefantasy[j].value) === -1) {
                        let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_fiveonefantasy[j].value)[
                            0].value;
                        fiveonefantasy_challengeIds.push({
                            "five_one_fantasy_challenge_id": checkboxes_fiveonefantasy[j].value,
                            "sort_order": sort_order_val
                        });
                        checkboxes_fiveonefantasy[j].checked = true;
                    }
                }
            } else {
                var checkboxes_fiveonefantasy = document.querySelectorAll("#dataList_" + index +
                    " input[type='checkbox'][name='five_one_fantasy_challenge_id']");
                for (var j = 0; j < checkboxes_fiveonefantasy.length; j++) {
                    checkboxes_fiveonefantasy[j].checked = false;
                    if (fiveonefantasy_challengeIds.findIndex(x => x.five_one_fantasy_challenge_id ==
                            checkboxes_fiveonefantasy[j].value) !== -1) {
                        fiveonefantasy_challengeIds.splice(fiveonefantasy_challengeIds.findIndex(x => x
                            .five_one_fantasy_challenge_id === checkboxes_fiveonefantasy[j].value), 1);
                    }
                }
            }
            console.log(fiveonefantasy_challengeIds);
        }

        function editSortingOrderInArray(challengeId, event) {

            if (challengeIds.findIndex(x => x.challenge_id == challengeId) !== -1) {
                challengeIds[challengeIds.findIndex(x => x.challenge_id == challengeId)].sort_order = event.target.value;
            }
            console.log(challengeIds);

            // Live Fantasy
            if (livefantasy_challengeIds.findIndex(x => x.challenge_id == challengeId) !== -1) {
                livefantasy_challengeIds[livefantasy_challengeIds.findIndex(x => x.live_fantasy_challenge_id ==
                    livefantasy_challengeIds)].sort_order = event.target.value;
            }
            console.log(livefantasy_challengeIds);

            // Batting fantasy
            if (battingfantasy_challengeIds.findIndex(x => x.challenge_id == challengeId) !== -1) {
                battingfantasy_challengeIds[battingfantasy_challengeIds.findIndex(x => x.batting_fantasy_challenge_id ==
                    battingfantasy_challengeIds)].sort_order = event.target.value;
            }
            console.log(battingfantasy_challengeIds);

            // Bowling Fantasy
            if (bowlingfantasy_challengeIds.findIndex(x => x.challenge_id == challengeId) !== -1) {
                bowlingfantasy_challengeIds[bowlingfantasy_challengeIds.findIndex(x => x.bowling_fantasy_challenge_id ==
                    bowlingfantasy_challengeIds)].sort_order = event.target.value;
            }
            console.log(bowlingfantasy_challengeIds);

            // Reverse Fantasy
            if (reversefantasy_challengeIds.findIndex(x => x.challenge_id == challengeId) !== -1) {
                reversefantasy_challengeIds[reversefantasy_challengeIds.findIndex(x => x.reverse_fantasy_challenge_id ==
                    reversefantasy_challengeIds)].sort_order = event.target.value;
            }
            console.log(reversefantasy_challengeIds);

            // Ten One Fantasy
            if (tenonefantasy_challengeIds.findIndex(x => x.challenge_id == challengeId) !== -1) {
                tenonefantasy_challengeIds[tenonefantasy_challengeIds.findIndex(x => x.ten_one_fantasy_challenge_id ==
                    tenonefantasy_challengeIds)].sort_order = event.target.value;
            }
            console.log(tenonefantasy_challengeIds);
            // Five One Fantasy
            if (fiveonefantasy_challengeIds.findIndex(x => x.challenge_id == challengeId) !== -1) {
                fiveonefantasy_challengeIds[fiveonefantasy_challengeIds.findIndex(x => x.five_one_fantasy_challenge_id ==
                    fiveonefantasy_challengeIds)].sort_order = event.target.value;
            }
            console.log(fiveonefantasy_challengeIds);
        }

        function addOrRemoveChallenge(event) {
            if (event.target.checked) {
                let sort_order_val = document.getElementsByName('sort_order_' + event.target.value)[0].value;
                challengeIds.push({
                    "challenge_id": event.target.value,
                    "sort_order": sort_order_val
                });

            } else {

                if (challengeIds.findIndex(x => x.challenge_id == event.target.value) !== -1) {
                    challengeIds.splice(challengeIds.findIndex(x => x.challenge_id === event.target.value), 1);

                }
            }
            console.log(challengeIds);
        }

        // Live Fantasy
        function addOrRemoveliveFanasyChallenge(event) {
            if (event.target.checked) {
                let sort_order_val = document.getElementsByName('sort_order_' + event.target.value)[0].value;
                livefantasy_challengeIds.push({
                    "live_fantasy_challenge_id": event.target.value,
                    "sort_order": sort_order_val
                });

            } else {
                if (livefantasy_challengeIds.findIndex(x => x.live_fantasy_challenge_id == event.target.value) !== -1) {
                    livefantasy_challengeIds.splice(live_fantasy_challenge_id.findIndex(x => x.live_fantasy_challenge_id ===
                        event.target.value), 1);
                }
            }
            console.log(live_fantasy_challenge_id);
        }

        // Batting Fantasy
        function addOrRemovebattingFantasyChallenge(event) {
            if (event.target.checked) {
                let sort_order_val = document.getElementsByName('sort_order_' + event.target.value)[0].value;
                battingfantasy_challengeIds.push({
                    "batting_fantasy_challenge_id": event.target.value,
                    "sort_order": sort_order_val
                });

            } else {
                if (battingfantasy_challengeIds.findIndex(x => x.batting_fantasy_challenge_id == event.target.value) !== -
                    1) {
                    battingfantasy_challengeIds.splice(batting_fantasy_challenge_id.findIndex(x => x
                        .batting_fantasy_challenge_id === event.target.value), 1);
                }
            }
            console.log(batting_fantasy_challenge_id);
        }

        // Bowling Fantasy
        function addOrRemovebowlingFantasyChallenge(event) {
            if (event.target.checked) {
                let sort_order_val = document.getElementsByName('sort_order_' + event.target.value)[0].value;
                bowlingfantasy_challengeIds.push({
                    "bowling_fantasy_challenge_id": event.target.value,
                    "sort_order": sort_order_val
                });

            } else {
                if (bowlingfantasy_challengeIds.findIndex(x => x.bowling_fantasy_challenge_id == event.target.value) !== -
                    1) {
                    bowlingfantasy_challengeIds.splice(bowling_fantasy_challenge_id.findIndex(x => x
                        .bowling_fantasy_challenge_id === event.target.value), 1);
                }
            }
            console.log(bowling_fantasy_challenge_id);
        }

        // Reverse Fantasy
        function addOrRemovereverseFantasyChallenge(event) {
            if (event.target.checked) {
                let sort_order_val = document.getElementsByName('sort_order_' + event.target.value)[0].value;
                reversefantasy_challengeIds.push({
                    "reverse_fantasy_challenge_id": event.target.value,
                    "sort_order": sort_order_val
                });

            } else {
                if (reversefantasy_challengeIds.findIndex(x => x.reverse_fantasy_challenge_id == event.target.value) !== -
                    1) {
                    reversefantasy_challengeIds.splice(reverse_fantasy_challenge_id.findIndex(x => x
                        .reverse_fantasy_challenge_id === event.target.value), 1);
                }
            }
            console.log(reverse_fantasy_challenge_id);
        }

        // Ten One Fantasy
        function addOrRemoveTenOneFantasyChallenge(event) {
            if (event.target.checked) {
                let sort_order_val = document.getElementsByName('sort_order_' + event.target.value)[0].value;
                tenonefantasy_challengeIds.push({
                    "ten_one_fantasy_challenge_id": event.target.value,
                    "sort_order": sort_order_val
                });

            } else {
                if (tenonefantasy_challengeIds.findIndex(x => x.ten_one_fantasy_challenge_id == event.target.value) !== -
                    1) {
                    tenonefantasy_challengeIds.splice(ten_one_fantasy_challenge_id.findIndex(x => x
                        .ten_one_fantasy_challenge_id === event.target.value), 1);
                }
            }
            console.log(ten_one_fantasy_challenge_id);
        }
        // Five One Fantasy
        function addOrRemoveFiveOneFantasyChallenge(event) {
            if (event.target.checked) {
                let sort_order_val = document.getElementsByName('sort_order_' + event.target.value)[0].value;
                fiveonefantasy_challengeIds.push({
                    "five_one_fantasy_challenge_id": event.target.value,
                    "sort_order": sort_order_val
                });

            } else {
                if (fiveonefantasy_challengeIds.findIndex(x => x.five_one_fantasy_challenge_id == event.target.value) !== -
                    1) {
                    fiveonefantasy_challengeIds.splice(five_one_fantasy_challenge_id.findIndex(x => x
                        .five_one_fantasy_challenge_id === event.target.value), 1);
                }
            }
            console.log(five_one_fantasy_challenge_id);
        }
        // Handle form submission event
        $('#challengesDatatableForm').on('submit', function(e) {
            var form = this;
            $.each(challengeIds, function(index, rowId) {
                $(form).append(
                    $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', 'challenge_ids[]')
                    .val(JSON.stringify(rowId))
                );
            });

            // Ten One Fantasy
            $.each(tenonefantasy_challengeIds, function(index, rowId) {
                $(form).append(
                    $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', 'ten_one_fantasy_challenge_id[]')
                    .val(JSON.stringify(rowId))
                );
            });
            // Five One Fantasy
            $.each(fiveonefantasy_challengeIds, function(index, rowId) {
                $(form).append(
                    $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', 'five_one_fantasy_challenge_id[]')
                    .val(JSON.stringify(rowId))
                );
            });

            // Live Fantasy
            $.each(livefantasy_challengeIds, function(index, rowId) {
                $(form).append(
                    $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', 'live_fantasy_challenge_id[]')
                    .val(JSON.stringify(rowId))
                );
            });

            // Batting Fantasy
            $.each(battingfantasy_challengeIds, function(index, rowId) {
                $(form).append(
                    $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', 'batting_fantasy_challenge_id[]')
                    .val(JSON.stringify(rowId))
                );
            });

            // Bowling Fantasy
            $.each(bowlingfantasy_challengeIds, function(index, rowId) {
                $(form).append(
                    $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', 'bowling_fantasy_challenge_id[]')
                    .val(JSON.stringify(rowId))
                );
            });

            // Reverse Fantasy
            $.each(reversefantasy_challengeIds, function(index, rowId) {
                $(form).append(
                    $('<input>')
                    .attr('type', 'hidden')
                    .attr('name', 'reverse_fantasy_challenge_id[]')
                    .val(JSON.stringify(rowId))
                );
            });



        });

        function addIfChecked() {
            var checkboxes = document.querySelectorAll("input[type='checkbox'][name='challenge_id']:checked");

            for (var j = 0; j < checkboxes.length; j++) {
                if (challengeIds.findIndex(x => x.challenge_id == checkboxes[j].value) === -1) {
                    let sort_order_val = document.getElementsByName('sort_order_' + checkboxes[j].value)[0].value;
                    challengeIds.push({
                        "challenge_id": checkboxes[j].value,
                        "sort_order": sort_order_val
                    });
                }
            }

            // Batting Fantasy
            var checkboxes_batting = document.querySelectorAll(
                "input[type='checkbox'][name='batting_fantasy_challenge_id']:checked");

            for (var j = 0; j < checkboxes_batting.length; j++) {
                if (battingfantasy_challengeIds.findIndex(x => x.batting_fantasy_challenge_id == checkboxes_batting[j]
                        .value) === -1) {
                    let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_batting[j].value)[0].value;
                    battingfantasy_challengeIds.push({
                        "batting_fantasy_challenge_id": checkboxes_batting[j].value,
                        "sort_order": sort_order_val
                    });
                }
            }

            // Bowling Fantasy
            var checkboxes_bowling = document.querySelectorAll(
                "input[type='checkbox'][name='bowling_fantasy_challenge_id']:checked");

            for (var j = 0; j < checkboxes_bowling.length; j++) {
                if (bowlingfantasy_challengeIds.findIndex(x => x.bowling_fantasy_challenge_id == checkboxes_bowling[j]
                        .value) === -1) {
                    let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_bowling[j].value)[0].value;
                    bowlingfantasy_challengeIds.push({
                        "bowling_fantasy_challenge_id": checkboxes_bowling[j].value,
                        "sort_order": sort_order_val
                    });
                }
            }

            // Reverse Fantasy
            var checkboxes_reverse = document.querySelectorAll(
                "input[type='checkbox'][name='reverse_fantasy_challenge_id']:checked");

            for (var j = 0; j < checkboxes_reverse.length; j++) {
                if (reversefantasy_challengeIds.findIndex(x => x.reverse_fantasy_challenge_id == checkboxes_reverse[j]
                        .value) === -1) {
                    let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_reverse[j].value)[0].value;
                    reversefantasy_challengeIds.push({
                        "reverse_fantasy_challenge_id": checkboxes_reverse[j].value,
                        "sort_order": sort_order_val
                    });
                }
            }

            // Ten One Fantasy
            var checkboxes_tenone = document.querySelectorAll(
                "input[type='checkbox'][name='ten_one_fantasy_challenge_id']:checked");
            console.log(checkboxes_tenone.length);
            for (var j = 0; j < checkboxes_tenone.length; j++) {
                if (tenonefantasy_challengeIds.findIndex(x => x.ten_one_fantasy_challenge_id == checkboxes_tenone[j]
                        .value) === -1) {
                    let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_tenone[j].value)[0].value;
                    tenonefantasy_challengeIds.push({
                        "ten_one_fantasy_challenge_id": checkboxes_tenone[j].value,
                        "sort_order": sort_order_val
                    });
                }
            }
            // Five One Fantasy
            var checkboxes_fiveone = document.querySelectorAll(
                "input[type='checkbox'][name='five_one_fantasy_challenge_id']:checked");
            console.log(checkboxes_fiveone.length);
            for (var j = 0; j < checkboxes_fiveone.length; j++) {
                if (fiveonefantasy_challengeIds.findIndex(x => x.five_one_fantasy_challenge_id == checkboxes_fiveone[j]
                        .value) === -1) {
                    let sort_order_val = document.getElementsByName('sort_order_' + checkboxes_fiveone[j].value)[0].value;
                    fiveonefantasy_challengeIds.push({
                        "five_one_fantasy_challenge_id": checkboxes_fiveone[j].value,
                        "sort_order": sort_order_val
                    });
                }
            }

            document.getElementById("launchButton").disabled = false;
        }

        $(document).ready(function() {
            @if (!empty($allchallengecategory))
                @foreach ($allchallengecategory as $challenge_category)
                    $('#dataList_{{ $loop->index }}').DataTable({
                        order: [0, 'desc'],
                        "iDisplayLength": 1000,
                        "processing": true,
                        "serverSide": true,
                        "ajax": {
                            url: "{{ route($modelName . '.view_challenges') }}",
                            type: "POST",
                            data: {
                                "_token": "{{ csrf_token() }}",
                                "categoryId": "<?php echo base64_encode(serialize($challenge_category->id)); ?>",
                                "is_update": "<?= $is_editable_input ?>",
                                "matchkey": "{{ $matchkey }}",
                                "sport_type": "{{ $sport_type }}"
                            }
                        },
                        "columns": [{
                                data: '#',
                                name: '#'
                            },
                            {
                                data: 'DT_RowIndex',
                                name: 'DT_RowIndex'
                            },
                            @if (!empty($livefantasy))
                                {
                                    data: 'live_fantasy',
                                    name: 'live_fanasy'
                                },
                            @endif
                            @if (!empty($battingfantasy))
                                {
                                    data: 'batting_fantasy',
                                    name: 'batting_fantasy'
                                },
                            @endif
                            @if (!empty($bowlingfantasy))
                                {
                                    data: 'bowling_fantasy',
                                    name: 'bowling_fantasy'
                                },
                            @endif
                            @if (!empty($reversefantasy))
                                {
                                    data: 'reverse_fantasy',
                                    name: 'reverse_fantasy'
                                },
                            @endif
                            @if (!empty($tenOneFantasy))
                                {
                                    data: 'tenone_fantasy',
                                    name: 'tenone_fantasy'
                                },
                            @endif
                            @if (!empty($fiveOneFantasy))
                                {
                                    data: 'fiveone_fantasy',
                                    name: 'fiveone_fantasy'
                                },
                            @endif {
                                data: 'sort_order',
                                name: 'sort_order'
                            },
                            {
                                data: 'win_amount',
                                name: 'win_amount'
                            },
                            {
                                data: 'entryfee',
                                name: 'entryfee'
                            },
                            {
                                data: 'sport_type',
                                name: 'sport_type'
                            },
                            {
                                data: 'challenge_type',
                                name: 'challenge_type'
                            },
                            {
                                data: 'maximum_user',
                                name: 'maximum_user'
                            },
                            {
                                data: 'winning_percentage',
                                name: 'winning_percentage'
                            },
                            {
                                data: 'multi_entry',
                                name: 'multi_entry'
                            },
                            {
                                data: 'bonus',
                                name: 'bonus'
                            },
                            {
                                data: 'is_running',
                                name: 'is_running'
                            },
                            {
                                data: 'confirmed_challenge',
                                name: 'confirmed_challenge'
                            },
                            {
                                data: 'name',
                                name: 'name'
                            }
                        ],
                        "searching": false,
                        "bLengthChange": false,
                        "bFilter": true,
                        "ordering": false

                    });
                @endforeach
            @endif

            setTimeout(function() {
                addIfChecked();
            }, 10000);
        });
    </script>
@endsection
