@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>All Join Persons</h4>

            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">

                <li class="breadcrumb-item active">
                  <a href="javascript:void(0)">Matches</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">All Join Persons</a></li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">

            <div class="card" data-aos="fade-up">
                <div class="card-header">
                <h4>
                <a href="{{url('admin/matches/join-users-download-sheet/'.$matchkey.'/'.$sports_type)}}"> Download Join User Sheet</a></h4>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
	                                <th>S No.</th>
	                                <th>ID</th>
	                                <th>Challenge Name</th>
	                                <th>Entry Fees</th>
	                                <th>Win Amt.</th>
	                                <th>Joined Users</th>
	                                <th>Max Capacity</th>
	                                <th>Challenge Type</th>
                                  <th>Is Flexible</th>
	                                <th>Action</th>
	                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
	                                <th>S No.</th>
	                                <th>ID</th>
	                                <th>Challenge Name</th>
	                                <th>Entry Fees</th>
	                                <th>Win Amt.</th>
	                                <th>Joined Users</th>
	                                <th>Max Capacity</th>
	                                <th>Challenge Type</th>
                                  <th>Is Flexible</th>
	                                <th>Action</th>
	                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!----Show Data By Ajax----->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      //order: [1, 'DESC'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.join_users',[$matchkey,$sports_type])}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'matchchallenges_id', name: 'matchchallenges_id'},
            {data: 'matchchallenges_win_amount', name: 'matchchallenges_win_amount'},
            {data: 'matchchallenges_entryfee', name: 'matchchallenges_entryfee'},
            {data: 'matchchallenges_win_amount', name: 'matchchallenges_win_amount'},
            {data: 'total', name: 'total'},
            {data: 'matchchallenges_maximum_user', name: 'matchchallenges_maximum_user'},
            {data: 'challenge_type', name: 'challenge_type'},
            {data: 'matchchallenges_is_flexible', name: 'matchchallenges_is_flexible'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
});
</script>
@endsection
