@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>


<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Matches List</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.matchmapping')}}">All Matches</a></li>
                <li class="breadcrumb-item">Match Detail</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4>All Matches</h4>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                      <select name="filter_status" id="filter_status" class="form-control">
                        <option value="">Select Type</option>
                        <option value="">All Match</option>
                        <option value="pending">pending</option>
                        <option value="IsReviewed">Reviewed</option>
                        <option value="winnerdeclared">Completed</option>
                    </select>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Match Name</th>
                                <th>Match Status</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>Match Name</th>
                                <th>Match Status</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@php $id=base64_encode(serialize($id)); @endphp
<script type="text/javascript">
$(document).ready(function() {

    let status = '';
    allMatchDetail(status);
    $(document).on('change','#filter_status', function(){
        let matchStatus = $(this).val().trim();
        $('#dataList').DataTable().clear().destroy();
        allMatchDetail(matchStatus);

    });


    /*$('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.match_detail',$id)}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}",""}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'match_name', name: 'match_name'},
            {data: 'match_status', name: 'match_status'},
        ]
    });*/
});

function allMatchDetail(matchStatus){
    $('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.match_detail',$id)}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}","matchStatus":matchStatus}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'match_name', name: 'match_name'},
            {data: 'match_status', name: 'match_status'},
        ]
    });
}

</script>
<script type="text/javascript">
    function updateplayer(id,credit){
        onConfirm: function (event, element) {
        	element.closest('form').submit();
    	}
	}
</script>
@endsection
