@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>


<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Matches</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.matchmapping')}}">All Matches</a></li>
                <li class="breadcrumb-item">Match Result</li>
            </ol>
        </div>
    </div>

<!-- <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
            <div class="card-header"><h4>View All Match Results</h4> </div>
                <div class="card-body">
                    <div class="basic-form">

                            <div class="form-group">
                                <div class="col-md-7 card mb-0 float-left" data-aos="fade-up">
                                    <div class="card-body">
                                        <h4 class="lbl_frm py-2 mb-0">Select Series</h4>
                                        <select class="form-control in_text bor-input" name="matchid" onchange="this.form.submit()">
                                    <option value="">  </option>
                                    @if(!empty($findalllistmatches))
                                    @foreach($findalllistmatches as $matches)
                                    <option value="{{$matches->matchkey}}" >{{ucwords($matches->matchname)}}</option>
                                    @endforeach
                                    @endif
                                </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 card mb-0 b_shad_n " data-aos="fade-up">
                                <div class="card-body">
                                    <button class="btn btn-primary mr-3" type="submit"><i class="fa fa-search mr-2"></i>Search</button>
                                    <a href="#" class="btn btn-gray"><i class="fa fa-repeat mr-2"></i>Reset</a>
                                </div>
                            </div>

                    </div>
                </div>
            </div>
        </div>
    </div> -->


    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4>All Matches</h4>
                  <!-- <a href="{{route('Series.add')}}" class="btn btn-primary btn-sm"> Add New {{$modelName}}</a> -->
                   <a href="{{route($modelName.'.import_schedule_data')}}" class="btn btn-primary btn-sm">Import data from API </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Series Name</th>
                                <th>No Of Matches</th>
                                <th>Winner Declare Require</th>
                                <th>Date</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>Series Name</th>
                                <th>No Of Matches</th>
                                <th>Winner Declare Require</th>
                                <th>Date</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      //order: [1, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.matchresult')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'series_name', name: 'series_name'},
            {data: 'totalmatch', name: 'totalmatch'},
            {data: 'findalllistmatches', name: 'findalllistmatches'},
            {data: 'created_at', name: 'created_at'},
        ]
    });
});
</script>
@endsection
