@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0 aos-init aos-animate" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Update Pointes</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                    <a href="{{route($modelName.'.matchmapping')}}">All Matches</a></li>
                <li class="breadcrumb-item">Update Pointes</li>
            </ol>
        </div>
    </div>
    <div class="row">
      <div class="col-12">
        <div class="card" data-aos="fade-up">
          <div class="card-header">
              <h4>Update Pointes</h4>
          </div>
          <div class="card-body">
            <div class="table-responsive">
                <table id="example" class="example-style cell-border pb-0" style="min-width: 845px">
                    <thead>
                        <tr>
                        <th>Match Key</th>
                        <th>Team Key</th>
                        <th>Team Name</th>
                        <th>Player Key</th>
                        <th>Player Name</th>
                        <th>Player Role</th>
                        <!-- <th>Action</th> -->
                    </tr>
                    </thead>
                    <tbody>
                        @if(count($match_scores)>0)
                        @foreach($match_scores as $match_scores_batting)
                        <tr class="thead-primary">
                          <td>{{$match_scores_batting->matchplayers_matchkey}}</td>
                          <td>{{$match_scores_batting->teams_team_key}}</td>
                          <td>
                            {{$match_scores_batting->teams_team}}
                          </td>
                          <td>{{$match_scores_batting->players_player_key}}</td>
                          <td>{{$match_scores_batting->matchplayers_name}}</td>
                          <td>{{$match_scores_batting->matchplayers_role}}</td>
                        </tr>
                        @endforeach
                        @endif
                      </tbody>
                    <tfoot>
                        <tr>
                        <th>Match Key</th>
                        <th>Team Key</th>
                        <th>Team Name</th>
                        <th>Player Key</th>
                        <th>Player Name</th>
                        <th>Player Role</th>
                    </tr>
                    </tfoot>
                </table>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-12">
        <div class="card" data-aos="fade-up">
          <div class="card-header">
              <h4>Edit Points</h4>
          </div>
          <div class="card-body">
            <div class="pt-3">
              <div class="settings-form">
                <form action="{{route($modelName.'.player_points',$match_scores[0]->matchplayers_matchkey,$match_scores[0]->matchplayers_playerid)}}" id="EditPointForm" method="post">
                    @csrf
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Start Point</label>
                              <input type="text" id="starting11" name="starting11" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->starting11}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Dismisal Info</label>
                              <input class="form-control in_text" autocomplete="off" id="out_str" name="out_str" type="text" value="{{$match_scores[0]->out_str}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Batting Run</label>
                              <input type="text" id="runs" name="runs" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->runs}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Batting Ball</label>
                              <input class="form-control in_text" autocomplete="off" id="bball" name="bball" type="text" value="{{$match_scores[0]->bball}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Fours</label>
                              <input type="text" id="fours" name="fours" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->fours}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Six</label>
                              <input class="form-control in_text" autocomplete="off" id="six" name="six" type="text" value="{{$match_scores[0]->six}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Overs</label>
                              <input type="text" id="overs" name="overs" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->overs}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Maidens</label>
                              <input class="form-control in_text" autocomplete="off" id="maiden_over" name="maiden_over" type="text" value="{{$match_scores[0]->maiden_over}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Balling Balls</label>
                              <input type="text" id="balls" name="balls" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->balls}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Wickets</label>
                              <input class="form-control in_text" autocomplete="off" id="grun" name="wicket" type="text" value="{{$match_scores[0]->wicket}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Zeros</label>
                              <input type="text" id="balldots" name="balldots" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->balldots}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Extra</label>
                              <input class="form-control in_text" autocomplete="off" id="extra" name="extra" type="text" value="{{$match_scores[0]->extra}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Catch</label>
                              <input type="text" id="catch" name="catch" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->catch}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Stumbed</label>
                              <input class="form-control in_text" autocomplete="off" id="stumbed" name="stumbed" type="text" value="{{$match_scores[0]->stumbed}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Run Outs</label>
                              <input type="text" id="runouts" name="runouts" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->runouts}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Man Of Match</label>
                              <input class="form-control in_text" autocomplete="off" id="man_of_match" name="man_of_match" type="text" value="{{$match_scores[0]->man_of_match}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Batting Points</label>
                              <input type="text" id="batting_points" name="batting_points" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->batting_points}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Bowling Points</label>
                              <input class="form-control in_text" autocomplete="off" id="bowling_points" name="bowling_points" type="text" value="{{$match_scores[0]->bowling_points}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Fielding Points</label>
                              <input type="text" id="fielding_points" name="fielding_points" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->fielding_points}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Extra Points</label>
                              <input class="form-control in_text" autocomplete="off" id="extra_points" name="extra_points" type="text" value="{{$match_scores[0]->extra_points}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Negative Points</label>
                              <input type="text" id="negative_points" name="negative_points" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->negative_points}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Strike Rate</label>
                              <input class="form-control in_text" autocomplete="off" id="strike_rate" name="strike_rate" type="text" value="{{$match_scores[0]->strike_rate}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="form-row">
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Economy Rate</label>
                              <input type="text" id="economy_rate" name="economy_rate" autocomplete="off" class="form-control in_text" value="{{$match_scores[0]->economy_rate}}" onkeypress="return isNumberKey(event)">
                          </div>
                          <div class="form-group col-md-6">
                              <label class="lbl_frm py-2">Total Points</label>
                              <input class="form-control in_text" autocomplete="off" id="total_points" name="total_points" type="text" value="{{$match_scores[0]->total_points}}" onkeypress="return isNumberKey(event)">
                          </div>
                      </div>
                      <div class="py-2">
                      <button type="submit" class="btn btn-primary mr-2">Submit</button>
                      <button class="btn btn-gray" type="button">Cancel</button></div>
                      </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
