@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Winner users list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="javascript:void(0)">All Matches</a></li>
                <li class="breadcrumb-item">Winners</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
            <div class="card-header"><h4>All Winners</h4></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered dataTable no-footer" id="dataList " role="grid" aria-describedby="datatable_info">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Username</th>
                                <th>UserEmail</th>
                                <th>UserMobile</th>
                                <th>UserTeamName</th>
                                <th>ChallengeID</th>
                                <th>IsJoin</th>
                                <th>IsRefund</th>
                                <th>Iswin</th>
                                <th>Userid</th>
                                <!-- <th>JoinDate</th> -->
                                <th>RefundDate</th>
                                <th>WinDate</th>
                                <th>TeamRank</th>
                                <th>RefundAmount</th>
                                <th>Winamount</th>
                                <th>TotalPoints</th>
                                <th>ChallengeName</th>
                                <th>EntryFee</th>
                                <th>ConfirmedLeauge</th>
                                <th>MaximumUsers</th>
                                <th>IsPrivate</th>
                                <th>MaxNumberofwinners</th>
                                <th>Joined users</th>
                                <th>IsGrand</th>
                            </tr>
                            </thead>

                            <tfoot>
                              <tr>
                              <th>S No.</th>
                              <th>Username</th>
                              <th>UserEmail</th>
                              <th>UserMobile</th>
                              <th>UserTeamName</th>
                              <th>ChallengeID</th>
                              <th>IsJoin</th>
                              <th>IsRefund</th>
                              <th>Iswin</th>
                              <th>Userid</th>
                              <!-- <th>JoinDate</th> -->
                              <th>RefundDate</th>
                              <th>WinDate</th>
                              <th>TeamRank</th>
                              <th>RefundAmount</th>
                              <th>Winamount</th>
                              <th>TotalPoints</th>
                              <th>ChallengeName</th>
                              <th>EntryFee</th>
                              <th>ConfirmedLeauge</th>
                              <th>MaximumUsers</th>
                              <th>IsPrivate</th>
                              <th>MaxNumberofwinners</th>
                              <th>Joined users</th>
                              <th>IsGrand</th>
                          </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
      $(document).ready(function() {

        $('#dataList').DataTable().clear().destroy(); //clear table data Table

        $('#dataList').DataTable({
          order: [0, 'desc'],
            "processing": true,
            "serverSide": true,
            "ajax":{
              url:"{{route($modelName.'.view-winners',['matchkey'=>$matchkey])}}",
              type: "POST",
              data : {"_token": "{{ csrf_token() }}"}

            },
            "columns": [
                {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                {data: 'username', name: 'username'},
                {data: 'email', name: 'email'},
                {data: 'mobile', name: 'mobile'},
                {data: 'team', name: 'team'},
                {data: 'challengeid', name: 'challengeid'},
                {data: 'isjoin', name: 'isjoin'},
                {data: 'isrefund', name: 'isrefund'},
                {data: 'iswin', name: 'iswin'},
                {data: 'userid', name: 'userid'},
                {data: 'refunddate', name: 'refunddate'},
                {data: 'windate', name: 'windate'},
                {data: 'rank', name: 'rank'},
                {data: 'refundamount', name: 'refundamount'},
                {data: 'winamount', name: 'winamount'},
                {data: 'point', name: 'point'},
                {data: 'challengename', name: 'challengename'},
                {data: 'entryfee', name: 'entryfee'},
                {data: 'confirmedleauge', name: 'confirmedleauge'},
                {data: 'maximum_user', name: 'maximum_user'},
                {data: 'is_private', name: 'is_private'},
                {data: 'maximum_number_of_winners', name: 'maximum_number_of_winners'},
                {data: 'joinedusers', name: 'joinedusers'},
                {data: 'isgrand', name: 'isgrand'},
            ]
         });
      });
</script>

@endsection
