@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <style>
        .toggle {
            --width: 80px;
            --height: calc(var(--width) / 3);

            position: relative;
            display: inline-block;
            width: var(--width);
            height: var(--height);
            box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.3);
            border-radius: var(--height);
            cursor: pointer;
        }

        .toggle input {
            display: none;
        }

        .toggle .slider {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border-radius: var(--height);
            background-color: #d34343;
            transition: all 0.4s ease-in-out;
        }

        .toggle .slider::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: calc(var(--height));
            height: calc(var(--height));
            border-radius: calc(var(--height) / 2);
            background-color: #fff;
            box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.3);
            transition: all 0.4s ease-in-out;
        }

        .toggle input:checked+.slider {
            background-color: green;
        }

        .toggle input:checked+.slider::before {
            transform: translateX(calc(var(--width) - var(--height)));
        }

        .toggle .labels {
            position: absolute;
            top: 5px;
            left: 0px;
            width: 100%;
            height: 100%;
            font-size: 13px;
            font-family: sans-serif;
            transition: all 0.4s ease-in-out;
        }

        .toggle .labels::after {
            /* content: attr(data-off); */
            content: "Deactive";
            position: absolute;
            right: 5px;
            color: #fff;
            opacity: 1;
            font-size: 12px;
            font-family: sans-serif;
            text-align: center;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.4);
            transition: all 0.4s ease-in-out;
        }

        .toggle .labels::before {
            /* content: attr(data-on); */
            content: "Active";
            position: absolute;
            left: 5px;
            color: #ffffff;
            font-size: 12px;
            font-family: sans-serif;
            opacity: 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.4);
            transition: all 0.4s ease-in-out;
        }

        .toggle input:checked~.labels::after {
            opacity: 0;
        }

        .toggle input:checked~.labels::before {
            opacity: 1;
        }
    </style>
    <!--**********************************
        Content body start
    ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Edit Series</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.viewleader') }}">All Leaderboards</a>
                    </li>
                    <li class="breadcrumb-item">Edit</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Promoter Leaderboard</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.edit', base64_encode(serialize($series->id))) }}"
                                id="leaderboardEditForm" method="post">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Leaderboard Name</label>
                                        <input type="text" class="form-control in_text" name="name" id="name"
                                            placeholder="Name" value="{{ $series->name }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('name'); ?>
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Select Sport Type</label>
                                        <select class="form-control in_text sport_types" name="sport_type">
                                            <option value="">Select Sport</option>
                                            @foreach ($sport_types as $key => $value)
    <option value="{{ $value->id }}" <?php //if($series->sport_type==$value->id){ echo 'selected'; }
    ?>>{{ $value->sport_name }}</option>
    @endforeach
                                        </select>
                                        <div class="error-message help-inline">
                                         <?php //echo $errors->first('sport_type');
                                         ?>
                                       </div>
                                    </div>
                                </div> -->

                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Start Date</label>
                                        <input class="form-control datetimepickerget in_text" id="start_date"
                                            value="{{ $series->start_date }}" autocomplete="off" placeholder="Start date"
                                            name="start_date" aria-describedby="inputSuccess2Status2" type="text"
                                            value="{{ $series->start_date }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('start_date'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">End Date</label>
                                        <input class="form-control datetimepickerget in_text" id="end_date"
                                            placeholder="End date" autocomplete="off" value="{{ $series->end_date }}"
                                            name="end_date" aria-describedby="inputSuccess2Status2" type="text"
                                            value="{{ $series->end_date }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('end_date'); ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Status</label>
                                    <label class="switch">
                                      <input class="form-control"  type="checkbox" onclick="return confirm('Are you sure Change Status?')" name="status" id="togBtn" value="">
                                      <span class="slider round"></span>
                                    </label>

                                </div>
                            </div> -->

                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Leaderboard Status</label>
                                        <label class="toggle mt-2 ml-2">
                                            <input class="form-control" type="checkbox" name="status" id="togBtn"
                                                value="">
                                            <span class="slider"></span>
                                            <span class="labels" data-on="ON" data-off="OFF"></span>
                                        </label>

                                    </div>
                                </div>


                                <div class="py-2">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#start_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d H:i:s'
            });
            $('#end_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d H:i:s'
            });
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });

            // Get Status Value ;
            var inval = "";
            var activate = " <?php echo $series->status; ?>";
            if (activate == 1) {
                $("#togBtn").prop('checked', true);
                inval = document.getElementById("togBtn").value = "1";
            } else {
                $("#togBtn").prop('checked', false);
                inval = document.getElementById("togBtn").value = "0";
            }

            // Get Status Value End ;

            $("#togBtn").on('change', function() {
                if ($(this).is(':checked')) {
                    switchStatusOn = $(this).is(':checked');
                    if (switchStatusOn == true) {
                        inval = document.getElementById("togBtn").value = "1";
                    }
                } else {
                    switchStatusoff = $(this).is(':checked');
                    if (switchStatusoff == false) {
                        inval = document.getElementById("togBtn").value = "0";
                    }
                }
            });
        });
    </script>

    <!--**********************************
        Content body end
    ***********************************-->
@endsection
