@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    @php
        $email = @$_GET['email'] ?? '';
        $total_records = @$total_records ?? '';
    @endphp

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>All Players list</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">Players</a></li>
                </ol> -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">

                <h4>All Promotors</h4>
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <!-- <a href="{{ route('Series.add') }}" class="btn btn-primary btn-sm"> Add New {{ $modelName }}</a> -->


                        <div class="col-12">
                            <form action="{{ route($modelName . '.details') }}" id="searchPromotorsDetails" method="get">

                                <div class="form-group mb-0">
                                    <div class="row">
                                        <label>Email</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="email" id="email"
                                                class="pull-left form-control w-95" value="{{ $email }}">
                                            <input type="hidden" id="#updateInput" name="updateInput" value="0">
                                            <input type="hidden" id="#refer_id" name="refer_id"
                                                value="{{ $refer_id }}">
                                            <button name="get-promotor-details" type="submit"
                                                class="btn btn-primary mt-3">Submit</button>
                                            @if (!empty($total_records))
                                                <button name="get-promotor-details" id="updatePromotorsDetails"
                                                    type="submit" class="btn btn-primary mt-3">Update amount</button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <div class="card-footer py-4">
                                <form action="{{ route($modelName . '.download') }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="email"
                                        value="{{ isset($email) && !empty($email) ? $email : '' }}">
                                    <button type="submit" class="btn btn-primary btn-sm mt-3"
                                        style="height: 40px!important;"><i class="fa fa-file-excel-o mr-2"></i> Download
                                        CSV</button>
                                </form>
                            </div>
                        </div>


                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="dataList" class="display" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>S. NO</th>
                                        <th>ENTRY FEE</th>
                                        <th>WIN AMOUNT</th>
                                        <th>JOINED USERS</th>
                                        <th>EARNED AMOUNT</th>
                                        <th>DATE</th>

                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>S. NO</th>
                                        <th>ENTRY FEE</th>
                                        <th>WIN AMOUNT</th>
                                        <th>JOINED USERS</th>
                                        <th>EARNED AMOUNT</th>
                                        <th>DATE</th>
                                    </tr>
                                </tfoot>
                                <?php

                             if(!empty($pages)){
                              ?>
                                <nav aria-label="Page navigation">
                                    <ul class="pagination ">
                                        <?php $offset_val = $offset_value - 1; ?>
                                        <li class="page-item"><a data-page_no="{{ $offset_val }}" class="page-link"
                                                href="javascript:void(0);">Previous</a></li>



                                        <?php
                                $pageValue = 1;
                                if(isset($_GET['page'])){
                                  $pageValue = $_GET['page'];
                                }
// $nextPages = $pageValue + 3;
// $lastPages = $pages - 3;
                               for ($i=1; $i<=$pages; $i++) {
                                      $offset=$i;

                                   ?>
                                        <!-- onclick="addActive('pageItem_<?= $i ?>') -->
                                    <li id="pageItem_<?= $i ?>" class="pageNumber page-item <?php if ($i == $pageValue) {
                                        echo 'active';
                                    } ?>" >
                                          <a data-page_no="{{ $offset }}" class="page-link" href="javascript:void(0);" >
                                            {{ $i }}
                                        </a>
                                      </li>

                                    <?php if($i == $pages - 1){ ?>
                                    <li class="page-item"><p class="page-link removeActive" onClick="this.disabled=true;"  >...</p></li>
                                    <?php } ?>

                                    <?php
                                  }    if($offset_value!=$pages){ $offset_val=$offset_value+1; ?>
                                    <!-- <li class="page-item"><a data-page_no="{{ $offset_val }}" class="page-link" href="javascript:void(0);">Next</a></li> -->
                                        <?php } ?>


                                        <li class="page-item"><a data-page_no="{{ $offset_val }}" class="page-link"
                                                href="javascript:void(0);">Next</a></li>
                                    </ul>
                                </nav>
                                <?php } ?>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!----------------Player Credit-------------------------------->
    <!-- Modal -->
    <!--  -->
    <!--End Modal -->
    <!--------------------End Player Credit---------------------------->

    <script type="text/javascript">
        function addActive(id) {
            $(".pageNumber").removeClass("active");
            var element = document.getElementById(id);
            element.classList.add("active");
            hidePageNumber();
        }

        function hidePageNumber() {

            let pageNumber = 1;
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);

            if (urlParams.get('page') != null) {
                console.log(urlParams)
                pageNumber = urlParams.get('page')
                console.log("pageNumber")
                console.log(urlParams.get('page'))
            }
            console.log("pageNumber")



            //  $pageValue = $_GET['page'];
            // $nextPages = $pageValue + 3;
            // $lastPages = $pages - 3;
            $(".pageNumber").hide();
            var nextPageNumber = parseInt(pageNumber) + 5;
            for (let p = pageNumber; p < nextPageNumber; p++) {
                $("#pageItem_" + p).show();

            }

            let lastPageNumber = '<?= $pages ?>';

            $("#pageItem_default").show();
            $("#pageItem_" + parseInt(lastPageNumber)).show();

        }
        $(function(event) {
            var custom_page = 1;
            $(document).on('click', '.page-link', function(e) {
                custom_page = $(this).attr("data-page_no");
                getPageData(custom_page);
                addActive("pageItem_" + custom_page);
            });
        });

        function getPageData(custom_page = 1) {
            $('#dataList').DataTable().clear().destroy(); //clear table data Table
            var url = window.location.href.split('?')[0];
            history.pushState('', '', url + "?page=" + custom_page);
            $('#dataList').DataTable({
                order: [0, 'desc'],
                "processing": true,
                "serverSide": true,
                "bPaginate": false,
                "ajax": {
                    url: "{{ route($modelName . '.details') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "custom_page": custom_page,
                        "email": "{{ $email }}"
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'entryfee',
                        name: 'entryfee'
                    },
                    {
                        data: 'win_amount',
                        name: 'win_amount'
                    },
                    {
                        data: 'joinedusers',
                        name: 'joinedusers'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'created',
                        name: 'created'
                    },

                ]
            });
        }

        $(document).ready(function() {

            hidePageNumber();


            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            pageNumber = 1;
            if (urlParams.get('page') != null) {
                console.log(urlParams)
                pageNumber = urlParams.get('page')
                console.log("pageNumber")
                console.log(urlParams.get('page'))
            }



            var url = window.location.href.split('?')[0];
            history.pushState('', '', url + "?page=" + pageNumber + "&email={{ $email }}");

            $('#dataList').DataTable({
                order: [0, 'desc'],
                "processing": true,
                "serverSide": true,
                "bPaginate": false,
                "ajax": {
                    url: "{{ route($modelName . '.details') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "custom_page": pageNumber,
                        "email": "{{ $email }}"
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'entryfee',
                        name: 'entryfee'
                    },
                    {
                        data: 'win_amount',
                        name: 'win_amount'
                    },
                    {
                        data: 'joinedusers',
                        name: 'joinedusers'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'created',
                        name: 'created'
                    },

                ]
            });
        });
    </script>
    <script type="text/javascript">
        $(document).on('click', '#updatePromotorsDetails', function(event) {
            var a = $('input[name="updateInput"]').val('1');
        });
    </script>
@endsection
