@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All User Add Cash Amount List</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.view')}}">View all User</a></li>
                <li class="breadcrumb-item">Add Cash Summary</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header"> <h4>User Add Cash Summary</h4></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Transaction By</th>
                                <th>Amount</th>
                                <th>Payment status</th>
                                <th>Balance Bonus Amount</th>
                                <th>Balance Coin Amount</th>
                                <th>Balance Win Amount</th>
                                <th>Balance fund Amount</th>
                                <th>Total Available Amount</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>Transaction By</th>
                                <th>Amount</th>
                                <th>Payment status</th>
                                <th>Balance Bonus Amount</th>
                                <th>Balance Coin Amount</th>
                                <th>Balance Win Amount</th>
                                <th>Balance fund Amount</th>
                                <th>Total Available Amount</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@php
$id = base64_encode(serialize($id));
@endphp
<!--End Edit User Balance Modal -->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.add_cash_list',$id)}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'transaction_by', name: 'transaction_by'},
            {data: 'amount', name: 'amount'},
            {data: 'paymentstatus', name: 'paymentstatus'},
            {data: 'bal_bonus_amt', name: 'bal_bonus_amt'},
            {data: 'gstbonus_amt', name: 'gstbonus_amt'},
            {data: 'bal_win_amt', name: 'bal_win_amt'},
            {data: 'bal_fund_amt', name: 'bal_fund_amt'},
            {data: 'total_available_amt', name: 'total_available_amt'},
        ]
    });
});
</script>
@endsection
