@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Add User</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                    <a href="{{route($modelName.'.view')}}">View all User</a></li>
                <li class="breadcrumb-item"><a href="javascript::void(0);">Add User</a></li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Add New User</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form action="{{route($modelName.'.add_user')}}" id="AddUserForm" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Username</label>
                                    <input id="username" type="text" placeholder="enter username here" name="username" class="form-control in_text" value="">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('username'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Mobile</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="enter mobile no here" id="mobile" name="mobile" type="text" value="">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('mobile'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Email</label>
                                    <input id="email" type="text" placeholder="enter email here" name="email" class="form-control in_text" value="">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('email'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Gender</label>
                                    <div class="form-group row py-2">
                                        <label class="radio-inline frm_chk">
                                            <input type="radio" name="gender" value="male" class="mr-2">Male</label>
                                        <label class="radio-inline frm_chk">
                                            <input type="radio" name="gender" value="female" class="mr-2"> Female</label>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('gender'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Password</label>
                                    <input id="password" type="password" placeholder="enter password here" name="password" class="form-control in_text" value="">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('password'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Confirm Password</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="enter confirm password here" id="c_password" name="c_password" type="password" value="">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('c_password'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Image</label>
                                    <input type="file" class="form-control in_text" name="image[]">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('image'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Country</label>
                                    <input id="country" type="text" placeholder="enter country here" name="country" class="form-control in_text" >
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('country'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                 <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">States</label>
                                    <select class="form-control in_text" id="state" name="state" autocomplete="off">
                                        <option value=""> Select states </option>
                                        @if(isset($states) && !empty($states))
                                        @foreach($states as $statesval)
                                        <option value="<?php echo $statesval->id ?>">
                                        {{$statesval->name}}
                                        </option>
                                        @endforeach
                                        @endif
                                    </select>
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('state'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">city</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="enter city here" id="city" name="city" type="text" value="">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('city'); ?>
                                    </div>
                                </div>
                            </div>
                             <div class="form-row mb-3">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">DOB</label>
                                    <input class="form-control datetimepickerget in_text" autocomplete="off" placeholder="enter dob here" id="dob" name="dob" type="text" value="">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('dob'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Team</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="enter team name here" id="team" name="team" type="text" value="">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('team'); ?>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--**********************************
Content body end
***********************************-->
<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });
    });
</script>

@endsection
