@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>Add Money</h4>
                        <span class="ml-1">Layout</span>
                    </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <a href="{{ route($modelName . '.admin_wallet_action') }}">View Admin Wallet</a>
                    </li>
                    <li class="breadcrumb-item">Add Money</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add Money</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form method="post"
                                action="{{ route($modelName . '.add_moneyin_wallet', base64_encode(serialize($userbalanace->id))) }}"
                                enctype="multipart/form-data" id='AddAvatarsForm'>
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Amount</label>
                                        <input type="number" class="form-control in_text" name="amount" id="amount"
                                            placeholder="Enter amount here">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('amount'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Select Bonus Type</label>
                                        <select class="form-control in_text" id="bonustype" name="bonustype">
                                            <option value="addfund">Real Add Fund</option>
                                            <option value="addfund">AddFund</option>
                                            <option value="Unutilized">Unutilized</option>
                                            <option value="specialbonus">SpecialBonus</option>
                                            <option value="winning">Winning adjustment</option>
                                            <option value="gst_bonus">GST/TDS Bonus</option>
                                            <option value="promotional">Affiliation Amount</option>
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('bonustype'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="py-2">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
        Content body end
        ***********************************-->
    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>
@endsection
