@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Pan card verification requests list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Pan card verification requests list</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header"><h4>Address Verification Requests</h4></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>
                                  <input type="text" id="filter_username" name="filter_username" value="<?php echo @$_GET['filter_username']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_username')"><br>
                                  User Name</th>
                                  <th>
                                  <input type="text" id="filter_mobile" name="filter_mobile" value="<?php echo @$_GET['filter_mobile']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_mobile')"><br>
                                  User Mobile</th>
                                  <th>Document Type</th>
                                  <th>ID</th>


                                <th>Status</th>
                                  <th>Requested Date</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>User Name</th>
                                <th>User Mobile</th>
                                <th>Document Type</th>
                                <th>ID</th>
                                <th>Status</th>
                                <th>Requested Date</th>

                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="myModal">
  <div class="modal-dialog" role="document">
      <div class="modal-content">
          <div class="modal-header">
              <h4 class="modal-title">Address Verification Status</h4>
              <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
              </button>
          </div>
          <form name="submit_form" id="submit_form" method="post" action="{{route($modelName.'.verifyaddress_status')}}">
              {!! csrf_field() !!}
              <br>
              <div class="modal-row row m-auto" >
                <div class="modal-group col-md">
                  <label>Status</label>
                  <select name="status" id="status" class="form-control" required="required">
                    <option value="">Select Status </option>
                    <option value="0">Pending</option>
                    <option value="1">Verified</option>
                    <option value="2">Rejected</option>
                  </select>
                </div>
              </div>
              <br>
            <br>
              <div class="modal-footer col-md">
                <input type="hidden" name="id" id="id" value=""/>
                <input type="submit" class="btn btn-primary" name="submit" id="submit" value="Submit"/>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
              </div>
            </form>
      </div>
  </div>
</div>
<script type="text/javascript">

$(document).on('click', '.change_status', function () {

   $('#status').val('');
   $('#id').val($(this).data('id'));
   $('#myModal').modal('show');
 });

function cancelEvent(){
  event.stopPropagation();
}

var filtercolums = {

};

var input_filter_username = '';
var input_filter_mobile = '';


function updateURL(event , fieldname){
  var value = event.target.value;

  if(fieldname == 'filter_username'){
    input_filter_username = value;
  }
  if(fieldname == 'filter_mobile'){
    input_filter_mobile = value;
  }


  var url = window.location.href.split('?')[0];
  history.pushState('', '', url+"?filter_username="+input_filter_username+"&filter_mobile="+input_filter_mobile);

}
function filterData(event , fieldname){

  var value = event.target.value;
updateURL(event,fieldname);


if(fieldname == 'filter_username'){
  filtercolums['filter_username'] = value;
}

if(fieldname == 'filter_mobile'){
  filtercolums['filter_mobile'] = value;
}


$('#dataList').DataTable().clear().destroy(); //clear table data Table

$('#dataList').DataTable({
  // order: [0, 'desc'],
    "processing": true,
    "serverSide": true,
    "ajax":{
      url:"{{route($modelName.'.verify_address')}}",
      type: "POST",
      data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums}
    },
    "columns": [
        {data: 'DT_RowIndex', name: 'DT_RowIndex'},
        {data: 'username', name: 'username'},
        {data: 'mobile', name: 'mobile',sortable:false},
        {data: 'document_type', name: 'document_type'},
        {data: 'document_id', name: 'document_id'},
        {data: 'status', name: 'status'},
        {data: 'created', name: 'created'},
    ]
});

document.getElementById(fieldname).focus();

}

$(document).ready(function() {

  let filter_username = '<?php echo @$_GET['filter_username']; ?>';
  let filter_mobile = '<?php echo @$_GET['filter_mobile']; ?>';

  if(filter_username !==''){
    filtercolums['filter_username'] = filter_username;
  }
  if(filter_mobile !==''){
    filtercolums['filter_mobile'] = filter_mobile;
  }

    $('#dataList').DataTable({
      // order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.verify_address')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'username', name: 'username'},
            {data: 'mobile', name: 'mobile',sortable:false},
            {data: 'document_type', name: 'document_type'},
            {data: 'document_id', name: 'document_id'},
            {data: 'status', name: 'status'},
            {data: 'created', name: 'created'},
        ]
    });
});


</script>
@endsection
