@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <?php
    date_default_timezone_set('Asia/Kolkata'); ?>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Paytm Withdraw Requests</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">Paytm Withdraw Requests</a></li>
                </ol> -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <div class="card-body p-0">
                            <div class="basic-form">
                                <div class="form-row">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <h4>Bulk Add Cash</h4>
                                        </div>
                                    </div>

                                </div>
                                <form action="{{ route($modelName . '.bulk_add_cash') }}" id="filterdata" method="post">
                                    @csrf
                                    @php
                                        $transactionby = '';
                                    @endphp
                                    <div class="form-row">
                                        <div class="form-group col-md-2">
                                            <label>Select Wallet</lable>
                                                <select name="wallet" class="form-control">
                                                    <option value="">Select Wallet </option>
                                                    <option value="balance"
                                                        @if ($transactionby == 'balance') selected @endif> Deposit</option>
                                                    <option value="winning"
                                                        @if ($transactionby == 'winning') selected @endif> Winning</option>
                                                    <option value="bonus"
                                                        @if ($transactionby == 'bonus') selected @endif> Bonus</option>
                                                    <option value="affiliation_commission"
                                                        @if ($transactionby == 'affiliation_commission') selected @endif> Affiliation
                                                    </option>
                                                    <option value="gst_bonus"
                                                        @if ($transactionby == 'gst_bonus') selected @endif> GST/TDS Bonus
                                                    </option>
                                                </select>
                                        </div>
                                        <div class="form-group col-md-3">
                                            <label>Upload CSV</lable>
                                                <input type='file' id="add_cash_csv" accept=".csv" name="add_cash_csv"
                                                    class="form-control" />
                                        </div>
                                        <div class="form-group col-md-4">
                                            <p class="fund" style="margin-top: -20px;">&nbsp</p>
                                            <button type="submit" value="submit"
                                                class="btn btn-primary show-data">Submit</button>&nbsp;&nbsp;
                                            <a href="{{ route($modelName . '.bulk_add_cash') }}"
                                                class="btn btn-primary reset-data">Reset</a>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <p class="fund" style="margin-top: -20px;">&nbsp</p>

                                            <a href="<?php echo WEBSITE_UPLOADS_URL . 'sample_bulk_add_cash.csv'; ?>" class="btn btn-primary reset-data">Download Sample
                                                CSV</a>
                                        </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                    <th>S No.</th>
                                    <th>Mobile</th>
                                    <th>Wallet</th>
                                    <th>Amount</th>
                                    <th>Comment</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th>S No.</th>
                                    <th>Mobile</th>
                                    <th>Wallet</th>
                                    <th>Amount</th>
                                    <th>Comment</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            var users_type = '';
            usersWalletData(users_type);
        });
    </script>
    <script type="text/javascript">
        function usersWalletData(users_type) {

            let transaction_by = '';
            let end_date = '';
            let start_date = '';
            var data = {
                "_token": "{{ csrf_token() }}",
                "users_type": users_type,
                "transaction_by": transaction_by,
                "start_date": start_date,
                "end_date": end_date
            };

            $('#dataList').DataTable({
                //order: [1, 'DESC'],
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: "{{ route($modelName . '.get_bulk_add_cash') }}",
                    type: "POST",
                    data: data
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'wallet',
                        name: 'wallet'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'comment',
                        name: 'comment'
                    },
                    {
                        data: 'txn_info',
                        name: 'txn_info'
                    },
                    {
                        data: 'created',
                        name: 'created'
                    },
                ]
            });
        }
    </script>
@endsection
