@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Users Detail</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('Registerusers.view') }}">View All Users</a></li>
                    <li class="breadcrumb-item">Users Detail</li>
                </ol>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4>Users Detail</h4>
                    </div>
                    <div class="card-body col-md-6">
                        <div class="basic-form">
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">User ID</label>
                                <div class="col-sm-9">
                                    <input type="" class="form-control" value="{{ $allplayers->id }}" readonly="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Team</label>
                                <div class="col-sm-9">
                                    <input type="" class="form-control" value="{{ $allplayers->team }}"
                                        readonly="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">User Name</label>
                                <div class="col-sm-9">
                                    <input type="" class="form-control" value="{{ $allplayers->username }}"
                                        readonly="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Refer Code</label>
                                <div class="col-sm-9">
                                    <form action="{{ route($modelName . '.edit_details') }}" id="userUpdateDetailForm"
                                        method="POST">
                                        @csrf
                                        <div class="row no-gutters">
                                            <div class="col-md-10">
                                                <input type="hidden" name="id" value="{{ $allplayers->id }}">
                                                <input type="text" class="form-control" name="refercode" id="refercode"
                                                    value="{{ $allplayers->refercode }}">
                                            </div>
                                            <div class="col-md-2 pl-3 py-1 text-right">
                                                <input type="submit" name="edit" class="btn btn-primary" value="update">
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <!-- <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">Email</label>
                                    <div class="col-sm-9">
                                         <input type="" class="form-control" value="{{ $allplayers->email }}" readonly="">
                                    </div>
                                </div> -->
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Address</label>
                                <div class="col-sm-9">
                                    <input type="" class="form-control" value="{{ $allplayers->address }}"
                                        readonly="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Pincode</label>
                                <div class="col-sm-9">
                                    <input type="" class="form-control" value="{{ $allplayers->pincode }}"
                                        readonly="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">State</label>
                                <div class="col-sm-9">
                                    <input type="" class="form-control" value="{{ $allplayers->state }}"
                                        readonly="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">City</label>
                                <div class="col-sm-9">
                                    <input type="" class="form-control" value="{{ $allplayers->city }}"
                                        readonly="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Country</label>
                                <div class="col-sm-9">
                                    <input type="" class="form-control" value="{{ $allplayers->country }}"
                                        readonly="">
                                </div>
                            </div>
                            @if (isset($findpancardid) && !empty($findpancardid))
                                <?php $pan_id = $findpancardid->id; ?>
                            @else
                                <?php $pan_id = 0; ?>
                            @endif
                            <?php $panid = base64_encode(serialize($pan_id)); ?>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Pan Card</label>
                                <div class="col-sm-9">
                                    @if ($allplayers->pan_verify == -1)
                                        <span style="color:red;"><i class="fa fa-times-circle-o mr-2"></i>Not Send</span>
                                    @elseif($allplayers->pan_verify == 0)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_pan_details', $panid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Pending</a></span>
                                    @elseif($allplayers->pan_verify == 1)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_pan_details', $panid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Verified</a></span>
                                    @elseif($allplayers->pan_verify == 2)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_pan_details', $panid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Canceled</a></span>
                                    @endif
                                </div>
                            </div>
                            @if (isset($findbankcardid) && !empty($findbankcardid))
                                <?php $bank_id = $findbankcardid->id; ?>
                            @else
                                <?php $bank_id = 0; ?>
                            @endif
                            <?php $bankid = base64_encode(serialize($bank_id)); ?>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Bank Account</label>
                                <div class="col-sm-9">
                                    @if ($allplayers->bank_verify == -1)
                                        <span style="color:red;"><i class="fa fa-times-circle-o mr-2"></i>Not Send</span>
                                    @elseif($allplayers->bank_verify == 0)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_bank_details', $bankid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Pending</a></span>
                                    @elseif($allplayers->bank_verify == 1)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_bank_details', $bankid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Verified</a></span>
                                    @elseif($allplayers->bank_verify == 2)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_bank_details', $bankid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Canceled</a></span>
                                    @endif
                                </div>
                            </div>
                            @if (isset($findaadharcardid) && !empty($findaadharcardid))
                                <?php $aadhar_id = $findaadharcardid->id; ?>
                            @else
                                <?php $aadhar_id = 0; ?>
                            @endif
                            <?php $aadharid = base64_encode(serialize($aadhar_id)); ?>
                            <div class="form-group row">
                                <label class="col-sm-3 col-form-label">Aadhar Card</label>
                                <div class="col-sm-9">
                                    @if ($allplayers->aadhar_verify == -1)
                                        <span style="color:red;"><i class="fa fa-times-circle-o mr-2"></i>Not Send</span>
                                    @elseif($allplayers->aadhar_verify == 0)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_adhar_details', $aadharid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Pending</a></span>
                                    @elseif($allplayers->aadhar_verify == 1)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_adhar_details', $aadharid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Verified</a></span>
                                    @elseif($allplayers->aadhar_verify == 2)
                                        <span style="color:red;"><a
                                                href="{{ route($modelName . '.view_adhar_details', $aadharid) }}"
                                                style="text-decoration:underline;"><i
                                                    class="fa fa-times-circle-o mr-2"></i>Canceled</a></span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if (isset($bank) && !empty($bank))
            <div class="row">
                <div class="col-12">
                    <div class="card" data-aos="fade-up">
                        <div class="card-header">
                            <h4> Bank Account Verification </h4>
                        </div>
                        <div class="card-body">
                            <div class="basic-form">
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Account No.</label>
                                    <div class="col-sm-8">
                                        <input type="" class="form-control"
                                            value="{{ isset($bank->accno) && !empty($bank->accno) ? $bank->accno : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">IFSC</label>
                                    <div class="col-sm-8">
                                        <input type="" class="form-control"
                                            value="{{ isset($bank->ifsc) && !empty($bank->ifsc) ? $bank->ifsc : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Bank Name</label>
                                    <div class="col-sm-8">
                                        <input type="" class="form-control"
                                            value="{{ isset($bank->bankname) && !empty($bank->bankname) ? $bank->bankname : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Branch</label>
                                    <div class="col-sm-8">
                                        <input type="" class="form-control"
                                            value="{{ isset($bank->bankbranch) && !empty($bank->bankbranch) ? $bank->bankbranch : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">State</label>
                                    <div class="col-sm-8">
                                        <input type="" class="form-control"
                                            value="{{ isset($bank->state) && !empty($bank->state) ? $bank->state : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Bank Proof</label>
                                    <div class="col-sm-8">
                                        <img src="{{ isset($bank->image) && !empty($bank->image) ? $bank->image : '' }}"
                                            style="max-height:300px;">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Action</label>
                                    <div class="col-sm-8">
                                        <form action="{{ route($modelName . '.update_bank_status') }}"
                                            id="bankUpdateDetailForm" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <div class="row no-gutters">
                                                <div class="col">
                                                    <input type="hidden" name="id"
                                                        value="{{ isset($bank->id) && !empty($bank->id) ? $bank->id : '' }}">
                                                    <input type="text" class="form-control" name="comment"
                                                        id="comment" placeholder="Comment"
                                                        value="{{ isset($bank->comment) && !empty($bank->comment) ? $bank->comment : '' }}">
                                                </div>
                                                <div class="col pl-2">
                                                    <select class="form-control" name="status" id="status">
                                                        <option value="">Select Request action</option>
                                                        <option value="1">Verify Bank Account</option>
                                                        <option value="2"> Cancel Request </option>
                                                    </select>
                                                </div>
                                                <div class="col pl-3">
                                                    <input type="submit" name="edit_bank" class="btn btn-primary"
                                                        value="UPDATE">
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        @if (isset($pancard) && !empty($pancard))
            <div class="row">
                <div class="col-12">
                    <div class="card" data-aos="fade-up">
                        <div class="card-header">
                            <h4> Pan Card Verification </h4>
                        </div>
                        <div class="card-body">
                            <div class="basic-form">
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Pan Name</label>
                                    <div class="col-sm-8">
                                        <input type="" class="form-control"
                                            value="{{ isset($pancard->pan_name) && !empty($pancard->pan_name) ? $pancard->pan_name : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Pan Dob</label>
                                    <div class="col-sm-8">
                                        <input type="" class="form-control"
                                            value="{{ isset($pancard->pan_dob) && !empty($pancard->pan_dob) ? date('d M Y', strtotime($pancard->pan_dob)) : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Pan Card Number</label>
                                    <div class="col-sm-8">
                                        <input type="" class="form-control"
                                            value="{{ isset($pancard->pan_number) && !empty($pancard->pan_number) ? $pancard->pan_number : '' }}"
                                            readonly="">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Pan Proof</label>
                                    <div class="col-sm-8">
                                        <img src="{{ isset($pancard->image) && !empty($pancard->image) ? $pancard->image : '' }}"
                                            style="max-height:300px;">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-4 col-form-label">Action</label>
                                    <div class="col-sm-8">
                                        <form action="{{ route($modelName . '.update_pan_status') }}"
                                            id="panUpdateDetailForm" method="post">
                                            @csrf
                                            <div class="row no-gutters">
                                                <div class="col">
                                                    <input type="hidden" name="id"
                                                        value="{{ isset($pancard->id) && !empty($pancard->id) ? $pancard->id : '' }}">
                                                    <input type="text" class="form-control" name="comment"
                                                        id="comment" placeholder="Comment"
                                                        value="{{ isset($pancard->comment) && !empty($pancard->comment) ? $pancard->comment : '' }}">
                                                </div>
                                                <div class="col pl-2">
                                                    <select class="form-control" name="status" id="status">
                                                        <option value="">Select Request action</option>
                                                        <option value="1">Verify Pan Card Request</option>
                                                        <option value="2"> Cancel Request </option>
                                                    </select>
                                                </div>
                                                <div class="col pl-3">
                                                    <input type="submit" name="edit_pan" class="btn btn-primary"
                                                        value="UPDATE">
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection
