@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Paytm Withdraw Requests</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">Paytm Withdraw Requests</a></li>
                </ol> -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <div class="card-body p-0">
                            <div class="basic-form">
                                <form action="{{ route($modelName . '.upload_withdrawl_excel') }}" method="POST"
                                    id="panUpdateDetailForm" enctype="multipart/form-data">
                                    @csrf
                                    <div class="form-row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <h4>Manage OTP Limit</h4>
                                            </div>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="dataList" class="display" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <th>
                                            <input type="text" id="filter_mobile" name="filter_mobile"
                                                value="<?php echo @$_GET['filter_mobile']; ?>" onclick="cancelEvent()"
                                                onkeyup="filterData(event , 'filter_mobile')" autocomplete="off"><br>
                                            Mobile Number
                                        </th>
                                        <th>Count</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tfoot>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Mobile Number</th>
                                        <th>Count</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var fieldname = '';
        var filtercolums = {

        }


        function cancelEvent() {
            event.stopPropagation();
        }

        var filtercolums = {

        };

        var input_filter_mobile = '';

        function updateURL(event, fieldname) {
            var value = event.target.value;

            if (fieldname == 'filter_mobile') {
                input_filter_mobile = value;
            }


            var url = window.location.href.split('?')[0];
            history.pushState('', '', url + "?filter=1&filter_mobile=" + input_filter_mobile);

        }

        function filterData(event, fieldname) {

            var value = event.target.value;
            updateURL(event, fieldname);

            if (fieldname == 'filter_mobile') {
                filtercolums['filter_mobile'] = value;
            }


            //URL UPDATE


            $('#dataList').DataTable().clear().destroy(); //clear table data Table

            $('#dataList').DataTable({
                // order: [0, 'desc'],
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: "{{ route($modelName . '.manage_otp_limit') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "filter_columns": filtercolums
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'count',
                        name: 'count'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            document.getElementById(fieldname).focus();

        }
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataList').DataTable({
                // order: [0, 'desc'],
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: "{{ route($modelName . '.manage_otp_limit') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "filter_columns": filtercolums
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'count',
                        name: 'count'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

        });
    </script>
@endsection
