@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Pan card verification requests list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Pan card verification requests list</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header"><h4>UPI Verification Requests</h4></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>
                                  <input type="text" id="filter_username" name="filter_username" value="<?php echo @$_GET['filter_username']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_username')"><br>
                                  User Name</th>
                                <th>
                                  <input type="text" id="filter_email" name="filter_email" value="<?php echo @$_GET['filter_email']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_email')"><br>
                                  User Mobile</th>
                                  <th>Requested Date</th>
                                <th>Status</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>User Name</th>
                                <th>User Email</th>
                                <th>Requested Date</th>
                                <th>Status</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">


function cancelEvent(){
  event.stopPropagation();
}

var filtercolums = {

};

var input_filter_username = '';
var input_filter_email = '';


function updateURL(event , fieldname){
  var value = event.target.value;

  if(fieldname == 'filter_username'){
    input_filter_username = value;
  }
  if(fieldname == 'filter_email'){
    input_filter_email = value;
  }


  var url = window.location.href.split('?')[0];
  history.pushState('', '', url+"?filter_username="+input_filter_username+"&filter_email="+input_filter_email);

}
function filterData(event , fieldname){

  var value = event.target.value;
updateURL(event,fieldname);


if(fieldname == 'filter_username'){
  filtercolums['filter_username'] = value;
}

if(fieldname == 'filter_email'){
  filtercolums['filter_email'] = value;
}


$('#dataList').DataTable().clear().destroy(); //clear table data Table

$('#dataList').DataTable({
  // order: [0, 'desc'],
    "processing": true,
    "serverSide": true,
    "ajax":{
      url:"{{route($modelName.'.verify_upi')}}",
      type: "POST",
      data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums}
    },
    "columns": [
        {data: 'DT_RowIndex', name: 'DT_RowIndex'},
        {data: 'username', name: 'username'},
        {data: 'email', name: 'email',sortable:false},
        {data: 'created', name: 'created'},
        {data: 'status', name: 'status'},
    ]
});

document.getElementById(fieldname).focus();

}

$(document).ready(function() {

  let filter_username = '<?php echo @$_GET['filter_username']; ?>';
  let filter_email = '<?php echo @$_GET['filter_email']; ?>';

  if(filter_username !==''){
    filtercolums['filter_username'] = filter_username;
  }
  if(filter_email !==''){
    filtercolums['filter_email'] = filter_email;
  }

    $('#dataList').DataTable({
      // order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.verify_upi')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'username', name: 'username'},
            {data: 'email', name: 'email',sortable:false},
            {data: 'created', name: 'created'},
            {data: 'status', name: 'status'},
        ]
    });
});


</script>
@endsection
