@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<!--**********************************
    Content body start
***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Add Series</h4>
                <!-- <span class="ml-1">Layout</span> -->
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.view_all')}}">Serise</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Add</a></li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Add Form</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form action="{{route($modelName.'.add')}}" id="seriseAddForm" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Series Name</label>
                                    <input type="text" class="form-control" name="name" id="name" placeholder="Name">
                                    <div class="error-message help-inline">
                                      <?php echo $errors->first('name'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Select Sport Type</label>
                                    <select class="form-control sport_types" name="sport_type">
                                        <option value="">Select Sport</option>
                                        @foreach($sport_types as $key => $value)
                                            <option value="{{$value->id}}">{{$value->sport_name}}</option>
                                        @endforeach
                                    </select>
                                    <div class="error-message help-inline">
                                     <?php echo $errors->first('sport_type'); ?>
                                   </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Start Date</label>
                                    <input class="form-control datetimepickerget"  autocomplete="off" placeholder="Start date" id="start_date" name="start_date" aria-describedby="inputSuccess2Status2" type="text">
                                    @if ($message = session()->get('successs'))
                                  <div class="error-message help-inline">
                                    {{ $message }}
                                  </div>
                                @endif
                                </div>
                                <div class="form-group col-md-6">
                                    <label>End Date</label>
                                   <input class="form-control datetimepickerget" placeholder="End date" autocomplete="off" name="end_date" id="end_date" aria-describedby="inputSuccess2Status2" type="text">
                                   <div class="error-message help-inline">
                                      <?php echo $errors->first('end_date'); ?>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Submit</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
        $('#start_date').datetimepicker({
            timepicker: false,
            format:'Y-m-d'
        });
        $('#end_date').datetimepicker({
            timepicker: false,
            format:'Y-m-d'
        });
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });
    });
</script>

<!--**********************************
    Content body end
***********************************-->
@endsection
