@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!--**********************************
        Content body start
    ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Edit Series</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.view_all') }}">All Serise</a></li>
                    <li class="breadcrumb-item">Edit</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Series</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.update', base64_encode(serialize($series->id))) }}"
                                id="seriseEditForm" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Series Name</label>
                                        <input type="text" class="form-control in_text" name="name" id="name"
                                            placeholder="Name" value="{{ $series->name }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('name'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Select Sport Type</label>
                                        <select class="form-control in_text sport_types" name="sport_type">
                                            <option value="">Select Sport</option>
                                            @foreach ($sport_types as $key => $value)
                                                <option value="{{ $value->id }}" <?php if ($series->sport_type == $value->id) {
                                                    echo 'selected';
                                                } ?>>
                                                    {{ $value->sport_name }}</option>
                                            @endforeach
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('sport_type'); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Start Date</label>
                                        <input class="form-control datetimepickerget in_text" id="start_date"
                                            value="{{ $series->start_date }}" autocomplete="off" placeholder="Start date"
                                            name="start_date" aria-describedby="inputSuccess2Status2" type="text"
                                            value="{{ $series->start_date }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('start_date'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">End Date</label>
                                        <input class="form-control datetimepickerget in_text" id="end_date"
                                            placeholder="End date" autocomplete="off" value="{{ $series->end_date }}"
                                            name="end_date" aria-describedby="inputSuccess2Status2" type="text"
                                            value="{{ $series->end_date }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('end_date'); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col-md-4 py-2">
                                        <label>&ensp;</label>
                                        <div class="form-check mb-4 ml-3">
                                            <input type="checkbox" class="form-check-input" id="is_leaderboard"
                                                name="is_leaderboard" value="1" <?php if ($series->is_leaderboard == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Is Leaderboard</label>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-4 py-2">
                                        <label>&ensp;</label>
                                        <div class="form-check mb-4 ml-3">
                                            <input type="checkbox" class="form-check-input" id="is_series_slide"
                                                name="is_series_slide" value="1" <?php if (@$series->is_series_slide == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <!-- onclick="toggleIsLeaderboard(event)"> -->
                                            <label class="form-check-label">Is Series slide</label>
                                        </div>
                                    </div>

                                    <!-- <div class="form-group col-md-4 py-2">
                                        <label>&ensp;</label>
                                        <div class="form-check mb-4 ml-3">
                                            <input type="checkbox" class="form-check-input" id="is_investment"
                                                name="is_investment" value="1" <?php if (@$series->is_investment == 1) {
                                                    echo 'checked';
                                                } ?>>

                                            <label class="form-check-label">Is Investment Leaderboard</label>
                                        </div>
                                    </div> -->
                                    <!-- <div class="form-group col-md-4 py-2">
                                        <label>&ensp;</label>

                                        <div class="form-check mb-4 ml-3">
                                            <input type="checkbox" class="form-check-input"
                                                id="is_promoter_series_leaderboard " name="is_promoter_series_leaderboard"
                                                value="1" <?php if ($series->is_promoter_series_leaderboard == 1) {
                                                    echo 'checked';
                                                } ?>>

                                            <label class="form-check-label">Is Promoter Series Leaderboard

                                            </label>
                                        </div>
                                    </div> -->
                                </div>




                                <div class="py-2">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#start_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
            $('#end_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>

    <!--**********************************
        Content body end
    ***********************************-->
@endsection
