@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Add Satting</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.view') }}">Settings</a></li>
                    <li class="breadcrumb-item">Add</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add New Setting</h4>
                    </div>

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif


                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.add') }}" id="setting_form" method="POST"
                                enctype="multipart/form-data" @csrf <div class="form-row">
                                @csrf
                                    <div class="form-group col-md-6 mb-0">
                                    <label class="mb-3">Setting key</label>
                                    <input autocomplete="off" type="text" class="form-control w-95" id="setting_key"
                                        name="setting_key" placeholder="enter setting key here">
                                </div>
                                <div class="form-group col-md-6 mb-0">
                                    <label class="mb-3">Setting Value</label>
                                    <input class="form-control w-95" autocomplete="off"
                                        placeholder="enter setting value here" id="value" name="value" type="text">
                                </div>
                        </div>
                        </form>
                    </div>
                </div>
                <div class="card-footer py-4">
                    <button type="submit" class="btn btn-primary mr-2" id="submit_form">Submit</button>
                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!--**********************************
    Content body end
    ***********************************-->

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
            //jpeg,jpg,png,JPEG,JPG,PNG
            $(document).on('click', '#submit_form', function() {
                let error = 0;
                $("#submit_form").find("input").each(function(e) {
                    if ($(this).val() == '') {
                        error++;
                    }
                });

                if (error > 0) {
                    alert("please fill all fields.");
                    return false;
                } else {
                    $("#setting_form")[0].submit();
                }
            });

        });
    </script>

@endsection
