@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<style>
   /* Add CSS here */
   #dataList {
     width: 100%;
     border-collapse: collapse;
   }

   #dataList th,
   #dataList td {
     border: 1px solid #d0d0d0;
     padding: 8px;
     text-align: center;
   }

   #dataList thead th {
     background-color: #a0d16b;
     color: black;
     font-weight: bold;
   }

   #dataList tfoot th {
     background-color: #a0d16b;
     color: black;
     font-weight: bold;
   }

   .form-check-input {
     transform: scale(1.2);
   }
 </style>
<script type="text/javascript">
$(function(){
	$(document).on('click', '.confirm_box', function(e) {
		e.preventDefault();
		var target_url 	= $(this).attr('href');
		var rel 	= $(this).attr('rel');
		var id 	= $(this).attr('rev');
		bootbox.confirm({
			message: $(this).attr('rel'),
			buttons: {
				confirm: {
					label: 'Yes',
					className: 'btn-success'
				},
				cancel: {
					label: 'No',
					className: 'btn-danger'
				}
			},
			callback: function (result) {
				if (result == true)
				{
					window.location = target_url;
				}
			}
		});
	});
});
</script>
<script>
	$(document).ready(function(){
		$('[data-toggle="tooltip"]').tooltip();
	});
</script>
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>All States </h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Setting</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">

                <div class="card-body">
                  <div class="table-responsive">
                      <table id="dataList" class="display" style="min-width: 845px">
                          <thead>
                              <tr>
                              <th style="text-align:center">Selected</th>
                              <th style="text-align:center">State</th>
                              <th style="text-align:center">Selected</th>
                              <th style="text-align:center">State</th>
                          </tr>
                          </thead>
                          <tbody>
                            <?php

                            $all_states=array_chunk($states,2);
                            foreach($all_states as $key=>$val){ ?>
                            <tr>
                              <?php foreach($val as $k=>$state){ ?>
                                <td style="text-align:center"> <input class="form-check-input update_state" value="1" type="checkbox" id="state-<?php echo $state->id ?>" data-state_id="<?php echo $state->id ?>"  name="status" id="status" <?php if(isset($state->status) && $state->status==1){ ?> checked <?php } ?>>
                                <br></td>
                                <td style="text-align:center"><?php echo $state->name.'['.$state->short_name.']' ?></td>
                              <?php } ?>
                            </tr>
                          <?php } ?>
                          </tbody>
                          <tfoot>
                              <tr>
                                <th>Selected</th>
                                <th>State</th>
                                <th>Selected</th>
                                <th>State</th>
                          </tr>
                          </tfoot>
                      </table>
                  </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- END EXAMPLE TABLE PORTLET-->
<script>
	$(document).ready(function(){

		$(document).on('click', '.action-setting', function () {
	        if(!confirm("Are You Sure to delete this setting?"))
	        event.preventDefault();
	    });

      $(document).on('change', '.update_state', function () {
            var id=$(this).data("state_id");
            var status = $(this).is(':checked') ? 1 : 0;
            // Perform AJAX request to update the status
            $.ajax({
              url: '<?php echo route('Setting.update_state'); ?>', // PHP script to handle the update
              type: 'POST',
              data: {
                id: id,
                status: status
              },
              success: function(response) {
                console.log('Status updated successfully:', response);
              },
              error: function(xhr, status, error) {
                console.error('Error updating status:', error);
              }
            });
        });

	});
</script>
@endsection
