@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
  {{ HTML::style('css/admin/datatable.css') }}
  {{ HTML::script("js/admin/datatable.js") }}
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Sub Admin</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                  <!-- <a href="javascript:void(0)">Sub Admin</a></li> -->
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4>All Sub Admin</h4>
                    <a href="{{route($modelName.'.add')}}" class="col-md-2 btn btn-primary btn-sm"> Add New <?php echo str_replace('_',' ',$modelName) ?>  </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <!-- <th>ID</th> -->
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone No</th>
                                <th>Action</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <!-- <th>ID</th> -->
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone No</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!---Show Ajax---------->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.view')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            //{data: 'id', name: 'id'},
            {data: 'name', name: 'name'},
            {data: 'email', name: 'email'},
            {data: 'mobile', name: 'mobile'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
});
$(document).on('click', '.action-users', function () {
          if(!confirm("Are You Sure to deactivate this user?"))
          event.preventDefault();
});

$(document).on('click', '.deleteaction-users', function () {
          if(!confirm("Are You Sure to delete this user?"))
          event.preventDefault();
});

</script>

@endsection
