@extends('admin.layouts.default')
@section('content')
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-red-sunglo">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject bold uppercase"> {{ trans("messages.$modelName.table_heading_add") }}</span>
            </div>
            <div class="actions">
                <div class="btn-group">
                    <a class="btn btn-sm green dropdown-toggle" href="{{ route($modelName . '.index', $type) }}">
                        {{ trans('messages.global.back') }}
                        <i class="fa fa-angle-left"></i>
                    </a>
                </div>
            </div>
        </div>
        <!-- multilanguage tab button -->

        @if (count($languages) > 1)
            <div class="default_language_color">
                {{ Config::get('default_language.message') }}
            </div>
            <div class="wizard-nav wizard-nav-horizontal">
                <ul class="nav nav-tabs">
                    @foreach ($languages as $value)
                        <?php $i = $value->id; ?>
                        <li class=" {{ $i == $language_code ? 'active' : '' }}">
                            <a data-toggle="tab" href="#{{ $i }}div">
                                {{ $value->title }}
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="portlet-body form">
            <form action="{{ route("$modelName.save", $type) }}" class="mws-form" method="POST">
                @csrf
                <div class="form-body">
                    <div class="mws-panel-body no-padding">
                        <div class="mws-form-inline">
                            <div class="mws-form-row">
                                <label class="mws-form-label"> Key<span class="requireRed"> * </span> </label>
                                <div class="mws-form-item">
                                    <input type="text" name="key" class="form-control" />
                                    <div class="error-message help-inline">
                                        <?php echo $errors->first('key'); ?>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="mws-panel-body no-padding tab-content">


                        @foreach ($languages as $value)
                            <?php $j = $value->id; ?>
                            <div id="{{ $j }}div" class="tab-pane {{ $j == $language_code ? 'active' : '' }} ">
                                <div class="mws-form-inline">
                                    <div class="mws-form-row ">
                                        <label class="mws-form-label"> Value<span class="requireRed"> * </span> </label>

                                        <div class="mws-form-item">
                                            <input type="text" class="form-control" name="{{ $data[$value->id] }}" />
                                            <div class="error-message help-inline">
                                                <?php echo $j == $language_code ? $errors->first('value') : ''; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- button-->
                <div class="form-actions">
                    <button type="submit" class="btn btn-danger">{{ trans('messages.global.save') }}</button>
                    <a class="btn default"
                        href='{{ route("$modelName.add", $type) }}'>{{ trans('messages.global.reset') }}</a>
                </div>
            </form>
        </div>

    </div>
@stop
