@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Add Satting</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.viewapi') }}">All Fantasy Sports API
                        </a></li>
                    <li class="breadcrumb-item">Add</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add New Fantasy Sports API </h4>
                    </div>

                    <?php //dd($sport_types);
                    ?>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="setting_form" method="POST" action="{{ route($modelName . '.add_api') }}"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6 mb-0 mt-3">
                                        <label class="mb-3">Sports Type</label>
                                        <select class="form-control" name="sports_type" required>
                                            <option value="">Select Sports</option>
                                            <?php foreach ($sport_types as $key => $value) { ?>
                                            <option value="<?php echo $value->id; ?>}}"><?php echo $value->sport_key; ?></option>
                                            <?php } ?>
                                        </select>
                                        <div class="error-message help-inline">
                                            {{ $errors->first('sports_type') }}
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6 mb-0 mt-3">
                                        <label class="mb-3">Name of API</label>
                                        <input required autocomplete="off" type="text" class="form-control"
                                            id="name" name="name" placeholder="Enter Name of API">
                                        <div class="error-message help-inline">
                                            {{ $errors->first('name') }}
                                        </div>
                                    </div>

                                    <!-- <div class="form-group col-md-6 mb-0 ">
                                    <label class="mb-4 mt-4 font-weight-bold">URL</label>
                                    <input required autocomplete="off" type="text" class="form-control w-95" id="url" name="url" placeholder="Enter Url">
                                    <div class="error-message help-inline">
                                      {{ $errors->first('url') }}
                                    </div>
                                </div> -->

                                    <div class="form-group col-md-6 mb-0 mt-3">
                                        <label class="mb-3">Api Access Token</label>
                                        <input required autocomplete="off" type="text" class="form-control"
                                            id="access_tokens" name="access_tokens" placeholder="Enter Api Access Token">
                                        <div class="error-message help-inline">
                                            {{ $errors->first('access_tokens') }}
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6 mb-0 mt-3">
                                        <label class="mb-3">Status</label>
                                        <select class="form-control" name="status" required>
                                            <option value="">Select Status</option>
                                            <option value="1">Active</option>
                                            <option value="0">InActive</option>
                                        </select>
                                        <div class="error-message help-inline">
                                            {{ $errors->first('status') }}
                                        </div>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="card-footer py-4">
                        <button type="submit" class="btn btn-primary mr-2" id="submit_form">Submit</button>
                        <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
    Content body end
    ***********************************-->

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
            //jpeg,jpg,png,JPEG,JPG,PNG
            $(document).on('click', '#submit_form', function() {
                let error = 0;
                $("#submit_form").find("input").each(function(e) {
                    if ($(this).val() == '') {
                        error++;
                    }
                });

                if (error > 0) {
                    alert("please fill all fields.");
                    return false;
                } else {
                    $("#setting_form")[0].submit();
                }
            });

        });
    </script>
@endsection
