@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Add Satting</h4>
                <span class="ml-1">Layout</span>
            </div> -->
        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.viewaws')}}">All AWS S3 Configuration </a></li>
                <li class="breadcrumb-item">Add</li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Add New AWS S3 Configuration </h4>
                </div>

                <?php //dd($sport_types); ?>
                <div class="card-body">
                    <div class="basic-form">
                        {{ Form::open(['role' => 'form','id'=>'setting_form','route'=>[$modelName.'.add_aws'], 'files' => true]) }}
                        <div class="form-row">
                          <div class="form-group col-md-6 mb-0 mt-3">
                              <label class="mb-3">Aws S3 Name</label>
                              <input required autocomplete="off" type="text" class="form-control w-95" id="s3_name" name="s3_name" placeholder="Enter Aws S3 Name">
                              <div class="error-message help-inline">
                                {{$errors->first('s3_name')}}
                              </div>
                          </div>

                          <div class="form-group col-md-6 mb-0 mt-3">
                              <label class="mb-3">Aws S3 Key</label>
                              <input required autocomplete="off" type="text" class="form-control w-95" id="s3_key" name="s3_key" placeholder="Enter Aws S3 Key">
                              <div class="error-message help-inline">
                                {{$errors->first('s3_key')}}
                              </div>
                          </div>

                          <div class="form-group col-md-6 mb-0 mt-3">
                              <label class="mb-3">Aws S3 Secret</label>
                              <input required autocomplete="off" type="text" class="form-control w-95" id="s3_secret" name="s3_secret" placeholder="Enter Aws S3 Secret">
                              <div class="error-message help-inline">
                                {{$errors->first('s3_secret')}}
                              </div>
                          </div>

                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">End Point Url</label>
                                <input required autocomplete="off" type="text" class="form-control w-95" id="end_point" name="end_point" placeholder="Enter End Point Url">
                                <div class="error-message help-inline">
                                  {{$errors->first('end_point')}}
                                </div>
                            </div>

                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">CDN Url</label>
                                <input required autocomplete="off" type="text" class="form-control w-95" id="cdn_url" name="cdn_url" placeholder="Enter CDN Url">
                                <div class="error-message help-inline">
                                  {{$errors->first('cdn_url')}}
                                </div>
                            </div>




                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Status</label>
                                <select class="form-control" name="status" required>
                                    <option value="">Select Status</option>
                                      <option value="1">Active</option>
                                      <option value="0">Inactive</option>
                                </select>
                                <div class="error-message help-inline">
                                  {{$errors->first('status')}}
                                </div>
                            </div>

                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
                <div class="card-footer py-4">
                    <button type="submit" class="btn btn-primary mr-2" id="submit_form" >Submit</button>
                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</div>
<!--**********************************
Content body end
***********************************-->

<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });
        //jpeg,jpg,png,JPEG,JPG,PNG
        $(document).on('click','#submit_form', function(){
          let error = 0;
          $("#submit_form").find("input").each(function(e){
            if($(this).val() == ''){
              error++;
            }
          });

          if(error > 0) {
            alert("please fill all fields.");
            return false;
          }
          else {
            $("#setting_form")[0].submit();
          }
        });

    });
</script>

@endsection
