@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">

        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.viewemail')}}">All Email</a></li>
                <li class="breadcrumb-item">Add</li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Add New Email</h4>
                </div>


                <div class="card-body">
                    <div class="basic-form">
                        {{ Form::open(['role' => 'form','id'=>'setting_form','route'=>[$modelName.'.addemail'], 'files' => true]) }}
                        <div class="form-row">
                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Email From Name</label>
                                <input autocomplete="off" type="text" class="form-control w-95" id="name" name="name" placeholder="Enter Email From Name">
                                <div class="error-message help-inline">
                                  {{$errors->first('name')}}
                                </div>
                            </div>
                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Email Driver</label>
                                <input autocomplete="off" type="text" class="form-control w-95" id="url" name="driver" placeholder="Enter Email Driver">
                                <div class="error-message help-inline">
                                  {{$errors->first('url')}}
                                </div>
                            </div>
                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Email Host</label>
                                <input class="form-control w-95" autocomplete="off" placeholder="Enter Email Host" id="sender_id" name="host" type="text">
                                <div class="error-message help-inline">
                                  {{$errors->first('sender_id')}}
                                </div>
                            </div>
                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Email Port</label>
                                <input autocomplete="off" type="text" class="form-control w-95" id="auth_key" name="port" placeholder="Enter Email Port">
                                <div class="error-message help-inline">
                                  {{$errors->first('auth_key')}}
                                </div>
                            </div>
                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Email Username</label>
                                <input class="form-control w-95" autocomplete="off" placeholder="Enter Email Username" id="header_id" name="username" type="text">
                                <!-- <div class="error-message help-inline">
                                  {{$errors->first('header_id')}}
                                </div> -->
                            </div>
                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Email Password</label>
                                <input autocomplete="off" type="Password" class="form-control w-95" id="temp_id" name="password" placeholder="Enter Email Password">
                                <!-- <div class="error-message help-inline">
                                  {{$errors->first('temp_id')}}
                                </div> -->
                            </div>
                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Email Encryption</label>
                                <input class="form-control w-95" autocomplete="off" placeholder="Enter Email Encryption" id="dlt_id" name="encryption" type="text">
                                <div class="error-message help-inline">
                                  {{$errors->first('dlt_id')}}
                                </div>
                            </div>
                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Email From Address</label>
                                <input class="form-control w-95" autocomplete="off" placeholder="Enter Email From Address" id="dlt_id" name="address" type="text">
                                <div class="error-message help-inline">
                                  {{$errors->first('dlt_id')}}
                                </div>
                            </div>

                            <div class="form-group col-md-6 mb-0 mt-3">
                                <label class="mb-3">Status</label>
                                <select class="form-control w-95" name="status">
                                    <option value="">Select Status</option>
                                      <option value="1">Active</option>
                                      <option value="0">InActive</option>
                                </select>
                                <div class="error-message help-inline">
                                  {{$errors->first('status')}}
                                </div>
                            </div>

                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
                <div class="card-footer py-4">
                    <button type="submit" class="btn btn-primary mr-2" id="submit_form" >Submit</button>
                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</div>
<!--**********************************
Content body end
***********************************-->

<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });
        //jpeg,jpg,png,JPEG,JPG,PNG
        $(document).on('click','#submit_form', function(){
          let error = 0;
          $("#submit_form").find("input").each(function(e){
            if($(this).val() == ''){
              error++;
            }
          });

          if(error > 0) {
            alert("please fill all fields.");
            return false;
          }
          else {
            $("#setting_form")[0].submit();
          }
        });

    });
</script>

@endsection
