@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Edit Setting</h4>
                <span class="ml-1">Layout</span>
            </div> -->
        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.viewapi')}}">All Fantasy Sports API</a></li>
                <li class="breadcrumb-item">Edit</li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Edit Fantasy Sports API</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        {{ Form::open(['role' => 'form','id'=>'setting_form','route'=>[$modelName.'.update_api',base64_encode(serialize($api_data->id))], 'files' => true]) }}
                            <div class="form-row">
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Sports Type</label>
                                  <select class="form-control" name="sports_type" required>
                                      <option value="">Select Sports</option>
                                      <?php foreach ($sport_types as $key => $value) { echo $value->id .'=='. $api_data->sports_type; ?>
                                            <option value="<?php echo $value->id;?>}}"  <?php if($value->id == $api_data->sports_type){ echo 'selected="selected"'; }?>><?php echo $value->sport_key; ?></option>
                                      <?php } ?>
                                  </select>
                                  <div class="error-message help-inline">
                                    {{$errors->first('sports_type')}}
                                  </div>
                              </div>
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Name of API</label>
                                  <input autocomplete="off" type="text" class="form-control w-95" id="name" name="name" placeholder="Enter Name of API" value="{{$api_data->name}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('name')}}
                                  </div>
                              </div>
                              <!-- <div class="form-group col-md-6 mb-0 ">
                                <label class="mb-4 mt-4 font-weight-bold">URL</label>
                                  <input autocomplete="off" type="text" class="form-control w-95" id="url" name="url" placeholder="Enter Url" value="{{$api_data->url}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('url')}}
                                  </div>
                              </div> -->
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Api Access Token</label>
                                  <input class="form-control w-95" autocomplete="off" placeholder="Enter Api Access Tokens" id="access_tokens" name="access_tokens" type="text" value="{{$api_data->access_tokens}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('sender_id')}}
                                  </div>
                              </div>


                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Status</label>
                                  <select class="form-control" name="status">
                                      <option value="">Select Status</option>
                                      <option value="0" <?php if($api_data->status=='0'){ echo 'selected'; }?>>InActive</option>
                                     <option value="1" <?php if($api_data->status=='1'){ echo 'selected'; }?>>Active</option>
                                  </select>
                                  <div class="error-message help-inline">
                                    {{$errors->first('status')}}
                                  </div>
                              </div>
                            </div>
                        {{ Form::close() }}
                    </div>
                </div>
                <div class="card-footer py-4">
                    <button type="submit" class="btn btn-primary mr-2" id="submit_form">Submit</button>
                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</div>
<!--**********************************
Content body end
***********************************-->

<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });

        $("#submit_form").click(function(){
          let error = 0;
          $("#setting_form").find("input").each(function(e){
            if($(this).val() == ''){
              error++;
            }
          });

          if(error > 0) {
            alert("please fill all fields.");
            return false;
          }
          else {
            $("#setting_form")[0].submit();
          }
        });


    });
</script>

@endsection
