@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">

        </div>

        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.viewemail')}}">All Email</a></li>
                <li class="breadcrumb-item">Edit</li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Edit Email Config</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        {{ Form::open(['role' => 'form','id'=>'setting_form','route'=>[$modelName.'.updateemail',base64_encode(serialize($email->id))], 'files' => true]) }}
                            <div class="form-row">
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Email From Name</label>
                                  <input autocomplete="off" type="text" class="form-control w-95" id="name" name="name" placeholder="Enter Email From Name" value="{{$email->from_name}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('name')}}
                                  </div>
                              </div>
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Email Driver</label>
                                  <input autocomplete="off" type="text" class="form-control w-95" id="url" name="mail_driver" placeholder="Enter Email Driver" value="{{$email->mail_driver}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('url')}}
                                  </div>
                              </div>
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Email Host</label>
                                  <input class="form-control w-95" autocomplete="off" placeholder="Enter Email Host" id="sender_id" name="mail_host" type="text" value="{{$email->mail_host}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('sender_id')}}
                                  </div>
                              </div>
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Email Port</label>
                                  <input autocomplete="off" type="text" class="form-control w-95" id="auth_key" name="mail_port" placeholder="Enter Email Port" value="{{$email->mail_port}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('auth_key')}}
                                  </div>
                              </div>
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Email Username</label>
                                  <input class="form-control w-95" autocomplete="off" placeholder="Enter Email Username" id="header_id" name="mail_username" type="text" value="{{$email->mail_username}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('header_id')}}
                                  </div>
                              </div>
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Email Password</label>
                                  <input autocomplete="off" type="text" class="form-control w-95" id="temp_id" name="mail_password" placeholder="Enter Email Password" value="{{$email->mail_password}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('temp_id')}}
                                  </div>
                              </div>
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Email Encryption</label>
                                  <input class="form-control w-95" autocomplete="off" placeholder="Enter Email Encryption" id="dlt_id" name="email_encryption" type="text" value="{{$email->email_encryption}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('dlt_id')}}
                                  </div>
                              </div>
                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Email From Address</label>
                                  <input class="form-control w-95" autocomplete="off" placeholder="Enter Email From Address" id="dlt_id" name="form_address" type="text" value="{{$email->form_address}}">
                                  <div class="error-message help-inline">
                                    {{$errors->first('dlt_id')}}
                                  </div>
                              </div>

                              <div class="form-group col-md-6 mb-0 mt-3">
                                  <label class="mb-3">Status</label>
                                  <select class="form-control w-95" name="status">
                                      <option value="">Select Status</option>
                                      <option value="0" <?php if($email->status=='0'){ echo 'selected'; }?>>Inactive</option>
                                     <option value="1" <?php if($email->status=='1'){ echo 'selected'; }?>>Active</option>
                                  </select>
                                  <div class="error-message help-inline">
                                    {{$errors->first('status')}}
                                  </div>
                              </div>
                            </div>
                        {{ Form::close() }}
                    </div>
                </div>
                <div class="card-footer py-4">
                    <button type="submit" class="btn btn-primary mr-2" id="submit_form">Submit</button>
                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                </div>
            </div>
        </div>
    </div>
</div>
<!--**********************************
Content body end
***********************************-->

<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });

        $("#submit_form").click(function(){
          let error = 0;
          $("#setting_form").find("input").each(function(e){
            if($(this).val() == ''){
              error++;
            }
          });

          if(error > 0) {
            alert("please fill all fields.");
            return false;
          }
          else {
            $("#setting_form")[0].submit();
          }
        });


    });
</script>

@endsection
