@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Registered Users Wallet List</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
              <li class="breadcrumb-item">Transaction Manager</li>
                <li class="breadcrumb-item">Promotor Commission TDS Report</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">

                    <h4>TDS On Promotor Commission 2023-24</h4>
                    <!-- <div class="card-body d-flex justify-content-end">
                      <h6>Select User</h6>
                      <select class="form-control ml-3" style="width:50%" id="searchusers" name="searchusers">
                        <option>Select User</option>
                        @if(!empty($userslist))
                          @foreach($userslist as $value)
                            <option value="{{$value->u_id}}"> {{$value->username}}</option>
                          @endforeach
                        @endif
                      </select>
                    </div>-->
                      <form id="Downlode_TDSForm" action="{{route($modelName.'.promotor_tds_report_new')}}" method="get">
                          <input type="hidden" name="download" value="download">
                          <button id="Downlode_TDSBtn" class="btn btn-primary gst-download">Download Report
                          </button>
                      </form>
                    <!-- <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-file-excel-o mr-2"></i> Download CSV</a></button>
                    <button class="btn btn-primary btn-sm" id="refresh_users_wallet">Refresh Data</button> -->
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Name
                                  <input style="margin-top:5px" type="text" id="filter_name" name="filter_name" value="<?php echo @$_GET['filter_name']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_name')">
                                </th>
                                <th>Email
                                <input style="margin-top:5px" type="text" id="filter_email" name="filter_email" value="<?php echo @$_GET['filter_email']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_email')">
                                </th>
                                <th>Mobile
                                <input style="margin-top:5px" type="text" id="filter_mobile" name="filter_mobile" value="<?php echo @$_GET['filter_mobile']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_mobile')">
                                </th>
                                <!-- <th>PAN</th> -->
                                <th>Total Earn Amount</th>
                                <th>Deducted TDS Amount</th>
                                <!-- <th>Net Commission</th> -->
                                <th>Action</th>
                            </tr>
                            </thead>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
      var fieldname = '';
      var filtercolums = {
        'filter_name':'',
        'filter_email':'',
        'filter_mobile':'',
      }

      function cancelEvent(){
        event.stopPropagation();
      }

      var input_filter_teamname = '';


      function updateURL(event , fieldname){
        var value = event.target.value;

        if(fieldname == 'filter_name'){
          input_filter_name = value;
        }


        var url = window.location.href.split('?')[0];
        history.pushState('', '', url+"?filter=1&filter_name="+filtercolums['filter_name']+"&filter_email="+filtercolums['filter_email']+"&filter_mobile="
        +filtercolums['filter_mobile']);

      }

      var url = window.location.href.split('?')[0];
      history.pushState('', '', url+"?filter=1&filter_name="+filtercolums['filter_name']+"&filter_email="+filtercolums['filter_email']+"&filter_mobile="
      +filtercolums['filter_mobile']);

      function filterData(event , fieldname){

        var value = event.target.value;
         updateURL(event,fieldname);

        if(fieldname == 'filter_name'){
          filtercolums['filter_name'] = value;
        }
        if(fieldname == 'filter_email'){
          filtercolums['filter_email'] = value;
        }
        if(fieldname == 'filter_mobile'){
          filtercolums['filter_mobile'] = value;
        }
        //URL UPDATE

        $('#dataList').DataTable().clear().destroy(); //clear table data Table

        $('#dataList').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax":{
              url:"{{route($modelName.'.promotor_tds_report_new')}}",
              type: "POST",
                  data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums}
            },
            "columns": [
              {data: 'DT_RowIndex', name: 'DT_RowIndex'},
              {data: 'name', name: 'name'},
              {data: 'email', name: 'email'},
              {data: 'mobile', name: 'mobile'},
              // {data: 'pan_number', name: 'pan_number'},
              {data: 'total_earn_comsn', name: 'total_earn_comsn'},
              {data: 'deduct_tds_amount', name: 'deduct_tds_amount'},
              // {data: 'net_comsn', name: 'net_comsn'},
              {data: 'action', name: 'action'},
            ]
        });
        document.getElementById(fieldname).focus();
      }

</script>

<script type="text/javascript">
$(document).ready(function() {

    $(document).on('change','#searchusers', function(){
        let userid = $(this).val();
        if(userid == '')
            return false;
        $('#dataList').DataTable().clear().destroy();
        usersWalletData(userid);

    });
    usersWalletData();

    $(document).on('click','#refresh_users_wallet', function(){
        $('#dataList').DataTable().clear().destroy();
        usersWalletData();
    });

    function usersWalletData(userid){
      let filter_name = '<?php echo @$_GET['filter_name']; ?>';
      let filter_email = '<?php echo @$_GET['filter_email']; ?>';
      let filter_mobile = '<?php echo @$_GET['filter_mobile']; ?>';

      var filtercolums = {

      }
      // FOR SELECT Filtering
      if(filter_name !==''){
        filtercolums['filter_name'] = filter_name;
      }
      if(filter_email !==''){
        filtercolums['filter_email'] = filter_email;
      }
      if(filter_mobile !==''){
        filtercolums['filter_mobile'] = filter_mobile;
      }
      $('#dataList').DataTable().clear().destroy();

        $('#dataList').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax":{
              url:"{{route($modelName.'.promotor_tds_report_new')}}",
              type: "POST",
                  data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums,"user_id":userid }
            },
            "columns": [
              {data: 'DT_RowIndex', name: 'DT_RowIndex'},
              {data: 'name', name: 'name'},
              {data: 'email', name: 'email'},
              {data: 'mobile', name: 'mobile'},
              // {data: 'pan_number', name: 'pan_number'},
              {data: 'total_earn_comsn', name: 'total_earn_comsn'},
              {data: 'deduct_tds_amount', name: 'deduct_tds_amount'},
              // {data: 'net_comsn', name: 'net_comsn'},
              {data: 'action', name: 'action'},
            ]
        });

        return true;
    }

    $(document).on('click', '#Downlode_TDSBtn', function(event){
        $( "#Downlode_TDSForm" ).submit();
    });


});
</script>
@endsection
