@extends('admin.layouts.default')
@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style media="screen">
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@100;300;400;500;700;900&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
        }

        .display-flex {
            display: flex;
            justify-content: start;
            align-items: center;
            gap: 10px;
        }

        .text-right {
            text-align: right;
        }

        .focus11commentary {
            font-family: 'Roboto', sans-serif;
            max-width: 450px;
            margin: auto;
            height: 100vh;
            overflow: hidden;
        }

        .focus11commentary_top {
            background: #1A1A1A;
            padding: 40px 15px 10px;
            color: #fff;
        }

        .focus11commentary h6,
        .backpage {
            color: #FFF;
            font-size: 14px;
            font-weight: 700;
            line-height: 20px;
            margin: 0;
        }

        .contest-box .contest-top .content-detail:last-child h6 {
            background: #cbcbcb4d;
            max-width: fit-content;
            margin-left: auto;
            padding: 6px 14px;
            border-radius: 8px;
        }

        .contest-top .content-detail p {
            font-size: 15px;
        }

        .focus11commentary p {
            font-size: 12px;
            font-style: normal;
            font-weight: 400;
            line-height: 20px;
            margin: 0;
        }

        .focus11commentary p.weight500 {
            font-weight: 500;
        }

        .teams-details {
            justify-content: space-between;
            padding: 20px 0;
            border-bottom: 1px solid #747474;
        }

        .teams-details .teams-details_name {
            width: 40%;
            max-width: 40%;
        }

        .teams-details .teams-details_name p {
            max-width: 100%;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .matchstatus {
            gap: 4px;
        }

        .matchstatus div {
            width: 5px;
            height: 5px;
            border-radius: 50%;
            background-color: #00B137;
        }

        .teamplayes-status {
            justify-content: space-between;
            padding-top: 15px;
        }

        .teamplayes-status .playesrs-status {
            width: 30%;
            display: flex;
            flex-direction: column;
            gap: 13px;
        }

        .player-div {
            display: flex;
            justify-content: space-between;
            gap: 15px;
        }

        .player-div p {
            white-space: nowrap;
            max-width: fit-content;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .player-div p:last-child {
            white-space: nowrap;
            max-width: fit-content;
            overflow: visible;
            text-overflow: inherit;
        }

        .teamplayes-status .playesrs-status:last-child {
            width: 40%;
        }

        .over-balls {
            display: flex;
            justify-content: space-between;
        }

        .over-balls .ball {
            width: 16px;
            height: 16px;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            font-family: Roboto;
            font-size: 10px;
            font-style: normal;
            font-weight: 500;
            line-height: 20px;
            /* 200% */
            background-color: transparent;
        }

        .over-balls .ball.dotball {
            border: 1.2px dashed #fff;
        }

        .over-balls .ball.only-run {
            background-color: #fff;
            color: #243222;
        }

        .over-balls .ball.wicket {
            background-color: #DF0100;
            color: #fff;
        }

        .over-balls .ball.boundry {
            background-color: #00B137;
            color: #fff;
        }

        .focus11commentary_middle {
            border: 1px solid #E1E1E1;
            background: var(--white, #FFF);
            display: flex;
            justify-content: space-between;
            padding: 11px 15px 0;
        }

        .commentary-tabs p {
            color: #747474;
            padding-bottom: 14px;
        }

        .commentary-tabs.active p {
            border-bottom: 2px solid #243222;
            color: #243222;
        }

        .focus11commentary_bottom {
            height: calc(100vh - 48.5px - 224px);
            overflow-y: auto;
            background-color: #E1E1E1;
            padding: 15px 15px 10px;
        }

        .contest-box {
            border-radius: 2px;
            background: #FFF;
            box-shadow: 0px 1px 4px 0px rgba(0, 0, 0, 0.15);
            margin-bottom: 12px;
        }

        .contest-top {
            padding: 12px;
            border-bottom: 3px solid #F2E78D;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .contest-box .contest-top:last-child {
            padding: 10px;
            border-bottom: 0px;
        }

        .contest-box p {
            color: #747474;
            margin-bottom: 5px;
        }

        .contest-box h6 {
            color: #000;
        }

        .focust p {
            color: #242322;
            font-weight: 500;
            margin-bottom: 5px;
            line-height: normal;
        }

        p.winning_p {
            color: #05a336;
            font-size: 13px;
            line-height: normal;
            text-transform: uppercase;
            font-weight: 400;
        }

        .contest-box .content-detail {
            width: 33.33%;
            text-align: center;
        }

        .contest-box .content-detail:first-child {
            text-align: left;
        }

        .contest-box .content-detail:last-child {
            text-align: right;
        }

        .contest-box .content-detail:last-child h6 {
            color: red;
        }

        .win_P {
            text-align: center;
            padding-top: 10px;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>



    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Add Youtuber</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <!-- <a href="{{ route($modelName . '.view') }}">View all Promoters</a></li> -->
                    <li class="breadcrumb-item">Add Promoter winning</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add Promoter winning</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.winningsstore') }}" method="POST" id="AddUserForm"
                                enctype="multipart/form-data" @csrf <div class="form-row">
                                <input type="hidden" name="winningid"
                                    value="{{ isset($editresult->id) ? $editresult->id : '' }}">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Select Match</label>
                                    <select class="form-control in_text " id="selectmatch"
                                        onChange ="logInConsole()"name="match_id" autocomplete="off" required>
                                        <option value=""> Select Match </option>
                                        @if (!empty($findalllistmatches))
                                            @foreach ($findalllistmatches as $matches)
                                                <option value="{{ $matches->matchkey }}"
                                                    @if (isset($_GET['matchkey']) && $matches->matchkey == $_GET['matchkey']) selected @elseif($matches->matchkey == @$editresult->match_id) selected @endif)>
                                                    {{ ucwords($matches->matchname) }}</option>
                                            @endforeach
                                        @endif

                                    </select>
                                    <label class="error-message help-inline">
                                        <?php echo $errors->first('match_id'); ?>
                                    </label>
                                </div>




                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">User Team Name</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="Enter Team Name"
                                        id="userteamname" name="teamname" type="text"
                                        value="{{ isset($editresult->teamname) ? $editresult->teamname : '' }}"
                                        autocomplete="off" required>
                                    <label class="error-message help-inline">
                                        <?php echo $errors->first('teamname'); ?>
                                    </label>
                                </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Entry Fees</label>
                                <input id="email" type="text" placeholder="enter entry fees" name="entryfees"
                                    class="form-control in_text"
                                    value="{{ isset($editresult->entryfees) ? $editresult->entryfees : '' }}" autocomplete="off"
                                    required>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('entryfees'); ?>
                                </label>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Winning Amount</label>
                                <input id="email" type="text" placeholder="enter winning amount" name="winnigamount"
                                    class="form-control in_text"
                                    value="{{ isset($editresult->winnigamount) ? $editresult->winnigamount : '' }}"
                                    autocomplete="off" required>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('winnigamount'); ?>
                                </label>
                            </div>


                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Sport </label>
                                <input id="password" type="text" placeholder="enter sport" name="sport"
                                    class="form-control in_text"
                                    value="{{ isset($editresult->sport) ? $editresult->sport : '' }}" autocomplete="off"
                                    required>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('sport'); ?>
                                </label>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Team No. </label>
                                <input id="password" type="text" placeholder="enter team number" name="teamnumber"
                                    class="form-control in_text"
                                    value="{{ isset($editresult->teamnumber) ? $editresult->teamnumber : '' }}"
                                    autocomplete="off" required>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('teamnumber'); ?>
                                </label>
                            </div>

                        </div>
                        <div class="form-row">

                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">You Won</label>
                                <input id="country" type="text" placeholder="enter you won" name="youwon"
                                    value="{{ isset($editresult->youwon) ? $editresult->youwon : '' }}"
                                    class="form-control in_text" autocomplete="off">
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('youwon'); ?>
                                </label>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Point</label>
                                <input id="country" type="text" placeholder="enter point" name="point"
                                    value="{{ isset($editresult->point) ? $editresult->point : '' }}"
                                    class="form-control in_text" autocomplete="off" required>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('point'); ?>
                                </label>
                            </div>


                        </div>
                        <div class="form-row">

                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Total Investment</label>
                                <input id="country" type="text" placeholder="Enter Total Investment"
                                    name="investment"
                                    value="{{ isset($editresult->investment) ? $editresult->investment : '' }}"
                                    class="form-control in_text" autocomplete="off">
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('investment'); ?>
                                </label>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Total Winning</label>
                                <input id="country" type="text" placeholder="Enter Total Winning"
                                    name="totalwinning"
                                    value="{{ isset($editresult->totalwinning) ? $editresult->totalwinning : '' }}"
                                    class="form-control in_text" autocomplete="off" required>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('totalwinning'); ?>
                                </label>
                            </div>
                        </div>
                        <div class="form-row">

                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Total Profit</label>
                                <input id="country" type="text" placeholder="enter total profit" name="profit"
                                    value="{{ isset($editresult->profit) ? $editresult->profit : '' }}"
                                    class="form-control in_text" autocomplete="off">
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('profit'); ?>
                                </label>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Rank</label>
                                <input class="form-control in_text" autocomplete="off" placeholder="enter rank"
                                    value="{{ isset($editresult->rank) ? $editresult->rank : '' }}" id=""
                                    name="rank" type="text" value="" required>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('rank'); ?>
                                </label>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Sport Type</label>
                                <select name="sport_type" class="form-control in_text" required>
                                    <option value="1" @if (@$editresult->sport_type == 1) selected @endif>CRICKET
                                    </option>
                                    <option value="7" @if (@$editresult->sport_type == 7) selected @endif>KABADDI
                                    </option>
                                    <option value="2" @if (@$editresult->sport_type == 2) selected @endif>FOOTBALL
                                    </option>
                                    <option value="3" @if (@$editresult->sport_type == 3) selected @endif>BASKETBALL
                                    </option>
                                </select>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('sport_type'); ?>
                                </label>
                            </div>

                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Fantasy Type</label>
                                <select name="fantasy_type" class="form-control in_text" required>
                                    <option value="0" @if (@$editresult->fantasy_type == 0) selected @endif>Classic
                                    </option>
                                    <option value="7" @if (@$editresult->fantasy_type == 7) selected @endif>10+1</option>
                                    <option value="6" @if (@$editresult->fantasy_type == 6) selected @endif>5+1</option>
                                </select>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('fantasy_type'); ?>
                                </label>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">How Many Sport</label>
                                <input class="form-control in_text" autocomplete="off" placeholder="How Many sport"
                                    value="{{ isset($editresult->sport_number) ? $editresult->sport_number : '' }}"
                                    id="" name="sport_number" type="text" required>
                                <label class="error-message help-inline">
                                    <?php echo $errors->first('sport_number'); ?>
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary mr-2">Submit</button>
                        <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        <form>
                    </div>
                </div>
            </div>
        </div>
    </div>








    <form action="{{ url('admin/Youtuber/Youtuber-winning-screenshot/') }}" method="post">

        {{ csrf_field() }}

        <input type="hidden" id="matchidinsert" name="matchkey"
            value="{{ isset($_GET['matchkey']) ? $_GET['matchkey'] : '' }}" required><br>

        <!-- <input type="hidden" name="userid" id="userid" value="" required> -->

        <!-- <input type="button" name="submit" class="btn btn-primary btn-sm col-md-2"/> -->
        <button type="submit" class="btn btn-primary mr-2" />Win Promotor Screenshot</button>


    </form>



    <div class="row">
        <div class="col-12">

            <div class="card" data-aos="fade-up">


                <div class="card-header">
                    <h4>All Promoters Winning</h4>
                    @if (isset($_GET['matchkey']))
                        <a href="{{ url('admin/Youtuber/deletedata/' . $_GET['matchkey']) }}"> <button
                                class="btn btn-success">Delete All Record</button></a>
                    @endif
                </div>

                <div class="card-header">
                    <h4></h4>

                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table id="example" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                    <th>S No.</th>
                                    <th>Match Name</th>
                                    <th>User Team Name</th>
                                    <th>Entry fees</th>
                                    <th>Winnig amount</th>
                                    <th>Sport</th>
                                    <th>Team number</th>
                                    <th>You won</th>
                                    <th>Point</th>
                                    <th>Rank</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                                @if (!empty($result))
                                    @foreach ($result as $key => $data)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td>{{ $data->matchname }}</td>
                                            <td>{{ $data->teamname }}</td>
                                            <td>{{ $data->entryfees }}</td>
                                            <td>{{ $data->winnigamount }}</td>
                                            <td>{{ $data->sport }}</td>
                                            <td>{{ $data->teamnumber }}</td>
                                            <td>{{ $data->youwon }}</td>
                                            <td>{{ $data->point }}</td>
                                            <td>{{ $data->rank }}</td>
                                            <!-- <td>edit</td> -->
                                            <td><a href="{{ url('admin/Youtuber/youtuber-winning-edit/' . $data->id) }}"
                                                    data-toggle="tooltip" title="" class="btn btn-rg mr-1 mt-1"
                                                    data-original-title="Edit"><i class="fa fa-pencil mr-2"
                                                        aria-hidden="true"></i>Edit</a>
                                                <a href="{{ url('admin/Youtuber/youtuber-delete/' . $data->id) }}"
                                                    data-toggle="tooltip" title="delete"
                                                    class="btn btn-danger action-players mr-1 mt-1"><i
                                                        class="fa fa-times mr-2" aria-hidden="true"
                                                        data-original-title="Delete"></i>Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                                </body>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <div class="modal" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">Promotor Win Deatil</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">



                </div>

                <!-- Modal footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onclick="capture();">Download Screenshot </button>
                </div>

            </div>
        </div>
    </div>
    <!--**********************************
    Content body end
    ***********************************-->






    <script type="text/javascript">
        selectList = '';

        function logInConsole() {
            var selectList = document.getElementById('selectmatch');

            var value = selectList.options[selectList.selectedIndex].value;

            $("#matchidinsert").val(value);
            //matchidinsert= $value;
            //  getloadmatchdetails(value);
            //  alert('ghjkl;');
        }
    </script>

    <script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {

        });
    </script>


    <script type="text/javascript">
        new DataTable('#example');
    </script>

    <script>
        $(document).ready(function() {

            $('#userteamname').on('focusout', function() {
                var userTeamName = $("#userteamname").val();
                // alert(userTeamName);
                if (userTeamName.length > 0) {
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: "POST",
                        url: "{{ url('admin/Youtuber/getuser') }}",
                        dataType: "Json",
                        data: {
                            teamname: userTeamName,
                        },
                        success: function(response) {
                            if (response.status == "failed") {
                                $('#userid').val(response.msg);
                            } else {
                                $('#userid').val('');
                                $('#userid').val(response.msg);
                            }
                        }
                    });
                }






            })
            // matchidinsert= $('#matchidinsert').val();
            // userid= $('#userid').val();
            //
            // getloadmatchdetails(matchidinsert);
        })

        function getloadmatchdetails(matchkey) {
            //  userid = $('#userid').val();
            //  matchkey =$('#matchidinsert').val() ;
            $newurl = '?matchkey=' + matchkey;
            // alert(matchkey);
            window.location.href = "{{ url('admin/Youtuber/Youtuber-winning-create') }}" + $newurl;
            //  ajax:({
            //    url:"{{ route($modelName . '.winningcreate') }}",
            //    type: "POST",
            //   data : {"_token": "{{ csrf_token() }}","matchkey":matchkey},
            //   success: function(data)
            //   {
            //       location.reload()
            //   }
            // });
            //alert(matchkey);
            $('#dataList-2').DataTable({
                //order: [1, 'desc'],
                //"processing": true,
                //"serverSide": true,
                "ajax": {
                    url: "{{ route($modelName . '.winningcreate') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "matchkey": "{{isset($_GET['matchkey'])"
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'matchname',
                        name: 'matchname'
                    },
                    {
                        data: 'teamname',
                        name: 'teamname'
                    },
                    {
                        data: 'entryfees',
                        name: 'entryfees'
                    },
                    {
                        data: 'winnigamount',
                        name: 'winnigamount'
                    },
                    {
                        data: 'sport',
                        name: 'sport'
                    },
                    {
                        data: 'teamnumber',
                        name: 'teamnumber'
                    },
                    {
                        data: 'youwon',
                        name: 'youwon'
                    },
                    {
                        data: 'point',
                        name: 'point'
                    },
                    {
                        data: 'rank',
                        name: 'rank'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

        }
    </script>

    <script src="
    https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js
    "></script>

    <script type="text/javascript">
        function capture() {
            html2canvas($('body'), {
                onrendered: function(canvas) {
                    var imgString = canvas.toDataURL("image/png");
                    window.open(imgString);
                }
            });
        };
    </script>




@endsection
