@extends('admin.layouts.default')
@section('content')
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <link rel="stylesheet" href="{{ asset('assets/css/admin/lightbox.css') }}" />
    <script src="{{ asset('assets/js/admin/lightbox.js') }}"></script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Edit Profile</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route('admin_dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item">Edit</li>
                </ol> -->
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Profile</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route('myprofile.update') }}" id="userUpdateForm" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Name</label>
                                        <input id="name" type="text" placeholder="enter name here" name="name"
                                            class="form-control in_text" value="{{ session()->get('name') }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('name'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Email</label>
                                        <!-- <input class="form-control in_text" autocomplete="off"
                                            placeholder="enter email here" id="email" name="email" type="text"
                                            value="{{ session()->get('email') }}"> -->
                                            <input class="form-control in_text" autocomplete="off"
                                              placeholder="Enter email here" id="email" name="email"
                                              type="email" maxlength="255" required
                                              pattern="[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}"
                                              value="{{ session()->get('email') }}"
                                              oninput="this.value = this.value.replace(/\s/g, '')">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('email'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Mobile</label>
                                        <!-- <input class="form-control in_text" autocomplete="off"
                                            placeholder="enter mobile here" id="mobile" name="mobile" type="int"max="10"
                                            value="{{ session()->get('mobile') }}"> -->
                                            <input class="form-control in_text" autocomplete="off"
                                              placeholder="Enter mobile here" id="mobile" name="mobile"
                                              type="tel" maxlength="10" pattern="[0-9]{10}"
                                              value="{{ session()->get('mobile') }}"
                                              oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,10);">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('mobile'); ?>
                                        </div>
                                    </div>


                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Image</label>
                                        <input type='file' id="imageUpload" name="image[]"
                                            class=" imageUpload form-control in_text" />
                                        <input type="hidden" name="base64image" name="base64image" id="base64image">
                                        <label for="imageUpload"></label>
                                        <!-- <input class="form-control in_text" name="image" id="image" type="file"> -->
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('image'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    @php
                                        $rootPathImage = USER_PROFILE_IMAGE_ROOT_PATH;
                                        $fileName = $rootPathImage . '' . session()->get('image');
                                    @endphp
                                    @if (isset($fileName) && !empty(session()->get('image')))
                                        <a class="items-image" data-lightbox="roadtrip<?php echo session()->get('image'); ?>"
                                            href="<?php echo USER_PROFILE_IMAGE_URL . session()->get('image'); ?>">
                                            <img alt="" class="img-responsive"
                                                src="{{ USER_PROFILE_IMAGE_URL }}{{ session()->get('image') }}" />
                                        </a>
                                    @else
                                        <img alt="" class="img-responsive"
                                            src="{{ WEBSITE_IMG_URL }}admin/no-image-male.png" />
                                    @endif
                                </div>
                                <input class="form-control" name="id" id="id" type="hidden"
                                    value="{{ session()->get('id') }}">
                                <div class="pt-4">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <div class="modal fade bd-example-modal-lg imagecrop" id="model" tabindex="-1" role="dialog"
        aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">New message</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <!-- <span aria-hidden="true">&times;</span> -->
                    </button>
                </div>
                <div class="modal-body">
                    <div class="img-container">
                        <div class="row">
                            <div class="col-md-11">
                                <img id="image" src="https://avatars0.githubusercontent.com/u/3456749">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" id="crop1">Close</button>
                    <button type="button" class="btn btn-primary crop" id="crop">Crop</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        var $modal = $('.imagecrop');
        var image = document.getElementById('image');
        var cropper;
        $("body").on("change", ".imageUpload", function(e) {
            var files = e.target.files;
            var done = function(url) {
                image.src = url;
                $modal.modal('show');
            };
            var reader;
            var file;
            var url;
            if (files && files.length > 0) {
                file = files[0];
                if (URL) {
                    done(URL.createObjectURL(file));
                } else if (FileReader) {
                    reader = new FileReader();
                    reader.onload = function(e) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(file);
                }
            }
        });
        $modal.on('shown.bs.modal', function() {
            cropper = new Cropper(image, {
                aspectRatio: 0,
                viewMode: 0,
            });
        }).on('hidden.bs.modal', function() {
            cropper.destroy();
            cropper = null;
        });
        $("body").on("click", "#crop,#crop1", function() {
            canvas = cropper.getCroppedCanvas({
                width: 160,
                height: 160,
            });
            canvas.toBlob(function(blob) {
                url = URL.createObjectURL(blob);
                var reader = new FileReader();
                reader.readAsDataURL(blob);
                reader.onloadend = function() {
                    var base64data = reader.result;
                    $('#base64image').val(base64data);
                    // document.getElementById('imagePreview').style.backgroundImage = "url("+base64data+")";
                    $modal.modal('hide');
                }
            });
        })
    </script>

    <script type="text/javascript">
        var UPLOAD_URL = "<?php echo WEBSITE_UPLOADS_URL; ?>";
    </script>


    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                window.location = "{{ route('admin_dashboard') }}";
            });
        });
    </script>
@endsection
