@extends('layouts.default')
@section('content')

<!-- 3D Grid Section Start -->
<section class="container-fluid p_top_bottom">
	<div class="row">
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<!-- 3D Block  Start -->
					<div class="car_3dblock">
						<!-- 3D Block Left Start -->
						<div class="car_3dblock_left">
							<div class="car_3dblock_leftTop">
								<div class="car_3dblock_leftTopInner">
									<div class="car_title_block">
										<h4>{{ isset($contract->car_make) && !empty($contract->car_make) ? $contract->car_make : '' }} {{ isset($contract->car_model) && !empty($contract->car_model) ? $contract->car_model : '' }}</h4>
									</div>
									<div class="car_thumb_block">
										@if(isset($contract->car_image) && !empty($contract->car_image))
										<img src="{{ MEDIA_IMAGE_URL }}{{ isset($contract->car_image) && !empty($contract->car_image) ? $contract->car_image : '' }}" width="300" alt="car">
										@else
										<img src="{{WEBSITE_IMG_URL}}admin/nocar.png" width="300" alt="car">
										@endif
									</div>
									<div class="car_3dblock_leftTopbg"></div>
								</div>
							</div>
							<div class="car_3dblock_leftBottom"></div>
						</div>
						<!-- 3D Block Left End -->
						<!-- 3D Block Right Start -->
						<div class="car_3dblock_right">
							<div class="car_3dblock_rightInner">
								<div class="heading_block text-center">
									<h4>Direct Pay in Bank Account</h4>
								</div>
								<form class="form-horizontal creditCard_form bank_form" method="POST" id="payment-form" role="form" action="{!! route('book_with_netbanking') !!}" >
											{{ csrf_field() }}
									<div class="form-group">
										<div class="col-sm-12">
											<p class="bank_detail text-left"><?php echo Config::get('Admin.bank_detail'); ?></p>
										</div>
									</div>

									</div>
									<div class="form-group mt-25">
										<div class="col-sm-6 text-left">
											<?php $contract_id = session()->get('contract_id'); ?>
											<a href="{{ route('payment_method',@$contract_id) }}" class="btn back_btn">Back</a>
										</div>
										<div class="col-sm-6 text-right" style="margin: 0px;">
											<input type="submit" class="btn btn-primary" id="pay-now" value="Proceed to Pay" />
										</div>
										</div>
									</div>
								</form>
							</div>
						</div>
						<!-- 3D Block Right End -->
					</div>
					<!-- 3D Block End -->
				</div>
			</div>
		</div>
	</div>
</section>
<!-- 3D Grid Section End -->
<script src="http://dev.rglabs.net/automotiv/js/admin/bootbox.min.js"></script>

 <script>
 		$(document).ready(function() {
			$('#payment-form').submit(function() {
				var c = confirm("Are you sure you want to proceed?");
				return c; // it will be true or false
			});
  	});
 </script>
@stop
