<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


    // ########### Third Party Integration #############

    public static function get_branding(){
      $brand =array();
      $data = DB :: table('brand_config')->first();
      $keys = array_keys((array)$data);
      for($i=0;$i<count($keys);$i++) {
        $brand[$keys[$i]] = $data->{$keys[$i]};
      }
      return $brand;
    }

    public static function get_email_config (){
      $mail =array();
      $mail_data = DB :: table('email_config')->first();
      $keys = array_keys((array)$mail_data);
      for($i=0;$i<count($keys);$i++) {
        $mail[$keys[$i]] = $mail_data->{$keys[$i]};
      }
      return $mail;
    }

      public static function get_subpiasa(){
      $brand =array();
      $data = DB::table('thirdparty_config')->orderBy('id', 'desc')->first();
      $keys = array_keys((array)$data);
      for($i=0;$i<count($keys);$i++) {
        $brand[$keys[$i]] = $data->{$keys[$i]};
      }
      return $brand;
    }
    public static function sms_geteway(){
      $smsgateway =array();
      $data = DB :: table('thirdparty_config')->where("type",0)->first();
      $keys = array_keys((array)$data);
      for($i=0;$i<count($keys);$i++) {
        $smsgateway[$keys[$i]] = $data->{$keys[$i]};
      }
      return $smsgateway;
    }

public static function paytm_gateway(){
      $paytm = array();
      $paytmdata = DB::table('thirdparty_config')->where('type',3)
      ->where('transaction_type',1)
      ->first();
      $keys = array_keys((array)$paytmdata);
      for($i=0;$i<count($keys);$i++) {
        $paytm[$keys[$i]] = $paytmdata->{$keys[$i]};
      }
      return $paytm;
    }


public static function cashfree_payment_gateway(){
    $cashfree_payment = array();
    $cashfree_payment_data = DB::table('thirdparty_config')->where('type',4)
    ->where('transaction_type',1)
    ->first();
    $keys = array_keys((array)$cashfree_payment_data);
    for($i=0;$i<count($keys);$i++) {
      $cashfree_payment[$keys[$i]] = $cashfree_payment_data->{$keys[$i]};
    }
    return $cashfree_payment;
  }

  public static function cashfree_payout_gateway_for_bank(){
    $cashfree_payout = array();
    $cashfree_payout_data = DB::table('thirdparty_config')->where('type',4)
    ->where('transaction_type',2)
    ->where('withdraw_type',1)
    ->first();
    $keys = array_keys((array)$cashfree_payout_data);
    for($i=0;$i<count($keys);$i++) {
      $cashfree_payout[$keys[$i]] = $cashfree_payout_data->{$keys[$i]};
    }
    return $cashfree_payout;
  }

  public static function cashfree_payout_gateway_for_instant(){
    $cashfree_payout = array();
    $cashfree_payout_data = DB::table('thirdparty_config')->where('type',4)
    ->where('transaction_type',2)
    ->where('withdraw_type',2)
    ->first();
    $keys = array_keys((array)$cashfree_payout_data);
    for($i=0;$i<count($keys);$i++) {
      $cashfree_payout[$keys[$i]] = $cashfree_payout_data->{$keys[$i]};
    }
    return $cashfree_payout;
  }


  public static function razorpay_gateway(){
        $razorpay = array();
        $razorpaydata = DB::table('thirdparty_config')->where('type',5)
        ->where('transaction_type',1)
        ->first();
        $keys = array_keys((array)$razorpaydata);
        for($i=0;$i<count($keys);$i++) {
          $razorpay[$keys[$i]] = $razorpaydata->{$keys[$i]};
        }
        return $razorpay;
      }

      public static function get_bonus_amount($bonus_key='SIGNUP_BONUS'){
        // echo $bonus_key; exit;
    $bonus = array();
    $bonusdata = DB::table('bonus_amount')->where('type',$bonus_key)
    ->where('status',1)
    ->first();
    $keys = array_keys((array)$bonusdata);
    for($i=0;$i<count($keys);$i++) {
      $bonus[$keys[$i]] = $bonusdata->{$keys[$i]};
    }
    return !empty($bonus['price']) ? $bonus['price'] : 0;
  }


    // ########## Third Party Integration @@@@@@@@@@@@@@



}
