<?php
namespace App\Http\Controllers;
use DB;
use Session;
use bcrypt;
use Config;
use Redirect;
use Hash;
use Mail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
class Cricketapi2Controller extends Controller {
	public function accessrules(){
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Credentials: true");
		header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
		header('Access-Control-Max-Age: 1000');
		header('Access-Control-Allow-Headers: Authorization');
		header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
	}

	public static function genrateToken() {
      return '704d99aaf5fe1c17b4d01b3f8a7381ba';
      exit;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, CRICKET_API_URL."v2/auth");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "access_key=".CRICKET_ACCESS_KEY."&secret_key=".CRICKET_SECRET_KEY."");
        curl_setopt($ch, CURLOPT_POST, 1);

        $headers = array();
        $headers[] = "Content-Type: application/x-www-form-urlencoded";
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);
        $result = json_decode($result);
        if($result->status=='ok') {
            $response = $result->response;
            $token = $response->token;
            return $token;
        }
    }

	public static function getMatches() {
		$token = Cricketapi2Controller::genrateToken();
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => CRICKET_API_URL."v2/matches/?token=".$token."&status=1&per_page=50&=&paged=1",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
        	$result = json_decode($response);
        	// print_r($result); exit;
        	if($result->status=="ok") {
        		$response = $result->response;
            	$data = $response->items;
            	return $data;
        	}
        }
	}

	public static function get_match_squad($match_id, $comp_id) {
		$token = Cricketapi2Controller::genrateToken();
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => CRICKET_API_URL."v2/competitions/".$comp_id."/squads/".$match_id."?token=".$token."&status=1&per_page=50&=&paged=1",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
        	$result = json_decode($response);
        	if($result->status=="ok") {
        		$response = $result->response;
            	return $response;
        	}
        }
	}

	public static function get_match_playing_players($api_unique_id) {
      $token = Cricketapi2Controller::genrateToken();
      // echo CRICKET_API_URL."/v2/matches/".$api_unique_id."/squads?token=".$token.""; exit;
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => CRICKET_API_URL."/v2/matches/".$api_unique_id."/squads?token=".$token."",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        //print_r($response); exit;
        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
          $result = json_decode($response);
          if($result->status=="ok") {
            $response = $result->response;
            $teama_players = $response->teama->squads;
            $teamb_players = $response->teamb->squads;
            $players = array_merge($teama_players, $teamb_players);
            $playing_players = array();
            foreach ($players as $player) {
              if($player->playing11=="true") {
                $playing_players[] = $player->player_id;
              }
            }
            return $playing_players;
          }
        }
    }

    public static function get_match_details($api_unique_id) {
      $token = Cricketapi2Controller::genrateToken();
      $curl = curl_init();
      $url = CRICKET_API_URL."v2/matches/".$api_unique_id."/scorecard?token=".$token."";
      // echo $url; exit;
      curl_setopt_array($curl, array(
        CURLOPT_URL => CRICKET_API_URL."v2/matches/".$api_unique_id."/scorecard?token=".$token."",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
          "Cache-Control: no-cache",
          "Postman-Token: cc748f1a-a898-463c-900c-47e74ac7b2c4"
        ),
      ));

      $response = curl_exec($curl);
      $err = curl_error($curl);

      curl_close($curl);

      if ($err) {
        echo "cURL Error #:" . $err; exit;
      } else {
        $result = json_decode($response);
        if($result->status=='ok') {
          $response = $result->response;
          return $response;
        }
      }
    }

}
?>
