<?php
namespace App\Http\Controllers;

use App\RegisterUser;
use App\Transaction;
use App\UserBalance;
use Illuminate\Http\Request;
use App\Helpers\Helpers;
use Session;
use Hash;
use DB;
use Response;
use App\TokenForMail;
class MailController extends Controller
{
	public function forgotPassword (Request $request) {

		$this->validate($request,[
    		'email' => 'required'
    	]);
   	$email = $request->email;
		$user = RegisterUser::where('email',$email)->first();
		// dd($user);
				if(!empty($user)){
					// dd(BASE_URL);
					$token = $this->generateToken($email);
					$button = "Reset Password";
					$emailsubject = "reset password link";
					$template_message = BASE_URL.'password/reset/view/'.$token;
					$which_view_open = "ResetPassword";
					$purpose = "ResetPassword";
					$this->saveToken($email,$token,$purpose);
					$this->sendMail($email,$token,$button,$emailsubject,$template_message,$which_view_open);
					return Response::json(["status" => 1,"email"=>1,"user_id"=>$user->id,  "mobile"=> 0 , "message" => "reset mail sent.", "result" => ["status"=>"sent"]]);
				}

			$mobile = (int)$email;
			if($mobile != 0){
			  $user_mob = RegisterUser::where('mobile',$email)->first();

				if(!empty($user_mob)){

					$code = rand(100000,999999);
					$txtmsg='Dear Virtual11 user Your Verification code is: '.$code.'. Thank You For Choosing Virtual11.'."\n\n ".OTP_AUTO_VERIFY;
					$user_mob->code = $code;
			    $user_mob->save();
			 		Helpers::sendTextSmsNew($txtmsg,$email);
			  	return Response::json(["status" => 1,"email"=>0,"user_id"=>$user_mob->id, "mobile"=> 1 ,"message" => "OTP sent.", "result" => ["status"=>"sent"]]);

				}
}

		  return Response::json(["status" => 0,"email"=>0, "mobile"=> 0, "user_id"=>0 , "message" => "Invalid Details.", "result" => ["status"=>"failed"]]);die;


	}

    public static function sendVerificationMailOnRegister($email) {
        $email_from_reg = $email;
        $from_reg = 'yes';
        return (new self)->verifyEmail($from_reg,$email_from_reg);
    }

		public static function sendVerificationMailOnRegisterOTP($email,$e_otp) {
										// return true;
                    // echo $email;
                    // print_r($e_otp);exit;


                    $email_from_reg = $email;

                    return (new self)->verifyEmailOTP($email_from_reg,$e_otp);
            }
						public function verifyEmailOTP($email_from_reg=null, $input_verify_email_otp=null) {
				                     $email = $email_from_reg;
				                             $emailsubject = "register | verify email link";
				                             $token = $this->generateToken($email);
				                             $template_message = BASE_URL.'email/verify/view/custom/'.$email_from_reg.'/'.$token;

				                     $purpose = "VerifyOTPEmail";
				                     $this->saveToken($email,$token,$purpose);
				                     $button = "Confirm";
				                     $which_view_open = "VerifyOTPEmail";
				                     $verify_email_otp = $input_verify_email_otp;
														 // echo $template_message;die;exit;
				                     $this->sendMail($email,$token,$button,$emailsubject,$template_message,$which_view_open , $verify_email_otp);
				                     // echo "ss";die;
				                     return Response::json(["status" => 1,"message" => "verification mail sent.", "result" => "None"]);
				             }

   public function verifyEmail($from_reg=null,$email_from_reg=null) {
        if ($email_from_reg) {
            $email = $email_from_reg;
            $emailsubject = "register | verify email link";
            $token = $this->generateToken($email);
            $template_message = env("APP_URL").'email/verify/view/custom/'.$email_from_reg.'/'.$token;
        } else {
            $email = request()->email;
            $emailsubject = "verify email link";
            $template_message = "Click on the button below to verify your email.";
            $token = $this->generateToken($email);
        }
        $purpose = "VerifyEmail";
        $this->saveToken($email,$token,$purpose);
        $button = "Confirm";
        $which_view_open = "VerifiedEmail";
        $this->sendMail($email,$token,$button,$emailsubject,$template_message,$which_view_open);
        return Response::json(["status" => 1,"message" => "verification mail sent.", "result" => "None"]);
    }

    // public function sendEmailOtp(Request $request) {
    //     echo $request->mobile;
    // }
    public function verifiedEmailView(Request $request) {
    // $this->validate($request,[
    //     'email' => 'required',
    //     'token' => 'required'
    // ]);
    $get_token = $request->token;
    $token_table = TokenForMail::where('email',$request->email)->first();
    if ($token_table == "") {
        $response = "failed";
        return view('mail_views.email_verification')->with('response',$response);
    }
    $token_from_table = $token_table->token_verify_email;
    if ($get_token == $token_from_table) {
        $response = "passed";
        $token_table->token_verify_email = "";
        $token_table->save();
        $user = RegisterUser::where('email',$request->email)->first();
        $user->email_verify = 1;
        $user->save();
				$Datauser = RegisterUser::where('email',$request->email)->first();


if($Datauser->signupbonus == 0 && $Datauser->is_new_user == 1)				{
	$userid = $Datauser->id;
				                      $userbalanse = DB::table('userbalances')->where('user_id', $userid)->first();
				                      $user_bns_amt['bonus']=$userbalanse->bonus + 25;
				                      DB::table('userbalances')->where('user_id', $userid)->update($user_bns_amt);


				                      $trans_bonus = DB::table('transactions');
				                      $ins_tran_bonus['userid'] = $userid;
				                      $ins_tran_bonus['refer_id'] = 0;
				                      $ins_tran_bonus['transaction_id'] = 'Gameon11-SIGNUP-'.time();
				                      $ins_tran_bonus['type'] = 'Signup Bonus';
				                      $ins_tran_bonus['transaction_by'] = 'Gameon11';
				                      $ins_tran_bonus['paymentstatus'] = CONFIRMED;
				                      $ins_tran_bonus['total_available_amt'] = $userbalanse->winning+$userbalanse->balance+$userbalanse->bonus;
				                      $ins_tran_bonus['bal_bonus_amt'] = $userbalanse->bonus;
				                      $ins_tran_bonus['bonus_amt'] = 25;
				                      $ins_tran_bonus['amount'] = 25;
				                      $trans_bonus->insert($ins_tran_bonus);

															$upJOINBonus['signupbonus'] = 1;
															DB::table('registerusers')->where('id' , $userid)->update($upJOINBonus);

}
        $is_code_exist = RegisterUser::where('id',$user->refer_id)->first();
        if(!empty($is_code_exist))
                    {
											$is_promotor = $is_code_exist->is_yoububer;
											 // && $is_code_exist->refer_to_join!=1
                    $refer_bal = DB::table('userbalances')->where('user_id', $is_code_exist->id)->first();
										if($is_promotor==0){
												$bns_amt['bonus']=$refer_bal->bonus + 50;
												DB::table('userbalances')->where('user_id', $is_code_exist->id)->update($bns_amt);
												$trans = DB::table('transactions');
													 $ins_tran['userid'] = $is_code_exist->id;
				                   $ins_tran['refer_id'] = $user->refer_id;
													 $ins_tran['transaction_id'] = 'Gameon11-Refer-'.time();
													 $ins_tran['type'] = 'Refer Bonus';
													 $ins_tran['transaction_by'] = 'Gameon11';

				                    $ins_tran['paymentstatus'] = CONFIRMED;

				                    $ins_tran['total_available_amt'] = $refer_bal->winning+$refer_bal->balance+$refer_bal->bonus;

				                    $ins_tran['bal_bonus_amt'] = $refer_bal->bonus;
															$ins_tran['bonus_amt'] = 50;

				                    	$ins_tran['amount'] = 50;


				                    $trans->insert($ins_tran);
												}
                  }

        // $user_balance = UserBalance::where('user_id',$user->id)->first();
        // $user_balance->bonus = 50;
        // $user_balance->save();

        /////////////////////// all working just shut down for some time //////////////////////////////
        //diposit in referer
        $referer = RegisterUser::where('id',$user->refer_id)->first();

          //   if (!empty($referer)) {
          //       $balance_in_referer = UserBalance::where('user_id',$referer->id)->first();
          //       $balance_in_referer->bonus = $balance_in_referer->bonus + 50;
          //       $balance_in_referer->save();

          //       $randum = rand(1000000,9999999);
          //   $ub_referer_get_again = UserBalance::where('user_id',$referer->id)->first();



          // //Entry for bonus to the referer's account

          // // $trans = DB::table('transactions');
          // // $ins_tran['userid'] = $referer->id;
          // // $ins_tran['refer_id'] = $user->id;
          // // $ins_tran['transaction_id'] = 'L11-EMAILREFER-'.$randum;
          // // $ins_tran['type'] = 'refer bonus on email verification.';
          // // $ins_tran['transaction_by'] = 'LUCKY11';
          // // $ins_tran['transaction_by'] = 'confirmed';
          // // $ins_tran['total_available_amt'] = $ub_referer_get_again->winning+$ub_referer_get_again->balance+$ub_referer_get_again->bonus;
          // // $ins_tran['bal_bonus_amt'] = $ub_referer_get_again->bonus;
          // // $ins_tran['bonus_amt'] = 50;
          // // $ins_tran['amount'] = 50;
          // // $trans->insert($ins_tran);

          //   }
        /////////////////////////// all working just shut down for some time //////////////////////////////

        ///////////////////////////// entry in refer bonus list ///////////////////////////////////////////
        // $refer_bonus_list['user_id'] = $user->refered_by;
        // $refer_bonus_list['refered_by'] = $user->id;
        // $refer_bonus_list['amount'] = 50;
        // DB::table('refer_bonus')->insert($refer_bonus_list);
        /////////////////////////////                           ///////////////////////////////////////////
    return view('mail_views.email_verification')->with('response',$response);
    }
    else {
        $response = "failed";
        return view('mail_views.email_verification')->with('response',$response);
    }
    }

	public function changePassword(Request $request) {
        $value = Session::get('token_for_reset_password');
        $token_coloum = TokenForMail::where('token_reset_password',$value)->first();
        if ($token_coloum == "") {
            Session::flash('message_mail', 'link expired!');
            Session::flash('status', 'no');
            Session::flash('alert-class', 'alert-danger');
            return redirect()->back();
        }
        $password = $request->password;
        $confirm_password = $request->confirm_password;
        if ($password != $confirm_password) {
            Session::flash('message_mail', 'password did not matched!');
            Session::flash('status', 'no');
            Session::flash('alert-class', 'alert-danger');
            return redirect()->back();
        } else {
            $token_coloum->token_reset_password = "";
            $token_coloum->save();
            $email = $token_coloum->email;
            $user = RegisterUser::where('email',$email)->first();
            $user->password = Hash::make($password);
            $user->email_verify = 1;
            $user->save();
            Session::flash('message_mail', 'password changed successfully!');
            Session::flash('status', 'yes');
            Session::flash('alert-class', 'alert-success');
         return redirect()->back();
        }

        // $token = $token_coloum->token_reset_password;
        // $user = RegisterUser::where('email',$request->email)->first();
        // if ($token == $value) {
        //     $user->password = Hash::make($request->password);
        //     $user->save();
        //     Session::flash('message_mail', 'password changed successfully!');
        //     Session::flash('alert-class', 'alert-success');
        //     $token_coloum->token_reset_password = "";
        //     $token_coloum->save();
        //     return redirect()->back();
        // }
        // else {
        //     // echo "token mismatch.";
        //     Session::flash('message_mail', 'token mismatch!');
        //     Session::flash('alert-class', 'alert-danger');
        //     return redirect()->back();
        // }
	}
	public function sendMail ($email_r,$token_r,$button_r=null,$emailsubject_r,$template_message_r,$which_view_open_r,$email_otp=null) {

		$datamessage['email'] = $email_r;
		$datamessage['token'] = $token_r;
		$datamessage['button'] = $button_r;
		$datamessage['subject'] = $emailsubject_r;
		$datamessage['template_message'] = $template_message_r;
		$datamessage['which_view_open'] = $which_view_open_r;
		$datamessage['email_otp'] = $email_otp;


		Helpers::mailSmtpSend($datamessage);

}

    public function resetView (Request $request) {
        session(['token_for_reset_password' => $request->token]);
        return view('mail_views.reset');
	}

    public function generateToken ($email) {
    	$mail = $email;
    	$ran_val_1 = rand(100000,100000000);
    	$ran_val_2 = rand(100000,100000000);
    	$email_and_token = $ran_val_1.$mail.$ran_val_2;
    	$token = md5($email_and_token);
    	return $token;
    }
			public static function saveToken_api($email,$token,$purpose){
    $obj = new MailController();
    $obj->saveToken($email,$token,$purpose);
}

    public function saveToken ($email,$token,$purpose) {
        switch ($purpose) {
        case 'ResetPassword':
            $token_exist = TokenForMail::where('email',$email)->first();
            if (empty($token_exist)) {
                $user = TokenForMail::create([
                'email' => $email,
                'token_reset_password' => $token
                ]);
                $user->save();
            } else {
                $token_exist->token_reset_password = $token;
                $token_exist->save();
            }
            break;
        case 'VerifyEmail':
            $token_exist = TokenForMail::where('email',$email)->first();
            if (empty($token_exist)) {
                $user = TokenForMail::create([
                'email' => $email,
                'token_verify_email' => $token
                ]);
                $user->save();
            } else {
                $token_exist->token_verify_email = $token;
                $token_exist->save();
            }
            break;
        /*case 'RegisterUser':
            $token_exist = TokenForMail::where('email',$email)->first();
            if (empty($token_exist)) {
                $user = TokenForMail::create([
                'email' => $email,
                'token_reset_password' => $token
                ]);
            } else {
                $token_exist->token_reset_password = $token;
            }
            $user->save();
            break;*/


            default:
                # code...
                break;
        }

    }
			public static function sendMail_api($email_r,$token_r,$button_r,$emailsubject_r,$template_message_r,$which_view_open_r,$email_otp=null) {
        $obj = new MailController();
        $obj->sendMail($email_r,$token_r,$button_r,$emailsubject_r,$template_message_r,$which_view_open_r,$email_otp);
    }
}
