<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\RegisterUser;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class PaymentController extends Controller
{

    use SendsPasswordResetEmails, ResetsPasswords {
        SendsPasswordResetEmails::broker insteadof ResetsPasswords;
        ResetsPasswords::credentials insteadof SendsPasswordResetEmails;
    }

    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('jwt', ['except' => ['cashfreeRequest', 'cashfree_checkout']]);
    }

    public function cashfree_checkout($token = null)
    {
        return view("webpages.cashfree_checkout", compact('token'));
    }


    public function cashfreeRequest(Request $request)
    {
        $this->validate($request, [
            'user_id' => 'required',
            'amount' => 'required'
        ]);
        date_default_timezone_set('Asia/Kolkata');
        $post = $_POST;
        $order_id = 'CFP-' . time() . rand(10, 99);
        $min_deposit = MIN_DEPOSIT;
        $max_deposit = MAX_DEPOSIT;
        if (in_array($request->user_id, ['4577', '3339', '2751', '1832', '25', '12', '6', '2'])) {
            $min_deposit = 1;
        }
        if ($request->amount < $min_deposit) {
            return Response::json(["status" => STATUS_FAILURE, "message" => 'Minimum amount should be ₹' . MIN_DEPOSIT]);
        }
        if ($request->amount > MAX_DEPOSIT) {
            return Response::json(["status" => STATUS_FAILURE, "message" => 'Amount maximum add ' . MAX_DEPOSIT]);
        }

        $user = RegisterUser::where('id', $request->user_id)->first();

        if (!empty($user)) {
            $url = "https://sandbox.cashfree.com/pg/orders";
            $headers = [
                "x-client-id: TEST10200902510d61456b8b8834f8d020900201",
                "x-client-secret: cfsk_ma_test_fc13639bd363650dad5131e62af26c0d_b03b067d",
                "Accept: application/json",
                "Content-Type: application/json",
                "x-api-version: 2023-08-01",
            ];

            $data = [
                "order_amount" => (float)$request->amount,
                "order_currency" => "INR",
                "order_id" => $order_id,
                "customer_details" => [
                    "customer_id" => (string) $user->team,
                    "customer_phone" => (string) $user->mobile,
                    "customer_name" => (string) $user->username,
                ],
                "order_meta" => [
                    "return_url" => "https://fantasy.rgisports.com/repos/XL11/admin_XL11/cashfree-return-url/$order_id",
                    "notify_url" => "https://fantasy.rgisports.com/repos/XL11/admin_XL11/cashfree-notify-url/$order_id",
                    //  "payment_methods" => "cc,dc,upi",
                ],
            ];

            $result = [];
            $msg = '';
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                $msg = 'Error:' . curl_error($ch);
            } else {
                $result = json_decode($response);
            }

            curl_close($ch);

            if (!empty($result) && $result->order_status == "ACTIVE") {
                $session_id = $result->payment_session_id;


                $insert_data = [
                    "userid" => $user->id,
                    "amount" => $request->amount,
                    "transaction_by" => "Cashfree",
                    "paymentstatus" => "pending",
                    "transaction_id" => $order_id,
                    "type" => "Add Fund"
                ];
                DB::table('transactions')->insert($insert_data);

                // Request with Actual Live key data
                $res_data = ['payment_url' => "https://fantasy.rgisports.com/repos/XL11/api_XL11/cashfree_checkout/$session_id", "all_data" => $result];
                return Response::json(["status" => STATUS_SUCCESS, "result" => $res_data]);
            }
            return Response::json(["status" => STATUS_FAILURE, "message" => $msg]);
        }

        return Response::json(["status" => STATUS_FAILURE, "message" => 'User not found']);
    }
}
