<?php
  namespace App\Http\Controllers\web;
  use DB;
  use Session;
  use bcrypt;
  use Config;
  use Redirect;
  use Helpers;
  use File;
  use Hash;
  use Carbon\Carbon;
  use Illuminate\Http\Request;
  use App\Http\Controllers\Controller;
  use App\Http\Requests;
  use Illuminate\Support\Facades\Validator;
  use Illuminate\Support\Facades\Input;
  use view;
  use App\Otp;
  use App\User;
  use App\Transaction;
  use App\RegisterUser;
  use App\State;
  use App\Bank;
  use App\PanCard;
  use App\FinalResult;
  use App\UserBalance;
  use App\BonusAmount;


class MoreController extends Controller {
  //Show More Page
  public function index(){
    $user_id = $_SESSION['id'];
$GetUser_email = RegisterUser::where('id', '=', $user_id)->first();
     $useramount = DB::table('userbalances')->where('user_id',$user_id)->first();
     return view('web.more.more',compact('GetUser_email','useramount'));
  }
  //Logout User
  public function logout(){
  //Get User Id And Email
    unset($_SESSION['id']);
    unset($_SESSION['email']);
    //View Page
  return redirect('/');
  }

  public function accessrules(){
    date_default_timezone_set("Asia/Kolkata");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Credentials: true");
    header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    header('Access-Control-Max-Age: 1000');
    header('Access-Control-Allow-Headers: Authorization');
    header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');
  }//End File



  //Contact Us
  public function contact_us(){
    //Admin Data
    $admin =DB::table('users')->where('id','1')->select('email','mobile')->first();
    //$admin =RegisterUser::where('id','1')->select('email','mobile')->first();
    //View Page
    return view('web.more.contact_us',compact('admin'));
  }

  //fantasy points
  public function fantasy_points(){
    //View Page
    return view('web.more.fantasy_points');
  }

  //how to play
  public function how_to_play(){
    //View Page
    return view('web.more.how_to_play');
  }


   public function legalities(){
    //View Page
    return view('web.more.legalities');
  }
  //my_refereed
  public function my_refereed(){
     $user_id = $data['userid'] =  $_SESSION['id'];
   $total_amount = 0;
   $userdata = array();
    // $data = DB::table('refer_bonus')->where('refered_by',$user_id)->get();

    $json = RegisterUser::where('refer_id',$user_id)->select('id','email','username','image')->where('email_verify',1)->where('mobile_verify',1)->limit(100)->get();
    $count_user_data = $json;
    $ids = array();

    if (count($json)) {

      foreach ($json as $j) {

        $ids[] = $j->id;

      }

    }



    if (!empty($ids)) {

      $userdata = Transaction::whereIn('refer_id',$ids)
      // ->select(DB::raw('SUM(amount) as amount'),'userid','refer_id')
      ->groupBy('refer_id')->get();
    // exit();
      $users = array();

      if(count($userdata)){

        foreach ($userdata as $key => $value) {

          $users[$value->refer_id] = $value->amount;

        }

      }

    }


    // print_r($userdata);

     $refer_ids = array();
     foreach ($userdata as $u) {

        $refer_ids[] = $u->refer_id;

      }

      // print_r($refer_ids);
      // print_r($json[0]->id);die;
      $i=0;

      foreach($json as $user){
        $json[$i]->Amount = 0;
          // $userdata = Transaction::where('refer_id',$user->id)->sum('amount');
        if (!empty($refer_ids)) {

           if (in_array($json[$i]->id,$refer_ids)) {
            $json[$i]->name = $user->username;

            // $json[$i]['email'] = $userdata->email;

            $amount = 0;

           if(isset($users) && isset($users[$user->id])) {

            $amount = $users[$user->id];

           }

        $json[$i]->Amount = (int)(number_format((float)@$amount,2, '.', '') ? (int)number_format((float)@$amount,2, '.', '')  : "0");
        $total_amount += $json[$i]->Amount;

        }
        } else {
          $json = array();
        }

        // $json[$i]['userid'] = $userdata->id;

        $i++;

      }

      // $total_user = RegisterUser::where('refer_id',$user_id)->where('email_verify',1)->where('mobile_verify',1)->count();

       $total_user = count($count_user_data);
   // echo json_encode($json);
  //echo '<pre>'; print_r($json);die;

    return view('web.more.my_refereed',compact('json','total_user','total_amount'));

  }

  //user_profile
  public function user_profile(){
    //Get Data
    $formData       = Input::all();
    $user_id=$_SESSION['id'];
    if(!empty($formData)){
      //Set Message
       $message  = array(
          'username.required'           => 'Please enter full name address.',
          'gender.required'             => 'Please select Gender',
          'state.required'              => 'Please enter state.',
          'dob.required'                => 'Please enter dob.',
          'city.required'               => 'Please enter city',
          'pincode.required'            => 'Please enter pincode',
        );
       //Required
        $validate = array(
            'dob'                  => 'required',
            'gender'               => 'required',
            'username'             => 'required',
            'state'                => 'required',
            'city'                 => 'required',
            'pincode'              => 'required',
        );
        //Ckeck Validation
        $validator = Validator::make(Input::all(),$validate,$message);
        if ($validator->fails()){
        return Redirect::back()->withErrors($validator)->withInput();
        //Validation Comp.
        }else{
          $user_data_array=array();
              //Insert Data
              $user_data_array=array(
                 'username' =>$formData['username'],
                 'gender' =>$formData['gender'],
                 'dob' =>$formData['dob'],
                 'state' =>$formData['state'],
                 'city' =>$formData['city'],
                 'pincode' =>$formData['pincode']
              );
              DB::table('registerusers')->where('id',$user_id)->update($user_data_array);
              Session::flash('message', 'Profile Updated Successfully');
              Session::flash('alert-class', 'alert-success');
              return Redirect::to(action('web\MoreController@user_profile'));
        }
    //First Time Page Lode
    }else{
      //Get User Info
      $GetUser_email = RegisterUser::where('id', '=', $user_id)->first();
      //Get State List
      $get_state=State::get();
      //Get User Avatars Image
      // $user_avatars=DB::table('user_avatars')->get();
      // //Get User Avatars Image To Id
      // $user_avatars_image=DB::table('user_avatars')->where('id', '=', $GetUser_email->avatar_id)->first();
      //View
      return view('web.more.user_profile',compact('GetUser_email','get_state'));
    }//End
  }//End Function

  //referral and winners
  public function referral_and_winners(){
    //Get Referr list
    $referrallist=$this->referrallist();
    //Get Winning amount
    $winningamount=$this->winningamount();
    return view('web.more.referral_and_winners',compact('referrallist','winningamount'));
  }

  //Referral list
  public function referrallist(){
     $refer_list = RegisterUser::select(DB::raw('COUNT(id) as totalrefer ,refer_id'))->where('refer_id','!=','0')->where('activation_status','activated')->groupBy('refer_id')->orderBy('totalrefer','DESC')->limit(11)->get();
     //print_r($refer_list);
    foreach ($refer_list as $key => $value) {
      $user_id = $value->refer_id;
      if($user_id) {
        $user_detail = RegisterUser::select('username','email','team')->where('activation_status','activated')->where('id', $user_id)->first();
        if(!empty($user_detail)) {
          $refer_list[$key]->name = !empty($user_detail->team) ? $user_detail->team : $user_detail->username;
        } else {
          unset($refer_list[$key]);
        }
      }
    }
    //echo "<pre>";print_r($refer_list);exit();
    //$referral_list=array_values($refer_list);
    return $refer_list;
  }

  //Winning Amount
  public function winningamount(){
     $win_list = FinalResult::join('registerusers','finalresults.userid','=','registerusers.id')->select(DB::raw('SUM(finalresults.amount) as totalamount ,finalresults.userid, registerusers.username, registerusers.email, registerusers.team'))->groupBy('userid')->orderBy('totalamount','DESC')->limit(10)->get();
    foreach ($win_list as $key => $value) {
      $win_list[$key]->username = !empty($value->team) ? $value->team : $value->username;
    }
    return $win_list;
  }//

  //User Refer Earn
  public function refer_earn(){
    $user_id = $_SESSION['id'];
    $refercode = RegisterUser::where('id',$user_id)->select('refercode')->first();
    return view('web.more.refer_earn',compact('refercode'));
  }//End Function

  //verify detail
  public function verify_detail(){
    $user_id = $_SESSION['id'];
    $formData = Input::all();

      //Get User Info
      $user_info = RegisterUser::where('id', '=', $user_id)->first();
       //Get Pan Card Info
      $pan_data=$query =PanCard::join('registerusers','registerusers.id','=','pancard.userid')->where(function ($query) {
      $query->where('pancard.status','0');
      $query->orWhere('pancard.status','1');
      })->where('registerusers.mobile_verify','1')
      ->where('registerusers.email_verify','1')
      ->where('registerusers.id','=',$user_id)
      ->select('registerusers.email','registerusers.username','pancard.*')->first();
       //Get Bank Info
      $bank_data=$query =Bank::join('registerusers','registerusers.id','=','bank.userid')->where(function ($query) {
      $query->where('bank.status','0');
      $query->orWhere('bank.status','1');
      })->where('registerusers.mobile_verify','1')
      ->where('registerusers.email_verify','1')
      ->where('registerusers.id','=',$user_id)
      ->select('registerusers.email','registerusers.username','bank.*')->first();
      //State
      $get_state=State::get();
      //View Page
       return view('web.more.verify_detail',compact('user_info','pan_data','bank_data','get_state'));

  }//End Function

  //Send Otp
  public function send_otp(){
    $formData = Input::all();
    $user_id = $_SESSION['id'];
    //Get User Info

    $user_info = RegisterUser::where('id', '=', $user_id)->first();
    if(!empty($formData['email'])){
          $mobile_no=$user_info->mobile;
          $email=$formData['email'];
          $rand= rand(100000,999999);
          $_SESSION['verifyotp'] =$rand;
          $message = "Please use OTP ".$rand." to verify your Email address.";
          $subject="Email Verification";
          $sendmail=Helpers::mailsentFormat($email,$subject,$message);
          Session::flash('message', 'OTP Sent To Your Email Id!');
          Session::flash('alert-class', 'alert-success');
          return view('web.more.send_otp',compact('mobile_no','email'));
          //return Redirect::to(action('web\MoreController@send_otp'));
    }else if(!empty($formData['mobile'])){
          $mobile_no=$user_info->mobile;
          $mobile=$formData['mobile'];
          $user = RegisterUser::where('mobile', $formData['mobile'])->first();

          if (!empty($user)) {
            if ($user->mobile_verify == 1) {
               Session::flash('message', 'This mobile is already registered with us!');
               Session::flash('alert-class', 'alert-danger');
               return redirect()->back();
            }
          }

          $rand= rand(100000,999999);
          $_SESSION['verifyotp'] =$rand;
          $message = "Please use OTP ".$rand." to verify your mobile number.";

          //check otp limit
          $otp = Otp::where('mobile',$mobile)->first();
          if (!empty($otp)) {
              if ($otp->count >= OTP_MAX_LIMIT) {
                  Session::flash('message', 'You have reached maximum limit to send otp on your mobile!');
                  Session::flash('alert-class', 'alert-danger');
                  return redirect()->back(); die;
              } else {
                  $otp_count = $otp->count;
                  $otp_update['count'] = $otp_count + 1;
                  DB::table('otp')->where('mobile',$_SESSION['mobile'])->update($otp_update);
              }
          } else {
              $otp_new['mobile'] = $_SESSION['mobile'];
              $otp_new['count'] = 0;
              DB::table('otp')->insert($otp_new);
          }


          Helpers::sendTextSmsNew($message,$mobile);
          Session::flash('message', 'OTP Sent!');
          Session::flash('alert-class', 'alert-success');
         return view('web.more.send_otp',compact('mobile_no','mobile'));
    }//End Condition
  }//End Function


  //Send Otp
  public function resend_verify_otp(){
    $formData = Input::all();
    $user_id = $_SESSION['id'];
    //Get User Info
    if(!empty($formData['email'])){
          $email=$formData['email'];
          $rand= rand(100000,999999);
          $_SESSION['verifyotp'] =$rand;
          $message = "Please use OTP ".$rand." to verify your Email address.";
          $subject="Email Verification";
          $sendmail=Helpers::mailsentFormat($email,$subject,$message);
          Session::flash('message', 'OTP Sent To Your Email Id!');
          Session::flash('alert-class', 'alert-success');
          $_SESSION['back_match_code'] = 'yes';
          return view('web.more.send_otp',compact('email'));
          //return Redirect::to(action('web\MoreController@send_otp'));
    }else if(!empty($formData['mobile'])){
          $mobile=$formData['mobile'];
          $rand= rand(100000,999999);
          $_SESSION['verifyotp'] =$rand;
          $message = "Please use OTP ".$rand." to verify your mobile number.";

          //check otp limit
          $otp = Otp::where('mobile',$mobile)->first();
          if (!empty($otp)) {
              if ($otp->count >= OTP_MAX_LIMIT) {
                  Session::flash('message', 'You have reached maximum limit to send otp on your mobile!');
                  Session::flash('alert-class', 'alert-danger');
                  return redirect()->back(); die;
              } else {
                  $otp_count = $otp->count;
                  $otp_update['count'] = $otp_count + 1;
                  DB::table('otp')->where('mobile',$_SESSION['mobile'])->update($otp_update);
              }
          } else {
              $otp_new['mobile'] = $_SESSION['mobile'];
              $otp_new['count'] = 0;
              DB::table('otp')->insert($otp_new);
          }

          Helpers::sendTextSmsNew($message,$mobile);
          Session::flash('message', 'OTP Sent!');
          Session::flash('alert-class', 'alert-success');
         return view('web.more.send_otp',compact('mobile'));
    }//End Condition
  }//End Function

  //Send Otp
  public function verify_otp(){
    $formData = Input::all();
    $user_id = $_SESSION['id'];
    //Email Verify
    if(!empty($formData['email'])){
        if($_SESSION['verifyotp']==$formData['verifyOtp']){
          unset($_SESSION['verifyotp']);
          $user_info['email_verify']=1;
          DB::table('registerusers')->where('id',$user_id)->update($user_info);
          Session::flash('message', 'Email Id is Verified!');
          Session::flash('alert-class', 'alert-success');
          $this->checkVerification($user_id);
          return Redirect::to(action('web\MoreController@verify_detail'));
          //return Redirect::to(action('web\MoreController@send_otp'));
        }else{
          Session::flash('message', 'Otp Is Not Match!');
          Session::flash('alert-class', 'alert-danger');
          return Redirect::to(action('web\MoreController@verify_detail'));
        }
    //Mobile Verify
    }else{
       if($_SESSION['verifyotp']==$formData['verifyOtp']){
          unset($_SESSION['verifyotp']);
          $user_info['mobile_verify']=1;

          $user_info['mobile']=$formData['mobile'];

          DB::table('registerusers')->where('id',$user_id)->update($user_info);
          Session::flash('message', 'Mobile Number is Verified!');
          Session::flash('alert-class', 'alert-success');
          return Redirect::to(action('web\MoreController@verify_detail'));
          //return Redirect::to(action('web\MoreController@send_otp'));
        }else{
          Session::flash('message', 'Otp Is Not Match!');
          Session::flash('alert-class', 'alert-danger');
          return Redirect::to(action('web\MoreController@verify_detail'));
        }

    }//End Condition

  }//End Function

  //Ckeck Verification
  public function checkVerification($id){
    $userdata = RegisterUser::where('id',$id)->first();
      if($userdata->email_verify == '1'){
        if($userdata->mobile_verify == '1'){
      $bonus = BonusAmount::where('type','Signup bonus')->first();
      $price=0;
      $price = $bonus->price;
      $userBalance = UserBalance::where('user_id',$id)->first();
      $datab['bonus']= $userBalance->bonus + $price;
      DB::table('userbalances')->where('user_id',$id)->update($datab);
      $notidata['userid']= $id;
      $notidata['title']= "Signup bonus Rs. ".$price;
      DB::table('notifications')->insert($notidata);
      $titleget = "Add Signup amount";
      Helpers::sendnotification($titleget,$notidata['title'],'',$id);

      $transactionsdata['userid'] = $id;
      $transactionsdata['type'] = 'Email verification Bonus Added';
      $transactionsdata['transaction_id'] = "CLUB11-AV-".$id;
      $transactionsdata['transaction_by'] = "CLUB11";
      $transactionsdata['amount'] = $price;
      $transactionsdata['addfund_amt'] = $bonus->price;
      $transactionsdata['paymentstatus'] = 'confirmed';
      $transactionsdata['bal_fund_amt'] = $userBalance->balance;
      $transactionsdata['bal_win_amt'] = $userBalance->winning;
      $transactionsdata['bal_bonus_amt'] = $userBalance->bonus+$price;
      $transactionsdata['cons_amount'] = 0;
      $transactionsdata['total_available_amt'] = $userBalance->winning+$userBalance->balance+$userBalance->bonus+$price;

      // bonus to user who referred

      // if($userdata->refer_id != 0) { //echo 1;
      //   $bonus_r = DB::table('bonus_amount')->where('type',"Refer Bonus")->first();
      //   $bonus_type_r = $bonus_r->bonus_type;
      //   $price_r = $bonus_r->price;
      //   $datac['bonus']= $userBalance->bonus + $price + $price_r; //print_r($datac);
      //   DB::table('userbalances')->where('user_id',$id)->update($datac);

      //     $transactionsdata_r['userid'] = $userdata->id;
      //     $transactionsdata_r['type'] = 'Refer Bonus Added for account varification';
      //     $transactionsdata_r['transaction_id'] = "CLUB11-AV-".$userdata->refer_id;
      //     $transactionsdata_r['transaction_by'] = "CLUB11";
      //     $transactionsdata_r['amount'] = $price_r;
      //     $transactionsdata_r['bonus_amt'] = $bonus_r->price;
      //     $transactionsdata_r['paymentstatus'] = 'confirmed';
      //     $transactionsdata_r['bal_fund_amt'] = $userBalance->balance;
      //     $transactionsdata_r['bal_win_amt'] = $userBalance->winning;
      //     $transactionsdata_r['bal_bonus_amt'] = $userBalance->bonus+$price_r;
      //     $transactionsdata_r['cons_amount'] = 0;
      //     $transactionsdata_r['total_available_amt'] = $userBalance->winning+$userBalance->balance+$userBalance->bonus+$price_r; //print_r($transactionsdata_r);
      //     DB::table('transactions')->insert($transactionsdata_r); //exit;
      // }

      if($userdata->refer_id != 0){

          $transactionsdata['refer_id'] = $userdata->refer_id;
          $userBalance_r = UserBalance::where('user_id',$userdata->refer_id)->first();
            $bonus_r = BonusAmount::where('type',"Refer Bonus")->first();
            $bonus_type_r = $bonus_r->bonus_type;
            $price_r = $bonus_r->price;
            $datainseertt_r['bonus'] = $userBalance_r->bonus+$price_r;
            $datainseertt_r['refer_id']= $id;
          DB::table('userbalances')->where('user_id',$userdata->refer_id)->update($datainseertt_r);

          $transactionsdata_r['userid'] = $userdata->refer_id;
          $transactionsdata_r['type'] = 'Refer Bonus Added for account varification';
          $transactionsdata_r['transaction_id'] = "CLUB11-AV-".$userdata->refer_id;
          $transactionsdata_r['transaction_by'] = "CLUB11";
          $transactionsdata_r['amount'] = $price_r;
          $transactionsdata_r['bonus_amt'] = $bonus_r->price;
          $transactionsdata_r['paymentstatus'] = 'confirmed';
          $transactionsdata_r['bal_fund_amt'] = $userBalance_r->balance;
          $transactionsdata_r['bal_win_amt'] = $userBalance_r->winning;
          $transactionsdata_r['bal_bonus_amt'] = $userBalance_r->bonus+$price_r;
          $transactionsdata_r['cons_amount'] = 0;
          $transactionsdata_r['total_available_amt'] = $userBalance_r->winning+$userBalance_r->balance+$userBalance_r->bonus+$price_r;
          DB::table('transactions')->insert($transactionsdata_r);

            $notidata_r['userid']= $userdata->refer_id;
            $notidata_r['title']= "Refer bonus Rs. ".$price_r;
          DB::table('notifications')->insert($notidata_r);

          $titleget_r = "Add Refer Bonus";
          Helpers::sendnotification($titleget_r,$notidata_r['title'],'',$userdata->refer_id);
      }

      DB::table('transactions')->insert($transactionsdata);
      }
    }
  }

  //Verify Pancard
  public function pan_verify(Request $request){
    //Get Data
    $formData = Input::all();
    //Get User Id
    $user_id = $_SESSION['id'];
    if(!empty($formData)){
      //Message
        $message  = array(
          'pan_name.required'           => 'Please enter name.',
          'pan_number.required'         => 'Please enter pan number.',
         // 'pan_dob.required'            => 'Please enter date of birth.',
          // 'image.required'              => 'Please upload image file'
        );
        //Required
        $validate = array(
            'pan_name'             => 'required',
            'pan_number'           => 'required',
            // 'pan_dob'              => 'required',
            // 'image'                => 'required'
        );
        //Validation
        $validator = Validator::make(Input::all(),$validate,$message);
        if ($validator->fails()){
        //return Redirect::back()->withErrors($validator)->withInput();
        // return response()->json(['status'=>'error','errors' => $validator->getMessageBag()->toArray(),'message'=>trans("Please fill all required fields.")]);
        Session::flash('message', 'Please fill all required fields.!');
        Session::flash('alert-class', 'alert-danger');
        return Redirect::to(action('web\MoreController@verify_detail'));

        //Validation Comp.
        }else{
          DB::table('pancard')->where('userid', $user_id)->delete();
          $geturl=base_path();

         $pan_data=$query =RegisterUser::where('mobile_verify','1')
          ->where('email_verify','1')
          ->where('id','=',$user_id)
          ->select('registerusers.email','registerusers.mobile_verify','registerusers.username','registerusers.email_verify')->first();



          // if ($pan_data->mobile_verify != 1) {
          //  Session::flash('message', 'Please verify your mobile number!');
          //   Session::flash('alert-class', 'alert-danger');
          //   return Redirect::to(action('web\MoreController@verify_detail'));
          // }
          // if ($pan_data->email_verify != 1) {
          //  // return response()->json(['status'=>'verify','message'=>trans("Please Verify Email Id.!")]); exit;
          //   Session::flash('message', 'Please verify Email Id!');
          //   Session::flash('alert-class', 'alert-danger');
          //   return Redirect::to(action('web\MoreController@verify_detail'));
          // }
          // $pan_data=$query =DB::table('pancard')->join('registerusers','registerusers.id','=','pancard.userid')->where(function ($query) {
          // $query->where('pancard.status','0');
          // $query->orWhere('pancard.status','1');
          // })->where('registerusers.mobile_verify','1')
          // ->where('registerusers.email_verify','1')
          // ->where('registerusers.id','=',$user_id)
          // ->select('registerusers.email','registerusers.username','pancard.*')->first();
          if(isset($pan_data) && !empty($pan_data)){
          //Image Insert

          if(Input::hasFile('image')){
             $file = Input::file('image');
            $img_ext='jpeg,jpg,png,JPEG,JPG,PNG';
            $extension = $file->getClientOriginalExtension();
            $img_ext = explode(",",$img_ext);
            if(in_array($extension,$img_ext)){
              $fileName       = time().'-pancard-image.'.$extension;
             $url= UPLOAD_DIRECTORY_URL.'pancard/';
              $dir_path = UPLOAD_DIRECTORY.'pancard/';

             $siteurl = BASE_URL;
              if($file->move($dir_path, $fileName)){
                $userdata['image'] = UPLOAD_DIRECTORY_URL.'pancard/'.$fileName;
              }
            }
            else {
            // return response()->json(['status'=>'error','message'=>trans("Please upload only jpg, jpeg and png format.!")]);
            Session::flash('message', 'Please upload only jpg, jpeg and png format.!');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::to(action('web\MoreController@verify_detail'));

              }

           }
            else {
              // return response()->json(['status'=>'error','message'=>trans("Please upload Image!")]);
            Session::flash('message', 'Please upload only jpg, jpeg and png format.!');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::to(action('web\MoreController@verify_detail'));
             }

             // if(Input::hasFile('image')){
             //  $img_ext='jpeg,jpg,png,JPEG,JPG,PNG';
             //  $extension        = Input::file('image')->getClientOriginalExtension();
             //  $img_ext = explode(",",$img_ext);
             //  if(in_array($extension,$img_ext)){
             //    $fileName       = time().'-pancard-image.'.$extension;
             //    $url= $geturl.'/uploads/pancard/';
             //    if(Input::file('image')->move($url, $fileName)){
             //      $userdata['image'] = $fileName;
             //    }
             //  } else {
             //    return response()->json(['status'=>'error','message'=>trans("Please upload only jpg, jpeg and png format.!")]);
             //  }
             // } else {
             //  return response()->json(['status'=>'error','message'=>trans("Please upload Image!")]);
             // }
          ///Userdata
          //Set Val
          $userdata['pan_name']=$formData['pan_name'];
          $userdata['pan_number']=$formData['pan_number'];
        //  $userdata['pan_dob']=$formData['pan_dob'];
          $userdata['status']=0;
          $userdata['userid']=$user_id;
          //Insert
          DB::table('pancard')->insert($userdata);

          //Update Pan Status
          $pan_verify['pan_verify']=0;
          DB::table('registerusers')->where('id', $_SESSION['id'])->update($pan_verify);
          //Show Page Path
          // return response()->json(['status'=>'success','message'=>trans("Pan Verify Request Submit!")]);
          Session::flash('message', 'Pan Verify Request Submit!');
            Session::flash('alert-class', 'alert-success');
            return Redirect::to(action('web\MoreController@verify_detail'));
          die;
        //Ckeck Email And Mobile Verify
        }else{
          // return response()->json(['status'=>'verify','message'=>trans("Please Verify Email Id And Mobile No.!")]); exit;
          Session::flash('message', 'Please Verify Email Id And Mobile No.!');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::to(action('web\MoreController@verify_detail'));
        }//End
        }
    //first Time Page Lode
    }else{
      return Redirect::to(action('web\MoreController@verify_detail'));
    }//End Function
  }//End Function

  //Verify Pancard
  public function bank_verify(Request $request){
    //Get Data
    $formData = Input::all();
    //Get User Id
    // print_r($formData);die;
    $user_id = $_SESSION['id'];
    if(!empty($formData)){
      //Set Message
        $message  = array(
         // 'ac_holder_name.required'  => 'Please enter name.',
          'accno.required'           => 'Please enter A/C no.',
          'ifsc.required'            => 'Please enter ifsc no.',
          'bankname.required'        => 'Please enter bank name.',
        //  'state.required'           => 'Please enter state name.',
        );
        //Validation required
        $validate = array(
          //  'ac_holder_name'  => 'required',
            'accno'           => 'required',
            'ifsc'            => 'required',
            'bankname'        => 'required',
          //  'state'           => 'required',
        );
        //Validation
        $validator = Validator::make(Input::all(),$validate,$message);
        if ($validator->fails()){
        //return Redirect::back()->withErrors($validator)->withInput();
        Session::flash('message', 'Please fill all required fields.');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::to(action('web\MoreController@verify_detail'));
        // return response()->json(['status'=>'error','errors' => $validator->getMessageBag()->toArray(),'message'=>trans("Please fill all required fields.")]);
        //Validation Comp.
        }else{
            //delete Delete Bank Data
            DB::table('bank')->where('userid', $user_id)->delete();
            //Set Image Path
            $geturl=base_path();
            //Get Bank Info
            $bank_data=$query =RegisterUser::where('mobile_verify','1')
            ->where('email_verify','1')
            ->where('id','=',$user_id)
            ->select('registerusers.email','registerusers.username')->first();
            if(isset($bank_data) && !empty($bank_data)){
            if($request->hasFile('image')){
               $file = $request->file('image');
              $img_ext='jpeg,jpg,png,JPEG,JPG,PNG';
              $extension        = $file->getClientOriginalExtension();
              $img_ext = explode(",",$img_ext);
              if(in_array($extension,$img_ext)){
                $fileName       = time().'-bank-image.'.$extension;
                $url= UPLOAD_DIRECTORY_URL.'bank/';
                $siteurl = BASE_URL;

             $dir_path = UPLOAD_DIRECTORY.'bank/';
                if($file->move($dir_path, $fileName)){
                  $userdata['image'] =UPLOAD_DIRECTORY_URL.'bank/'.$fileName;
                }

              }
             }
            ///Set Val To Insert Data Userdata
         //   $userdata['ac_holder_name']=$formData['ac_holder_name'];
            $userdata['accno']=$formData['accno'];
            $userdata['ifsc']=$formData['ifsc'];
            $userdata['status']=0;
            $userdata['userid']=$user_id;
            $userdata['bankname']=$formData['bankname'];
         //   $userdata['state']=$formData['state'];
            DB::table('bank')->insert($userdata);
          //Show Page
           Session::flash('message', 'Bank Verify Request Submit!');
            Session::flash('alert-class', 'alert-success');
            return Redirect::to(action('web\MoreController@verify_detail'));
          // return response()->json(['status'=>'success','redirect_url'=>action('web\MoreController@verify_detail'),'message'=>trans("Bank Verify Request Submit!")]); exit;
        //Verify Ckeck Email And Mobile
        }else{
          Session::flash('message', 'Please Verify Email Id And Mobile No.!');
            Session::flash('alert-class', 'alert-danger');
            return Redirect::to(action('web\MoreController@verify_detail'));
            // return response()->json(['status'=>'error','redirect_url'=>action('web\MoreController@verify_detail'),'message'=>trans("Please Verify Email Id And Mobile No.!")]); exit;
        }
      }//End Condition
    }else{
      return Redirect::to(action('web\MoreController@verify_detail'));
    }//End Function
  }//End Function

  //Change Password
  public function change_password(Request $request){
    //Get Data

    $formData = Input::all();
    //Get User Id
    $user_id = $_SESSION['id'];
    if(!empty($formData)){
          $message  = array(
            'old_password.required'     => 'Please enter old password.',
            'new_password.required'     => 'Please enter new password.',
            'confirm_password.required' => 'Please enter confirm password.',
          );
          $validate = array(
              'old_password'      => 'required',
              'new_password'      => 'required|min:6',
              'confirm_password'  => 'required|same:new_password',
          );
          $validator = Validator::make(Input::all(),$validate,$message);
          if ($validator->fails()){
          return Redirect::back()->withErrors($validator)->withInput();
          //Validation Comp.
          }else{
            $get_user=RegisterUser::where('id', $user_id)->first();
            if(Hash::check($request->old_password,$get_user->password)){
            ///Userdata
            $userdata['password']=Hash::make($formData['new_password']);

            //Update Password
            DB::table('registerusers')->where('id',$user_id)->update($userdata);
            //Message

            Session::flash('message', 'Password Update Successfully!');
            Session::flash('alert-class', 'alert-success');
            return Redirect::to(action('web\MoreController@change_password'));
            }else{
              //Message
              Session::flash('message', 'Old Password Not Match!');
              Session::flash('alert-class', 'alert-danger');
              return Redirect::to(action('web\MoreController@change_password'));
            }

          }//End Condition
    }else{
      return view('web.more.change_password');
    }
  }//End

  //User Edit Avatar
  public function avatar_edit(){
    //Get Value
    $formData = Input::all();
    //Get User Id
    $user_id=$_SESSION['id'];
    if(!empty($formData)){
      //Message
        $message  = array(
          'avatar_id.required'           => 'Please Select Avatar.',
        );
        //Required
        $validate = array(
            'avatar_id'             => 'required',
        );
        //Validation
        $validator = Validator::make(Input::all(),$validate,$message);
        if ($validator->fails()){
        return response()->json(['status'=>'error','errors' => $validator->getMessageBag()->toArray(),'message'=>trans("Please Select Avatar.")]);
        //Validation Comp.
        }else{
          //Set Val
          $userdata['avatar_id']=$formData['avatar_id'];
          //Insert Avatar id
          DB::table('registerusers')->where('id',$user_id)->update($userdata);
          //Show Page Path
          return response()->json(['status'=>'success','message'=>trans("Avatar Submit!")]);
          exit;
        }
    //first Time Page Lode
    }else{
      return Redirect::to(action('web\MoreController@user_profile'));
    }//End Function
  }


    public function userPanDataSubmit(Request $request){
        $this->accessrules();
        $formData = $request->all();
        if(!empty($formData)){
            $message  = array(
              'pan_name.required'           => 'Please enter name.',
              'pan_number.required'         => 'Please enter pan number.',
              'pan_image.required'          => 'Please upload pan image'
            );
            $validate = array(
                'pan_name'             => 'required',
                'pan_number'           => 'required',
                'pan_image'            => 'required'
            );
            $validator = Validator::make($formData,$validate,$message);
            if ($validator->fails()){
                $error_message = array("message"=>"Please fill all required fields.!","status"=>500);
                echo json_encode($error_message);
                die();

            }else{
                $user_id = $formData['user_id'];
                DB::table('pancard')->where('userid', $user_id)->delete();

                $pan_data=$query =DB::table('registerusers')->where('mobile_verify','1')
                ->where('email_verify','1')
                ->where('id','=',$user_id)
                ->select('registerusers.email','registerusers.mobile_verify','registerusers.username','registerusers.email_verify')->first();

              if(isset($pan_data) && !empty($pan_data)){
                  if($formData['pan_image']){
                      $file = $formData['pan_image'];
                      $img_ext='jpeg,jpg,png,JPEG,JPG,PNG';
                      $extension = $file->getClientOriginalExtension();
                      $img_ext = explode(",",$img_ext);
                      if(in_array($extension,$img_ext)){
                          $nm="";
                          $rand=rand(10000,1000000);
                          $nm.=$rand.time();
                          $fileName='FantasyPower11-pancard-'.$nm.'.'.$extension;
                          $dir_path = USERS_DIRECTORY;
                          if($file->move($dir_path, $fileName)){
                              $userdata['image'] = USERS_DIRECTORY_URL.$fileName;
                          }

                          // Helpers::aws_upload_image(USERS_DIRECTORY.$fileName, "uploads/users/",$fileName);

                      }
                      else {
                          $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                          echo json_encode($error_message);
                          die();
                      }

                  }
                  else {
                      $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                      echo json_encode($error_message);
                      die();
                  }

                  $userdata['pan_name']=$formData['pan_name'];
                  $userdata['pan_number']=$formData['pan_number'];
                  $userdata['status']=0;
                  $userdata['userid']=$user_id;

                  DB::table('pancard')->insert($userdata);

                  $pan_verify['pan_verify']=0;
                  DB::table('registerusers')->where('id', $user_id)->update($pan_verify);
                  $success_message = array("message"=>"Pan Verify Request Submit!","status"=>200);
                  echo json_encode($success_message);
                  die();

              } else {
                  $error_message = array("message"=>"Please Verify Email Id And Mobile No.!","status"=>500);
                  echo json_encode($error_message);
                  die();
              }//End
          }
        } else {
            return Redirect::to(action('web\MoreController@verify_detail'));
        }//End Function
    }//End Function


    public function userBankDataSubmit(Request $request){
        $this->accessrules();
        $formData = $request->all();
        if(!empty($formData)){
            $message  = array(
              'accno.required'           => 'Please enter A/C no.',
              'ifsc.required'            => 'Please enter ifsc no.',
              'bankname.required'        => 'Please enter bank name.',
              'bank_image.required'      => 'Please upload passbook image'
            );
            $validate = array(
                'accno'             => 'required',
                'ifsc'           => 'required',
                'bankname'            => 'required',
                'bank_image'    => 'required'
            );
            $validator = Validator::make($formData,$validate,$message);
            if ($validator->fails()){
                $error_message = array("message"=>"Please fill all required fields.!","status"=>500);
                echo json_encode($error_message);
                die();

            }else{
                $user_id = $formData['user_id'];
                DB::table('bank')->where('userid', $user_id)->delete();

                $bank_data=$query =DB::table('registerusers')
                                        ->where('mobile_verify','1')
                                        ->where('email_verify','1')
                                        ->where('id','=',$user_id)
                                        ->select('registerusers.email','registerusers.username')
                                        ->first();

                if(isset($bank_data) && !empty($bank_data)){
                    if($formData['bank_image']){
                        $file = $formData['bank_image'];
                        $img_ext='jpeg,jpg,png,JPEG,JPG,PNG';
                        $extension = $file->getClientOriginalExtension();
                        $img_ext = explode(",",$img_ext);
                        if(in_array($extension,$img_ext)){
                            $nm="";
                            $rand=rand(10000,1000000);
                            $nm.=$rand.time();
                            $fileName='FantasyPower11-bank-'.$nm.'.'.$extension;
                            $dir_path = USERS_DIRECTORY;
                            if($file->move($dir_path, $fileName)){
                                $userdata['image'] = USERS_DIRECTORY_URL.$fileName;
                            }

                            // Helpers::aws_upload_image(USERS_DIRECTORY.$fileName, "uploads/users/",$fileName);
                        }
                        else {
                            $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                            echo json_encode($error_message);
                            die();
                        }

                    }
                    else {
                        $error_message = array("message"=>"Please upload only jpg, jpeg and png format.!","status"=>500);
                        echo json_encode($error_message);
                        die();
                    }

                    $userdata['ac_holder_name'] = $formData['ac_holder_name'];
                    $userdata['accno']=$formData['accno'];
                    $userdata['ifsc']=$formData['ifsc'];
                    $userdata['status']=0;
                    $userdata['userid']=$user_id;
                    $userdata['bankname']=$formData['bankname'];

                    DB::table('bank')->insert($userdata);

                    $bank_verify['bank_verify']=0;
                    DB::table('registerusers')->where('id', $user_id)->update($bank_verify);
                    $success_message = array("message"=>"Pan Verify Request Submit!","status"=>200);
                    echo json_encode($success_message);
                    die();

                } else {
                    $error_message = array("message"=>"Please Verify Email Id And Mobile No.!","status"=>500);
                    echo json_encode($error_message);
                    die();
                }//End
          }
        } else {
            return Redirect::to(action('web\MoreController@verify_detail'));
        }//End Function
    }//End Function

    public function checkRemoteFile($url) {
        $url = str_replace(' ', '%20', $url);
        $file_headers = @get_headers($url);
        if (strpos($file_headers[0], "200 OK") > 0) {
           return true;
        } else {
          return false;
        }
    }





}
?>
