<?php
  namespace App\Http\Controllers\web;
  require_once 'Google/src/config.php';
  require_once 'Google/src/Google_Client.php';
  require_once 'Google/src/contrib/Google_PlusService.php';
  require_once 'Google/src/contrib/Google_Oauth2Service.php';
  require_once 'vendor/autoload.php';
  use DB;
  use Session;
  use bcrypt;
  use Config;
  use Redirect;
  use Helpers;
  use File;
  use Hash;
  // use Session;
  use Carbon\Carbon;
  use Illuminate\Http\Request;
  use App\Http\Controllers\Controller;
  use App\Http\Requests;
  use Illuminate\Support\Facades\Validator;
  use Illuminate\Support\Facades\Input;
  use View;
  use Response;
  use Google_Client;
  use Google_PlusService;
  use Google_Oauth2Service;
  use App\RegisterUser;
  use App\UserBalance;
  use App\TokenForMail;
  use App\RegisterUserTemp;
  use App\Otp;

class SignupController extends Controller {

   public function index(){
    //Get Val
    $formData       = Input::all();
    if(!empty($formData)){
        $message  = array(
          //  'image.max'                   =>  MAX_IMAGE_SIZE,
            'mobile.required'         => 'Please enter Mobile No.',
        );
        $validate = array(
            'mobile'                => 'required|numeric',
        );
        $validator = Validator::make(Input::all(),$validate,$message);
        if ($validator->fails()){
        return Redirect::back()->withErrors($validator)->withInput();
        //Validation Comp.
        }else{
          if(strlen($formData['mobile']) < 10 || strlen($formData['mobile']) > 10) {
            Session::flash('message', 'Mobile No must be exact  10 numbers!');
             Session::flash('alert-class', 'alert-danger');
             return View::make('web.signup.signup1');
         }
          $GetUser_mobile = RegisterUser::where('mobile', '=', $formData['mobile'])->first();
          if(empty($GetUser_mobile)){
             $_SESSION['mobile'] =$formData['mobile'];
             $rand= rand(100000, 999999);
             $_SESSION['otp'] =$rand;
             Session::put('mobile', $formData['mobile']);
              Session::put('otp', $rand);
             $message = "Please use OTP ".$rand." to verify your mobile number.";

///////////////// otp limit   //////
               $otp = DB::table('otp')->where('mobile',$_SESSION['mobile'])->first();
               if (!empty($otp)) {
                   if ($otp->count >= OTP_MAX_LIMIT) {
                        unset($_SESSION['id']);
                        Session::flash('message', 'You have reached maximum limit to send otp on your mobile!');
                        Session::flash('alert-class', 'alert-danger');
                        return redirect()->back(); die;
                   } else {
                      $otp_count = $otp->count;
                      $otp_update['count'] = $otp_count + 1;

                      DB::table('otp')->where('mobile',$_SESSION['mobile'])->update($otp_update);
                   }
               } else {
                  $otp_new['mobile'] = $_SESSION['mobile'];
                  $otp_new['count'] = 0;
                  DB::table('otp')->insert($otp_new);

               }

             Helpers::sendTextSmsNew($message,$_SESSION['mobile']);
             Session::flash('message', 'OTP Sent!');
             Session::flash('alert-class', 'alert-success');
              return Redirect::to(action('web\SignupController@verify_otp'));
            // return View::make('web.signup.signup2');
          }else{
             Session::flash('message', 'Mobile No Already Exist!');
             Session::flash('alert-class', 'alert-danger');
             return View::make('web.signup.signup1');
          }
        }
      //First Time Page Lode
    }else{
        return View::make('web.signup.signup1');
    }
  }//End Function

   public function forgot_password() {
    $formData = Input::all();
    if(isset($formData['email'])) {
      $email = $formData['email'];
        $user = RegisterUser::where('email',$email)->first();
        if (!isset($user->email)) {
          Session::flash('message', 'invalid details.');
    Session::flash('alert-class', 'alert-danger');
    return Redirect::back();
            // return Response::json(["status" => 0,"message" => "invalid details.", "result" => ["status"=>"failed."]]);die;
        }

        $token = $this->generateToken($email);
        $button = "Reset Password";
        $emailsubject = "reset password link";
        $template_message = "Click on the button below to reset your password. This link will expire in 60 minutes.";
        $which_view_open = "ResetPassword";
        $purpose = "ResetPassword";
    $this->saveToken($email,$token,$purpose);
    $this->sendMail($email,$token,$button,$emailsubject,$template_message,$which_view_open);
    Session::flash('message', 'Password reset link sent to your registered email id.!');
    Session::flash('alert-class', 'alert-success');
    return Redirect::back();
  } else {
      return View::make('web.signup.forgot_password');
    }
  }


   public function generateToken ($email) {
      $mail = $email;
      $ran_val_1 = rand(100000,100000000);
      $ran_val_2 = rand(100000,100000000);
      $email_and_token = $ran_val_1.$mail.$ran_val_2;
      $token = md5($email_and_token);
      return $token;
    }

     public function saveToken ($email,$token,$purpose) {
        switch ($purpose) {
          case 'ResetPassword':
              $token_exist = TokenForMail::where('email',$email)->first();
              if (empty($token_exist)) {
                $user['email'] = $email;
                $user['token_reset_password'] = $token;
                  // $user = TokenForMail::create([
                  // 'email' => $email,
                  // 'token_reset_password' => $token
                  // ]);
                  // $user->save();
                DB::table('token_for_mails')->insert($user);
              } else {

                  $token_data['token_reset_password'] = $token;
                  DB::table('token_for_mails')->where('email',$email)->update($token_data);
              }
              break;
          case 'VerifyEmail':
              $token_exist = TokenForMail::where('email',$email)->first();
              if (empty($token_exist)) {
                  $user['email'] = $email;
                  $user['token_verify_email'] = $token;

                  DB::table('token_for_mails')->insert($user);
              } else {

                $token_data['token_verify_email'] = $token;
                DB::table('token_for_mails')->where('email',$email)->update($token_data);

              }
              break;

              default:
                  # code...
                  break;
        }

    }


    public function sendMail ($email_r,$token_r,$button_r,$emailsubject_r,$template_message_r,$which_view_open_r) {
        $datamessage['email'] = $email_r;
        $datamessage['token'] = $token_r;
        $datamessage['button'] = $button_r;
        $datamessage['subject'] = $emailsubject_r;
        $datamessage['template_message'] = $template_message_r;
        $datamessage['which_view_open'] = $which_view_open_r;
        Helpers::mailSmtpSend($datamessage);
    }

  public function match_code() {
     if (isset($_SESSION['back_match_code'])) {
      if ($_SESSION['back_match_code'] == 'yes') {
      Session::flash('message', 'Session expired!');
      Session::flash('alert-class', 'alert-danger');
      unset($_SESSION['back_match_code']);
      return Redirect::to(action('web\LoginController@index'));
    }
    }
    $formData = Input::all();
    if(isset($formData['otp'])) {
      $otp = $formData['otp'];
      if(!empty($otp)) {
        $id = $_SESSION['forgot_id'];
        $checkuser = RegisterUser::where('code', $otp)->where('id', $id)->first();
        if(!empty($checkuser)) {
          Session::flash('message', 'OTP verified!');
          Session::flash('alert-class', 'alert-success');
          unset($_SESSION['back']);
          return Redirect::to(action('web\SignupController@reset_password'));
        } else {
          Session::flash('message', 'OTP not matched!');
          Session::flash('alert-class', 'alert-danger');
          return Redirect::back();
        }
      } else {
        Session::flash('message', 'Please enter OTP!');
        Session::flash('alert-class', 'alert-danger');
        return Redirect::back();
      }
    } else {
      return View::make('web.signup.reset_password');
    }
  }

  public function reset_password() {
    if (isset($_SESSION['back'])) {
      if ($_SESSION['back'] == 'yes') {
      Session::flash('message', 'Session expired!');
      Session::flash('alert-class', 'alert-danger');
      unset($_SESSION['back']);
      return Redirect::to(action('web\LoginController@index'));
    }
    }

    $formData = Input::all();
    if(isset($formData['password']) && isset($formData['confirm_password'])) {
      if (!empty($formData['password']) && !empty($formData['confirm_password'])) {
        $password = $formData['password'];
        $confirm_password = $formData['confirm_password'];
        if($password==$confirm_password) {
          $user_id = $_SESSION['forgot_id'];
          $update_data['password'] = $password;
          $update_data['code'] = '';
          DB::table('registerusers')->where('id', $user_id)->update($update_data); //echo 'yes'; exit;
          $_SESSION['back'] = 'yes';
          $_SESSION['back_match_code'] = 'yes';
          Session::flash('message', 'Password changed Successfully!');
          Session::flash('alert-class', 'alert-success');
          return Redirect::to(action('web\LoginController@index'));
        } else {
          Session::flash('message', 'Password and Confirm Password not match!');
          Session::flash('alert-class', 'alert-danger');
          return Redirect::back();
        }
      } else {
        Session::flash('message', 'Please enter Password and Confirm Password!');
        Session::flash('alert-class', 'alert-danger');
        return Redirect::back();
      }
    } else {
      return View::make('web.signup.change_password');
    }
  }

   public function verify_otp(){
    //Get Val
    $formData       = Input::all();

    if(!empty($formData)){

        $otp=$formData['codeBox1'];
        $rand=$_SESSION['otp'];

        if($rand==$otp){

          if (isset($_SESSION['id'])) {
            $user_from_temp = DB::table('register_user_temps')->where('id',$_SESSION['id'])->first();
            if (!empty($user_from_temp)) {
              // $last_user = RegisterUser::orderBY('id','DESC')->first();
              // if(empty($last_user)){
              //   $user_from_temp->id = 1;
              // }
              // else{
              //   $user_from_temp->id = $last_user->id + 1;
              // }
              $user_from_temp->id = '';

              $user_from_temp_array = (array) $user_from_temp;

              $main_user_id = DB::table('registerusers')->insertGetId($user_from_temp_array);

              $_SESSION['id'] = $main_user_id;

              $user = RegisterUser::where('id',$main_user_id)->first();

              $bal = array([

                'user_id' => $main_user_id,

                'refer_id' => $user->refer_id,

                'balance' => INITIAL_BALANCE_ZERO,

                'winning' => INITIAL_BALANCE_ZERO,

                'bonus' =>  INITIAL_BALANCE_ZERO//SIGN_UP_BONUS_AMOUNT

              ]);

              DB::table('userbalances')->insert($bal);

              // $finduser = RegisterUser::where('id',$user->refer_id)->first();
              // if (!empty($finduser)) {
              //     //echo $finduser->id;
              //     $referal_users_balance = UserBalance::where('user_id',$user->refer_id)->first();
              //     //echo "<pre>";print_r($referal_users_balance);die();
              //     /*$scratch = [];
              //     $scratch['refercode'] = $finduser->refercode;
              //     $scratch['user_id'] = $user->id;
              //     $scratch['active'] = 1;
              //     $scratch['refer_id'] = $finduser->id;
              //     $scratch['is_scratched'] = 0;
              //     DB::table('scratch_cards')->insert($scratch);*/

              //     $total = $referal_users_balance->balance+$referal_users_balance->winning+$referal_users_balance->bonus + REFERAL_BONUS_AMOUNT;

              //     $transaction['userid'] = $referal_users_balance->user_id;
              //     $transaction['refer_id'] = DEFAULT_USER_ID;
              //     $transaction['type'] = REFERAL_BONUS_STMT;
              //     $transaction['transaction_id'] = '11CAPS-SIGNUP-REFERAL-'.time().$referal_users_balance->user_id;
              //     $transaction['transaction_by'] = '11caps';
              //     $transaction['sport'] = SPORT_CRICKET_KEY;
              //     $transaction['amount'] = REFERAL_BONUS_AMOUNT;
              //     $transaction['paymentstatus'] = CONFIRMED;
              //     $transaction['bonus_amt'] = REFERAL_BONUS_AMOUNT;
              //     $transaction['bal_bonus_amt'] = $referal_users_balance->bonus + REFERAL_BONUS_AMOUNT;
              //     $transaction['bal_win_amt'] = $referal_users_balance->winning;
              //     $transaction['bal_fund_amt'] = $referal_users_balance->balance ;
              //     $transaction['total_available_amt'] = $total;
              //     DB::table('transactions')->insert($transaction);

              //     $ref_user_bal['balance'] =  $total;
              //     $ref_user_bal['winning'] =  $referal_users_balance->winning;
              //     $ref_user_bal['bonus'] =  $referal_users_balance->bonus;

              //     UserBalance::where('user_id',$finduser->id)->update($ref_user_bal);

              // }

              // $transaction = new Transaction();
              // $transaction_new_user['userid'] = $main_user_id;
              // $transaction_new_user['refer_id'] = DEFAULT_USER_ID;
              // $transaction_new_user['type'] = SIGN_UP_BONUS_STMT;
              // $transaction_new_user['transaction_id'] = '11CAPS-SIGNUP-'.time().$main_user_id;
              // $transaction_new_user['transaction_by'] = '11caps';
              // $transaction_new_user['sport'] = SPORT_CRICKET_KEY;
              // $transaction_new_user['amount'] = SIGN_UP_BONUS_AMOUNT;
              // $transaction_new_user['paymentstatus'] = CONFIRMED;
              // $transaction_new_user['bonus_amt'] = SIGN_UP_BONUS_AMOUNT;
              // $transaction_new_user['bal_fund_amt'] = INITIAL_BALANCE_ZERO;
              // $transaction_new_user['bal_win_amt'] = INITIAL_BALANCE_ZERO;
              // $transaction_new_user['bal_bonus_amt'] = SIGN_UP_BONUS_AMOUNT;
              // $transaction_new_user['total_available_amt'] = SIGN_UP_BONUS_AMOUNT;
              // DB::table('transactions')->insert($transaction_new_user);

            }
          }

            Session::flash('message', 'Otp Matched!');

            Session::flash('alert-class', 'alert-success');
            return Redirect::to(action('web\WebController@dashboard'));
        }else{
            Session::flash('message', 'Otp Is Not Match!');
            Session::flash('alert-class', 'alert-danger');
            //return Redirect::back();
            return Redirect::to(action('web\SignupController@verify_otp'));
        }
        //}
      //First Time Page Lode
    }else{
       return View::make('web.signup.signup2');
    }
  }//End Function

  //Resend Otp
  public function resend_otp(){
     $rand= rand(100000, 999999);
     $_SESSION['otp'] =$rand;
     $message = "Please use OTP ".$rand." to verify your mobile number.";

    //Otp limit
    $otp = Otp::where('mobile',$_SESSION['mobile'])->first();
    if (!empty($otp)) {
        if ($otp->count >= OTP_MAX_LIMIT) {
            unset($_SESSION['id']);
            Session::flash('message', 'You have reached maximum limit to send otp on your mobile!');
            Session::flash('alert-class', 'alert-danger');
            return redirect()->back(); die;
        } else {
            $otp_count = $otp->count;
            $otp_update['count'] = $otp_count + 1;
            DB::table('otp')->where('mobile',$_SESSION['mobile'])->update($otp_update);
        }
    } else {
        $otp_new['mobile'] = $_SESSION['mobile'];
        $otp_new['count'] = 0;
        DB::table('otp')->insert($otp_new);
    }
    //end OTP

     Helpers::sendTextSmsNew($message,$_SESSION['mobile']);
     Session::flash('message', 'OTP Sent!');
     Session::flash('alert-class', 'alert-success');
    return Redirect::to(action('web\SignupController@verify_otp'));
  }//End Function

  //Insert Detail
    //Insert Detail
  public function signup3(){
    // dd('dsfsfda');
    unset($_SESSION['id']);
    $formData       = Input::all();
    // dd($formData);
    if(!empty($formData)){

        $message  = array(
          'email.required'              => 'Please enter email address.',
          'email.email'                 => 'Please enter a valid email address.',
          'email.unique'                => 'This email address is already registered with us, try another.',
          'mobile.required'             => 'Please enter mobile number.',
          'mobile.unique'               => 'This mobile number is already registered with us, try another.',
          'dob.required'                => 'Please select date of birth below 18 years of age.',
          'password.required'           => 'Please enter password.',
          'confirm_password.required'   => 'Please enter confirm password.',
          'confirm_password.same'       => 'Confirm password and password should be same.',
        );
        $validate = array(
            'email'                => 'required|email|unique:registerusers,email,NULL,id',
            'dob'                  => 'required',
            'mobile'                  => 'required|unique:registerusers|min:10|max:10',
            'password'             => 'required|min:6|max:16',
            'confirm_password'     => 'required|same:password',
        );

        $validator = Validator::make(Input::all(),$validate,$message);
        if ($validator->fails()){
            return Redirect::back()->withErrors($validator)->withInput();
            //Validation Comp.
        }else{
          if (!empty($formData['term_condition'])) {
          $GetUser_email = RegisterUser::where('email', '=', $formData['email'])->first();
          $GetUser_mobile = RegisterUser::where('mobile', '=', $formData['mobile'])->first();

          if (!empty($GetUser_email)) {
             Session::flash('message', 'Email Address Already Exist!');
              Session::flash('alert-class', 'alert-danger');

              return Redirect::to(action('web\SignupController@signup3'));
          }

          if(empty($GetUser_mobile)){

              //Insert Data
              $user_data_array=array(
                 'mobile'=>$formData['mobile'],
                  'mobile_verify' => 1,
                 'email' =>$formData['email'],
                 'password' =>Hash::make($formData['password']),
                 'dob' =>$formData['dob'],
                 'email' =>$formData['email'],
              );

              //Check Refer id
              if(isset($formData['referralcode'])){
                  if($formData['referralcode']!=""){
                    $finsuers = RegisterUser::where('refercode',$formData['referralcode'])->first();
                    if(!empty($finsuers)){

                      $user_data_array['refer_id']=$finsuers->id;

                    } else {
                      Session::flash('message', 'Refer Code Not Exist!');
                      Session::flash('alert-class', 'alert-danger');
                      return Redirect::to(action('web\SignupController@signup3'));
                    }
                  }
              }
              $rand=rand(100000, 999999);
              $user_data_array['refercode'] = strtoupper(str_replace('@', '',str_replace('.', '', substr($formData['email'],0,5)))).$rand;

               $id = DB::table('register_user_temps')->insertGetId($user_data_array);
               $_SESSION['id'] = $id;
               $_SESSION['mobile'] = $formData['mobile'];
               //$rand = rand(100000,999999);
               $_SESSION['otp'] =$rand;
               $message = "Please use OTP ".$rand." to verify your mobile number.";

                //check otp limit
                $otp = Otp::where('mobile',$_SESSION['mobile'])->first();
                if (!empty($otp)) {
                    if ($otp->count >= OTP_MAX_LIMIT) {
                        unset($_SESSION['id']);
                        Session::flash('message', 'You have reached maximum limit to send otp on your mobile!');
                        Session::flash('alert-class', 'alert-danger');
                        return redirect()->back(); die;
                    } else {
                        $otp_count = $otp->count;
                        $otp_update['count'] = $otp_count + 1;
                        DB::table('otp')->where('mobile',$_SESSION['mobile'])->update($otp_update);
                    }
                } else {
                    $otp_new['mobile'] = $_SESSION['mobile'];
                    $otp_new['count'] = 0;
                    DB::table('otp')->insert($otp_new);
                }
                //end


               Helpers::sendTextSmsNew($message,$_SESSION['mobile']);
               return View::make('web.signup.signup2');

              Session::flash('message', 'User Signup Successfully!');
              Session::flash('alert-class', 'alert-success');
              return Redirect::to(action('web\LoginController@index'));

          }else{
              Session::flash('message', 'Mobile Number Already Exist!');
              Session::flash('alert-class', 'alert-danger');
              //return Redirect::back();
              return Redirect::to(action('web\SignupController@signup3'));
          }
          //
          }else{
            Session::flash('message', 'Please agree Terms & Conditions');
            Session::flash('alert-class', 'alert-danger');
            //return Redirect::back();
            return Redirect::to(action('web\SignupController@signup3'));
          }
        }
    //First Time Page Show
    }else{
      return View::make('web.signup.signup3');
    }
  }//End Function


  //Google
   public function google() {
    $data['success'] = '';
    $data['error'] = '';
    $data['warning'] = '';
    $data['login_data_front'] = @$_SESSION['id'];

    if(isset($data['login_data_front']) && !empty($data['login_data_front']))
    {

    } else{

    }

   $_SESSION['previous'] = 'login';
      $client = new Google_Client();

      $client->setScopes(array('https://www.googleapis.com/auth/plus.login','https://www.googleapis.com/auth/userinfo.email', 'https://www.googleapis.com/auth/plus.me'));

      $client->setApprovalPrompt('auto');

     if(isset($_GET['type']) && $_GET['type'] == 'google')
      {
        $authUrl = $client->createAuthUrl();
        header('Location: ' . $authUrl);
        exit;
      }


      $plus = new Google_PlusService($client);
      $oauth2 = new Google_Oauth2Service($client);

      if(isset($_GET['code']))
      {
        $client->authenticate(); // Authenticate
        $_SESSION['access_token'] = $client->getAccessToken(); // get the access token here
        // header('Location: http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF']);
      }

      if(isset($_SESSION['access_token']))
      {
        $client->setAccessToken($_SESSION['access_token']);
      }

    if($client->getAccessToken())
    {
      $_SESSION['access_token'] = $client->getAccessToken();
      $user_profile = $oauth2->userinfo->get();

         // print_r($user_profile); die();
      $social_login_type = 'google';
      $user_info = RegisterUser::where('email', $user_profile['email'])->orWhere('google_id', $user_profile['id'])->first();


       if(!empty($user_info))
            {
              $_SESSION['id'] =$user_info->id;
                $_SESSION['email'] =$user_info->email;
                Session::put('email', $user_info->email);
                Session::put('id', $user_info->id);
                // $_SESSION['email'] =$user_info->email;
                //Show Page
                return Redirect::to(action('web\WebController@dashboard'));
            } else {


              $newdata = array(
                    'email'  => $user_profile['email'],
                    'google_id'  => $user_profile['id'],
                    'image'  => $user_profile['picture'],
                    'provider'  => "google",
                    'username'  => $user_profile['name'],
                  );
              $rand=rand(100000, 999999);
              $newdata['refercode'] = strtoupper(str_replace('@', '',str_replace('.', '', substr($user_profile['email'],0,5)))).$rand;

                  $user_id = DB::table('registerusers')->insertGetId($newdata);
              $rand=rand(100000, 999999);
               $data1['refercode'] = '11CAPS-'.$rand.$user_id;
               DB::table('registerusers')->where('id',$user_id)->update($data1);
                  $balance['balance'] = 0;
                  $balance['user_id'] = $user_id;
                  DB::table('userbalances')->insertGetId($balance);
                $_SESSION['id'] =$user_id;
                $_SESSION['email'] =$user_profile['email'];
                return Redirect::to(action('web\WebController@dashboard'));
            }
        }
    } // end google()

    /*
  * facebook login
  */
    public function fb_login() {

      $data['success'] = '';
      $data['error'] = '';
      $data['warning'] = '';
     // $this->load->model("register_model");
      // $data['login_data_front'] = $this->session->all_userdata();
      if(isset($data['login_data_front']['user_id']) && $data['login_data_front']['user_id'] != '')
      {
        // $base_url = base_url();
        // header("Location: ".$base_url."myaccount");
      }
      $fb_data = $_GET['data'];
      ob_start();
      require_once 'vendor/facebook/graph-sdk/src/Facebook/autoload.php';
      $facebook = new \Facebook\Facebook(array(
        'app_id'  => FB_APPID,
        'app_secret' => FB_SECRET,
      ));
      // $users_data = $facebook->getUser();
      if (1) {
        try {
           $response = $facebook->get('/me?fields=email,name', $fb_data['accessToken']);
          $me = $response->getGraphUser();

        // $user_profile = $facebook->api('/'.$users_data.'?fields=id,name,first_name,last_name,email');

           $social_login_type = 'facebook';
           $user_info = RegisterUser::where('email', $me->getEmail())->orWhere('facebook_id', $me->getId())->first();

            if(!empty($user_info))
            {
              $_SESSION['id'] =$user_info->id;
                $_SESSION['email'] =$user_info->email;
                Session::put('email', $user_info->email);
                Session::put('id', $user_info->id);
                echo 1; exit;
                //Show Page
                return Redirect::to(action('web\WebController@dashboard'));
            } else {
                $newdata = array(
                     'email'  => $me->getEmail(),
                    'facebook_id'  => $me->getId(),
                    // 'image'  => $user_profile['picture'],
                    'provider'  => "facebook",
                    'username'  => $me->getName(),
                  );
               // print_r($me); die();
                $rand=rand(100000, 999999);
                if(isset($newdata['email']) && strlen($newdata['email']) > 5){
                  $newdata['refercode'] = strtoupper(str_replace('@', '',str_replace('.', '', substr($newdata['email'],0,5)))).$rand;
                }
                else {
                  $newdata['refercode'] = strtoupper(str_replace('@', '',str_replace('.', '', substr($newdata['facebook_id'],0,5)))).$rand;
                }

                  $user_id = DB::table('registerusers')->insertGetId($newdata);
                  /*$data1['refercode'] = '11CAPS-'.$rand.$user_id;
                  DB::table('registerusers')->where('id',$user_id)->update($data1);*/
                  $balance['balance'] = 0;
                  $balance['user_id'] = $user_id;
                  DB::table('userbalances')->insertGetId($balance);
                $_SESSION['id'] =$user_id;
                 $_SESSION['email'] ="";
                 Session::put('email', $user_info->email);
                Session::put('id', $user_info->id);
                echo 1; exit;
                return Redirect::to(action('web\WebController@dashboard'));
            }
      }
      catch(FacebookApiException $e)
      {
        $users_data = null;
      }
    }
  }

  public function backSignup(){
    if (isset($_SESSION['id'])) {
        unset($_SESSION['id']);
    }
    return Redirect::to(action('web\SignupController@signup3'));
  }

}
?>
