<?php
  namespace App\Http\Controllers\web;
  use DB;
  use Session;
  use bcrypt;
  use Config;
  use Redirect;
  use Helpers;
  use File;
  use Hash;
  use App\Helpers\CommonHelper;
  use Carbon\Carbon;
  use Illuminate\Http\Request;
  use App\Http\Controllers\Controller;
  use App\Http\Controllers\CricketapiController;
  use App\Http\Requests;
  use Illuminate\Support\Facades\Validator;
  use Illuminate\Support\Facades\Input;
  use Cache;
  use App\RegisterUser;
  use App\ListMatch;
  use App\JoinTeam;
  use App\MatchPlayer;
  use App\Player;
  use App\MatchPlaying11;
  use App\ResultMatch;
  use App\JoinedLeague;

class TeamController extends Controller {
   //Set Url
   public function geturl(){
    //return 'https://fantasypower11.com/fantasypoweradmin/';
    return BASE_URL;
  }
  //Team Controller
  //Show Create Team Page
  public function index($matchkey=null,$sport_key = null){


    //Get Url
    $geturl = $this->geturl();
    $findmatch='';
    $userid = $_SESSION['id'];
    $sport_key="CRICKET";
    //Get User Team Name Show in My Team Page
     $userteamanme = RegisterUser::where('id',$userid)->select('team')->first();
      $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
     // print_r($sport_type);  die();
      $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    //Get Data
      Cache::forget('matchdetails_of_'.$matchkey);
      if(Cache::has('matchdetails_of_'.$matchkey)){
        $findmatch = Cache::get('matchdetails_of_'.$matchkey);
      }else{
        $teamplayer_list = Cache::remember('matchdetails_of_'.$matchkey,10, function() use ($matchkey, $geturl){
        $query_data =   ListMatch::where('listmatches.matchkey',$matchkey)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->join('matchplayers','matchplayers.matchkey','=','listmatches.matchkey')->join('players','matchplayers.playerid','=','players.id')->join('playerdetails','players.player_key','=','playerdetails.player_key')
          ->leftJoin("seriesplayers",function($join){
                    $join->on("seriesplayers.series","=","listmatches.series")
                      ->on("matchplayers.playerid","=","seriesplayers.player");
                })->select(DB::raw('CONCAT("'.PLAYERS_DIRECTORY_URL.'", playerdetails.image) as image, "false" as isSelected, CASE WHEN listmatches.team1=players.team THEN "team1" ELSE "team2" END as team, CASE WHEN listmatches.team1=players.team THEN t1.short_name ELSE t2.short_name END as teamname, CASE WHEN listmatches.team1=players.team THEN t1.color ELSE t2.color END as teamcolor, CASE WHEN seriesplayers.totalpoints IS NULL OR seriesplayers.totalpoints = "" THEN 0 ELSE seriesplayers.totalpoints END AS totalpoints'),'matchplayers.role as role','matchplayers.credit as credit','matchplayers.role','players.player_name as name','players.id as id','players.player_key as playerkey','listmatches.team1display as team1_code','listmatches.team2display as team2_code','listmatches.team1 as team1','playerdetails.image as pimage','listmatches.team2 as team2','listmatches.start_date','matchplayers.selected_percent as selected_by')->orderBy('matchplayers.credit','DESC')->groupBy('players.id')->get();
          return $query_data;
              });

      }




      $return_data = array();
      foreach ($teamplayer_list as $key => $value) {
         if(!($this->checkRemoteFile($value->image))){
            $value->image = DEFAULT_PLAYERS_IMAGE;
         }

         $players[$value->role][] =  $value;
      }

      $match_detail = ListMatch::where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->join('teams as t1', 'listmatches.team1','=','t1.id')->join('teams as t2', 'listmatches.team2','=','t2.id')->select('listmatches.*','t1.logo as team1_icon','t2.logo as team2_icon')->first();

      $playing11 = array();
      date_default_timezone_set('Asia/Kolkata');
      $getcurrentdate = date('Y-m-d H:i:s');

      $tosstime = date('Y-m-d H:i:s', strtotime('-30 minutes', strtotime($match_detail['start_date'])));
      if($getcurrentdate>$tosstime){

        $find_playing_11 = MatchPlaying11::where('match_key', $matchkey)->first();

        if(empty($find_playing_11)) {
          // $playing11 = $this->get_playing_11($matchkey);
        } else {
          $playing11 = unserialize($find_playing_11->player_ids);
        }
      }

      foreach ($teamplayer_list as $key => $value) {
          $teamplayer_list[$key]->is_playing = in_array($value->id,$playing11) ? 1 : 0;
          if(!empty($playing11)) {
            $teamplayer_list[$key]->is_playing_show = 1;
          } else {
            $teamplayer_list[$key]->is_playing_show = 0;
            $teamplayer_list[$key]->is_playing = -1;
          }

      }

    $playerLimit = CommonHelper::$playerLimit[$sport_type];
       $playerLimit = array_values($playerLimit);



      $total_teams = JoinTeam::where('matchkey', $matchkey)->where('sport_type',$sportType->id)->select(DB::raw("COUNT(id) as total_count"))->get();

      foreach ($teamplayer_list as $key => $value) {

         $total_choose = JoinTeam::whereRaw('FIND_IN_SET('.$teamplayer_list[$key]->id.',players)')->where('matchkey', $matchkey)->where('sport_type',$sportType->id)->select(DB::raw("COUNT(id) as total_count"))->get();

            // $teamplayer_list[$key]->selected_by = number_format((($total_choose[0]->total_count * 100) / $total_teams[0]->total_count),2);
      }

      $series = DB::table('listmatches')->where('matchkey',$matchkey)->select('series')->first();
      $findallmatches = DB::table('listmatches')->where('series',$series->series)->select('listmatches.matchkey')->get();


      if(!empty($findallmatches)){

        foreach($findallmatches as $matches){

          $allmatchkey[] = $matches->matchkey;

        }

      }

      foreach ($teamplayer_list as $key => $value) {
          $totalpoints = DB::table('matchplayers')
          ->whereIn('matchkey',$allmatchkey)
          ->where('playerid',$teamplayer_list[$key]->id)
          ->select(DB::raw("SUM(points) as totalpoints"))->get();

        $teamplayer_list[$key]->totalpoints = (float) $totalpoints[0]->totalpoints;

        if ($teamplayer_list[$key]->totalpoints == "") {
          $teamplayer_list[$key]->totalpoints = 0;
        }

      }

       $findjointeam = JoinTeam::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->where('userid',$userid)->count();
 // print_r($findjointeam);  die();


      if($this->checkRemoteFile(TEAMS_DIRECTORY_URL.$match_detail->team1_icon))
          $match_detail->team1_icon = TEAMS_DIRECTORY_URL.$match_detail->team1_icon;
      else
          $match_detail->team1_icon = TEAMS_DIRECTORY_URL.'dummy-team.png';

      if($this->checkRemoteFile(TEAMS_DIRECTORY_URL.$match_detail->team2_icon))
          $match_detail->team2_icon = TEAMS_DIRECTORY_URL.$match_detail->team2_icon;
      else
          $match_detail->team2_icon = TEAMS_DIRECTORY_URL.'dummy-team.png';
// print_r($findjointeam); exit;

      return view('web.team.create_team',compact('players','matchkey','match_detail','userteamanme','findjointeam','sport_key','playerLimit'));
  }//End
 public static function get_playing_11($matchkey) {

      $giveresresult = CricketapiController::getmatchdetails($matchkey);
      if(!empty($giveresresult)){
        $mainarrayget = $giveresresult['data']['card'];
        $findteams = $mainarrayget['teams']; //print_r($findteams); exit;
        if(!empty($findteams)){
          $finalplayingteams = array();
          $players = array();
          foreach($findteams as $keytp => $tp){
            if(isset($tp['match']['playing_xi'])){
              $findpl = $tp['match']['playing_xi'];
              if(!empty($findpl)){
                foreach($findpl as $fl){
                  $finalplayingteams[] = $fl;
                  $player_details = DB::table('players')->join('matchplayers','players.id','=','matchplayers.playerid')->where('players.player_key',$fl)->where('matchplayers.matchkey', $matchkey)->select('players.id')->first();
                  if(!empty($player_details)) {
                    $players[] = $player_details->id;

                  }
                }
              }
            }


          }
          // print_r($players); exit;
          if(count($players) > 11) {
          $insert_data = array(
            "match_key" => $matchkey,
            "player_ids" => serialize($players),
          );
          DB::table('match_playing11')->insert($insert_data);
          return $players;
          } else {
            return array();
          }


        }
        return array();
      }
      return array();
  }
 public function players_points($matchkey=null,$sport_key = null){
     $url = $this->geturl();
    //Match Id
    $matchkey = $matchkey;
     $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    //User Id
    $userid = $_SESSION['id'];
    $point_sport_types = array(
         "CRICKET" =>  'player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,
               sum(startingpoints) as startingpoints,
               sum(result_points.runs) as runs,
               sum(result_points.fours) as fours,
               sum(result_points.sixs) as sixs,
               sum(result_points.strike_rate) as strike_rate,
             sum(halcentury) as halcentury,
               sum(century) as century,
               sum(result_points.duck) as duck,
               sum(wickets)as wickets,
               sum(result_points.economy_rate) as economy_rate,
               sum(maidens) as maidens,
               sum(result_points.runouts) as runouts,
               sum(result_points.catch) as catch_points,
               sum(stumping) as stumping,
               sum(total) as total,
               sum(total) as total_points,
               sum(total) as actual_total_points,
               sum(total) as points,
               sum(not_out) as not_out,
               sum(result_points.negative) as negative,
               sum(result_points.runout_thrower) as runout_thrower,
               sum(result_points.runout_catcher) as runout_catcher,
               sum(stumbed) as actual_stumping,
               sum(result_matches.runs) as actual_runs,
               sum(result_matches.fours) as actual_fours,
               sum(result_matches.starting11) as actual_startingpoints,
               sum(result_matches.six) as actual_sixs,
               sum(result_matches.strike_rate) as actual_strike_rate,
               sum(result_matches.wicket) as actual_wicket,
               sum(result_matches.maiden_over) as actual_maidens,
               sum(result_matches.economy_rate) as actual_economy_rate,
               sum(result_matches.duck) as actual_duck,
               sum(result_matches.runouts) as actual_runouts,
               sum(result_matches.negative_points) as negative_points_actual,
               sum(result_matches.catch) as actual_catch,
               sum(result_matches.notout) as actual_notout,
               sum(result_matches.runout_thrower) as actual_runout_thrower,
               sum(result_matches.runout_catcher) as actual_runout_catcher'
               ,
         "FOOTBALL" => "player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,

            sum(result_points.minutesplayed) as minutesplayed,
            sum(result_matches.minutesplayed) as actual_minutesplayed,

            sum(result_points.goals) as goals,
            sum(result_matches.goals) as actual_goals,
            sum(result_points.assist) as assist,
            sum(result_matches.assist) as actual_assist,
            sum(result_points.totalpass) as totalpass,
            sum(result_matches.totalpass) as actual_totalpass,
            sum(result_points.shotsontarget) as shotsontarget,
            sum(result_matches.shotsontarget) as actual_shotsontarget,
            sum(result_points.cleansheet) as cleansheet,
            sum(result_matches.cleansheet) as actual_cleansheet,
            sum(result_points.shotsblocked) as shotsblocked,
            sum(result_matches.shotsblocked) as actual_shotsblocked,
            sum(result_points.penaltysave) as penaltysave,
            sum(result_matches.penaltywon) as actual_penaltysave,
            sum(result_points.tacklesuccess) as tacklesuccess,
            sum(result_matches.tacklesuccess) as actual_tacklesuccess,
            sum(result_points.yellowcard) as yellowcard,
            sum(result_matches.yellowcard) as actual_yellowcard,
            sum(result_points.redcard) as redcard,
            sum(result_matches.redcard) as actual_redcard,
            sum(result_points.owngoals) as owngoals,
            sum(result_matches.owngoals) as actual_owngoals,
            sum(result_points.penaltymiss) as penaltymiss,
            sum(result_matches.penaltymiss) as actual_penaltymiss,
            sum(result_points.goalconceded) as goalconceded,
            sum(result_matches.goalconceded) as actual_goalconceded,
            sum(result_points.total) as total_points,
            sum(result_matches.total_points) as actual_total_points,
            sum(result_points.total) as points


            ",
         "BASKETBALL" => "player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,
         sum(result_points.pointscored) as pointscored,
         sum(result_matches.pointscored) as actual_pointscored,
         sum(result_points.rebound) as rebound,
         sum(result_matches.rebound) as actual_rebound,
         sum(result_points.assist) as assist,
         sum(result_matches.assist) as actual_assist,
         sum(result_points.steal) as steal,
         sum(result_matches.steal) as actual_steal,
         sum(result_points.block) as block,
         sum(result_matches.block) as actual_block,
         sum(result_points.turnover) as turnover,
         sum(total) as total,
         sum(total) as total_points,
         sum(total) as actual_total_points,
         sum(total) as points,
         sum(result_matches.turnover) as actual_turnover",

    );

       $sport_type_array = array(

         "CRICKET" =>  [
      //      'player_name',
            // 'player_key',
            // 'player_id',
            // 'team',
             'credit',
               'startingpoints',
               'runs',
               'fours',
               'sixs',
               'strike_rate',
             'halcentury',
               'century',
               'duck',
               'wickets',
               'maidens',
               'not_out',
               'stumping',
               'total',
               'total_points',
               'actual_total_points',
               'economy_rate',
               'runouts',
               'negative',
               'runout_thrower',
               'runout_catcher',
               'catch_points',
               'actual_stumping',
               'actual_runs',
               'actual_fours',
               'actual_startingpoints',
               'actual_sixs',
               'actual_strike_rate',
               'actual_wicket',
               'actual_maidens',
               'actual_economy_rate',
               'actual_duck',
               'actual_runouts',
               'negative_points_actual',
               'actual_catch',
               'actual_notout',
               'actual_runout_thrower',
               'actual_runout_catcher']
               ,
         "FOOTBALL" => [
          'credit',
          'minutesplayed',
'actual_minutesplayed',
'goals',
'actual_goals',
'assist',
'actual_assist',
'totalpass',
'actual_totalpass',
'cleansheet',
'actual_cleansheet',
'shotsblocked',
'actual_shotsblocked',
'penaltysave',
'actual_penaltysave',
'tacklesuccess',
'actual_tacklesuccess',
'yellowcard',
'actual_yellowcard',
'redcard',
'actual_redcard',
'owngoals',
'actual_owngoals',
'penaltymiss',
'actual_penaltymiss',
'goalconceded',
'actual_goalconceded',
'total_points',
'actual_total_points'


                ],
         "BASKETBALL" => [
                 'pointscored','actual_pointscored','rebound','actual_rebound',
                 'assist',
                 'actual_assist',
                 'steal',
                 'actual_steal',
                 'block',
                 'actual_block',
                 'turnover',
                 'actual_turnover'
                ]

       );
        $points_colums = $point_sport_types[$sport_type];

        $players = DB::table('result_points')->join('result_matches','result_matches.id','=','result_points.resultmatch_id')->join('players','players.id','=','result_points.playerid')->join('playerdetails','playerdetails.player_key','=','players.player_key')->leftjoin('teams','players.team','=','teams.id')->where('starting11','!=',0)->where('result_matches.sport_type',$sportType->id)->where('matchkey',$matchkey)->select( DB::raw(
        $points_colums)
      )->orderBy('total','desc')->groupBy('players.player_key')->get();

        $array_diff = array();
        $result = $players;
    foreach ($players as $key => $value) {
           $player_id = $value->player_id;

         $total_choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('sport_type', $sportType->id)->where('matchkey', $matchkey)->count();//->select(DB::raw("COUNT(id) as total_count"))->get();



          $total_selected = $total_choose;
          $totalTeams =  JoinTeam::where('matchkey', $matchkey)->count();
          if($totalTeams) {

          $selected_by = (int)number_format((($total_selected * 100) / $totalTeams), 2);

          $selected_by = $selected_by;

          $players[$key]->selected_by = (string) $selected_by;

          } else{

            $players[$key]->selected_by = "0";

          }
        // $players[$key]->selected_by = "6";
        $players[$key]->points = is_null($value->points) ? 0 : $value->points;
          $choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('matchkey', $matchkey)->where('userid', $userid)->get();



          if(empty($choose)) {

            $players[$key]->isSelected = 0;

          } else {

            $players[$key]->isSelected = 1;

          }


        $players[$key]->image = "";
        $players[$key]->isSelected  = 1;

        $array = json_decode(json_encode($players[$key]), true);
      foreach ($array as $k => $v) {
        if (in_array(key($array), $sport_type_array[$sport_type])) {




          $breakup = array(
        "event_name" =>  key($array),
        // "event_name" =>  ucfirst($event_name),
        "actual" => isset($array[$k]) ? $array[$k] : 0,
        "actual_points" => isset($array['actual_'.$k]) ? $array['actual_'.$k] : 0);





          $get_name_to_show = [
            'startingpoints' => 'starting 11',
            'runs' => 'Run',
            'fours' => '4\'s',
             'sixs' => '6\'s',
            'strike_rate' => 'S/R',
            'century' => '100\'s',
            'duck' => 'Duck',
            'wickets' => 'Wkts',
            'economy_rate' => 'E/R',
            'maidens' => 'Maider Over',
            'run_out' => 'Run Out',
            'catch_points' => 'Catch',
            'stumping' => 'Stumping',


                 'pointscored' => 'Scored Points',
                 'rebound' => 'Rebound',
                 'assist' => 'Assist',
                 'steal' => 'Steal',
                 'block' => 'Block',
                 'turnover' => 'Turnover',

                 'minutesplayed' => 'Minutes played',
'goals' => 'Goals',
'assist' => 'Assist',
'totalpass' => 'Total ass',
'cleansheet' => 'Clean sheet',
'shotsblocked' => 'Shots blocked',
'penaltysave' => 'Penalty save',
'tacklesuccess' => 'Tackle success',
'yellowcard' => 'Yellow card',
'redcard' => 'Red card',
'owngoals' => 'Own goals',
'penaltymiss' => 'Penalty miss',
'goalconceded' => 'Goal conceded',
'total_points' => 'Total points',

                  ];

            //conditions

        if (key($array) == 'startingpoints') {
          $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
        }

        if (key($array) == 'not_out') {
          $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
        }

        if (key($array) == 'duck') {
          $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
        }

        if (key($array) == 'wining') {
          $breakup['actual'] = ($breakup['actual_points'] >= 1) ? "Yes" : "No";
        }

        if (key($array) == 'halcentury') {
          $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
        }

         if (key($array) == 'century') {
          $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
        }

         if (key($array) == 'point150') {
          $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
        }
         if (key($array) == 'point200') {
          $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
        }
        if (key($array) == 'total_points') {
          $breakup['actual'] = '0';
          // $breakup['actual_points'] = 0;
        }








        if (key($array) == 'sixs') {
        $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
        $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
        }

        if (array_key_exists(key($array),$get_name_to_show)) {
        $breakup['event_name'] = $get_name_to_show[key($array)];
        array_push($array_diff,$breakup);
          } else {
        unset($breakup);
          }


        // $not_in_events = ['credit'];
        // if (in_array(key($array), $not_in_events)) {
        //  unset($breakup);
        // } else {
      //  array_push($array_diff,$breakup);
        // }


        }

      next($array);
      }
      $result[$key]->breakup_points = $array_diff;
         $breakup = [];
         $array_diff = [];
    }
    $result = $players;
        $total_teams = JoinTeam::where('matchkey', $matchkey)->where('sport_type', $sportType->id)->count();

         $totalTeams = $total_teams;


      if ($players->isEmpty() || $players==null || $players=="") {

        $players =  (object) [];

      }



      // print_r($players); die();

    $match_detail =  ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->first();

      if($this->checkRemoteFile(TEAMS_DIRECTORY_URL.$match_detail->team1logo))
          $match_detail->team1logo = TEAMS_DIRECTORY_URL.$match_detail->team1logo;
      else
          $match_detail->team1logo = TEAMS_DIRECTORY_URL.'dummy-team.png';

      if($this->checkRemoteFile(TEAMS_DIRECTORY_URL.$match_detail->team1logo))
          $match_detail->team2logo = TEAMS_DIRECTORY_URL.$match_detail->team2logo;
      else
          $match_detail->team2logo = TEAMS_DIRECTORY_URL.'dummy-team.png';


    //View Page
    return view('web.team.players_points',compact('match_detail','matchkey','url','players','sport_key'));

  }

 public function points_breakup($matchkey,$player_id,$sport_key){
     $url = $this->geturl();
    //Match Id
    $matchkey = $matchkey;
    //User Id
        $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    //User Id
    $userid = $_SESSION['id'];
    $point_sport_types = array(
         "CRICKET" =>  'player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,
               sum(startingpoints) as startingpoints,
               sum(result_points.runs) as runs,
               sum(result_points.fours) as fours,
               sum(result_points.sixs) as sixs,
               sum(result_points.strike_rate) as strike_rate,
             sum(halcentury) as halcentury,
               sum(century) as century,
               sum(result_points.duck) as duck,
               sum(wickets)as wickets,
               sum(result_points.economy_rate) as economy_rate,
               sum(maidens) as maidens,
               sum(result_points.runouts) as runouts,
               sum(result_points.catch) as catch_points,
               sum(stumping) as stumping,
               sum(total) as total,
               sum(total) as total_points,
               sum(total) as actual_total_points,
               sum(total) as points,
               sum(not_out) as not_out,
               sum(result_points.negative) as negative,
               sum(result_points.runout_thrower) as runout_thrower,
               sum(result_points.runout_catcher) as runout_catcher,
               sum(stumbed) as actual_stumping,
               sum(result_matches.runs) as actual_runs,
               sum(result_matches.fours) as actual_fours,
               sum(result_matches.starting11) as actual_startingpoints,
               sum(result_matches.six) as actual_sixs,
               sum(result_matches.strike_rate) as actual_strike_rate,
               sum(result_matches.wicket) as actual_wicket,
               sum(result_matches.maiden_over) as actual_maidens,
               sum(result_matches.economy_rate) as actual_economy_rate,
               sum(result_matches.duck) as actual_duck,
               sum(result_matches.runouts) as actual_runouts,
               sum(result_matches.negative_points) as negative_points_actual,
               sum(result_matches.catch) as actual_catch,
               sum(result_matches.notout) as actual_notout,
               sum(result_matches.runout_thrower) as actual_runout_thrower,
               sum(result_matches.runout_catcher) as actual_runout_catcher'
               ,
         "FOOTBALL" => "player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,

            sum(result_points.minutesplayed) as minutesplayed,
            sum(result_matches.minutesplayed) as actual_minutesplayed,

            sum(result_points.goals) as goals,
            sum(result_matches.goals) as actual_goals,
            sum(result_points.assist) as assist,
            sum(result_matches.assist) as actual_assist,
            sum(result_points.totalpass) as totalpass,
            sum(result_matches.totalpass) as actual_totalpass,
            sum(result_points.shotsontarget) as shotsontarget,
            sum(result_matches.shotsontarget) as actual_shotsontarget,
            sum(result_points.cleansheet) as cleansheet,
            sum(result_matches.cleansheet) as actual_cleansheet,
            sum(result_points.shotsblocked) as shotsblocked,
            sum(result_matches.shotsblocked) as actual_shotsblocked,
            sum(result_points.penaltysave) as penaltysave,
            sum(result_matches.penaltywon) as actual_penaltysave,
            sum(result_points.tacklesuccess) as tacklesuccess,
            sum(result_matches.tacklesuccess) as actual_tacklesuccess,
            sum(result_points.yellowcard) as yellowcard,
            sum(result_matches.yellowcard) as actual_yellowcard,
            sum(result_points.redcard) as redcard,
            sum(result_matches.redcard) as actual_redcard,
            sum(result_points.owngoals) as owngoals,
            sum(result_matches.owngoals) as actual_owngoals,
            sum(result_points.penaltymiss) as penaltymiss,
            sum(result_matches.penaltymiss) as actual_penaltymiss,
            sum(result_points.goalconceded) as goalconceded,
            sum(result_matches.goalconceded) as actual_goalconceded,
            sum(result_points.total) as total_points,
            sum(result_matches.total_points) as actual_total_points,
            sum(result_points.total) as points


            ",
         "BASKETBALL" => "player_name,
            players.player_key,
            players.credit,
            result_matches.player_id,
            teams.team,
         sum(result_points.pointscored) as pointscored,
         sum(result_matches.pointscored) as actual_pointscored,
         sum(result_points.rebound) as rebound,
         sum(result_matches.rebound) as actual_rebound,
         sum(result_points.assist) as assist,
         sum(result_matches.assist) as actual_assist,
         sum(result_points.steal) as steal,
         sum(result_matches.steal) as actual_steal,
         sum(result_points.block) as block,
         sum(result_matches.block) as actual_block,
         sum(result_points.turnover) as turnover,
         sum(total) as total,
         sum(total) as total_points,
         sum(total) as actual_total_points,
         sum(total) as points,
         sum(result_matches.turnover) as actual_turnover",

    );

       $sport_type_array = array(

         "CRICKET" =>  [
      //      'player_name',
            // 'player_key',
            // 'player_id',
            // 'team',
             'credit',
               'startingpoints',
               'runs',
               'fours',
               'sixs',
               'strike_rate',
             'halcentury',
               'century',
               'duck',
               'wickets',
               'maidens',
               'not_out',
               'stumping',
               'total',
               'total_points',
               'actual_total_points',
               'economy_rate',
               'runouts',
               'negative',
               'runout_thrower',
               'runout_catcher',
               'catch_points',
               'actual_stumping',
               'actual_runs',
               'actual_fours',
               'actual_startingpoints',
               'actual_sixs',
               'actual_strike_rate',
               'actual_wicket',
               'actual_maidens',
               'actual_economy_rate',
               'actual_duck',
               'actual_runouts',
               'negative_points_actual',
               'actual_catch',
               'actual_notout',
               'actual_runout_thrower',
               'actual_runout_catcher']
               ,
         "FOOTBALL" => [
          'credit',
          'minutesplayed',
'actual_minutesplayed',
'goals',
'actual_goals',
'assist',
'actual_assist',
'totalpass',
'actual_totalpass',
'cleansheet',
'actual_cleansheet',
'shotsblocked',
'actual_shotsblocked',
'penaltysave',
'actual_penaltysave',
'tacklesuccess',
'actual_tacklesuccess',
'yellowcard',
'actual_yellowcard',
'redcard',
'actual_redcard',
'owngoals',
'actual_owngoals',
'penaltymiss',
'actual_penaltymiss',
'goalconceded',
'actual_goalconceded',
'total_points',
'actual_total_points'


                ],
         "BASKETBALL" => [
                 'pointscored','actual_pointscored','rebound','actual_rebound',
                 'assist',
                 'actual_assist',
                 'steal',
                 'actual_steal',
                 'block',
                 'actual_block',
                 'turnover',
                 'actual_turnover'
                ]

       );
        $points_colums = $point_sport_types[$sport_type];

        $players = DB::table('result_points')->join('result_matches','result_matches.id','=','result_points.resultmatch_id')->join('players','players.id','=','result_points.playerid')->join('playerdetails','playerdetails.player_key','=','players.player_key')->leftjoin('teams','players.team','=','teams.id')->where('starting11','!=',0)->where('result_matches.sport_type',$sportType->id)->where('matchkey',$matchkey)->select( DB::raw(
        $points_colums)
      )->orderBy('total','desc')->groupBy('players.player_key')->get();

        $array_diff = array();
        $result = $players;
    foreach ($players as $key => $value) {
           $player_id = $value->player_id;

         $total_choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('sport_type', $sportType->id)->where('matchkey', $matchkey)->count();//->select(DB::raw("COUNT(id) as total_count"))->get();



          $total_selected = $total_choose;
          $totalTeams =  JoinTeam::where('matchkey', $matchkey)->count();
          if($totalTeams) {

          $selected_by = (int)number_format((($total_selected * 100) / $totalTeams), 2);

          $selected_by = $selected_by;

          $players[$key]->selected_by = (string) $selected_by;

          } else{

            $players[$key]->selected_by = "0";

          }
        // $players[$key]->selected_by = "6";
        $players[$key]->points = is_null($value->points) ? 0 : $value->points;
          $choose = JoinTeam::whereRaw('FIND_IN_SET('.$player_id.',players)')->where('matchkey', $matchkey)->where('userid', $userid)->get();



          if(empty($choose)) {

            $players[$key]->isSelected = 0;

          } else {

            $players[$key]->isSelected = 1;

          }


        $players[$key]->image = "";
        $players[$key]->isSelected  = 1;

        $array = json_decode(json_encode($players[$key]), true);
      foreach ($array as $k => $v) {
        if (in_array(key($array), $sport_type_array[$sport_type])) {




          $breakup = array(
        "event_name" =>  key($array),
        // "event_name" =>  ucfirst($event_name),
        "actual" => isset($array[$k]) ? $array[$k] : 0,
        "actual_points" => isset($array['actual_'.$k]) ? $array['actual_'.$k] : 0);





          $get_name_to_show = [
            'startingpoints' => 'starting 11',
            'runs' => 'Run',
            'fours' => '4\'s',
             'sixs' => '6\'s',
            'strike_rate' => 'S/R',
            'century' => '100\'s',
            'duck' => 'Duck',
            'wickets' => 'Wkts',
            'economy_rate' => 'E/R',
            'maidens' => 'Maider Over',
            'run_out' => 'Run Out',
            'catch_points' => 'Catch',
            'stumping' => 'Stumping',


                 'pointscored' => 'Scored Points',
                 'rebound' => 'Rebound',
                 'assist' => 'Assist',
                 'steal' => 'Steal',
                 'block' => 'Block',
                 'turnover' => 'Turnover',

                 'minutesplayed' => 'Minutes played',
'goals' => 'Goals',
'assist' => 'Assist',
'totalpass' => 'Total ass',
'cleansheet' => 'Clean sheet',
'shotsblocked' => 'Shots blocked',
'penaltysave' => 'Penalty save',
'tacklesuccess' => 'Tackle success',
'yellowcard' => 'Yellow card',
'redcard' => 'Red card',
'owngoals' => 'Own goals',
'penaltymiss' => 'Penalty miss',
'goalconceded' => 'Goal conceded',
'total_points' => 'Total points',

                  ];

            //conditions

        if (key($array) == 'startingpoints') {
          $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
        }

        if (key($array) == 'not_out') {
          $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
        }

        if (key($array) == 'duck') {
          $breakup['actual'] = ($breakup['actual_points'] == 1) ? "Yes" : "No";
        }

        if (key($array) == 'wining') {
          $breakup['actual'] = ($breakup['actual_points'] >= 1) ? "Yes" : "No";
        }

        if (key($array) == 'halcentury') {
          $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
        }

         if (key($array) == 'century') {
          $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
        }

         if (key($array) == 'point150') {
          $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
        }
         if (key($array) == 'point200') {
          $breakup['actual'] = ($breakup['actual_points'] > 0) ? 1 : 0;
        }
        if (key($array) == 'total_points') {
          $breakup['actual'] = '0';
          // $breakup['actual_points'] = 0;
        }








        if (key($array) == 'sixs') {
        $breakup['actual'] = isset($array['actual_'.$k]) ? $array['actual_'.$k] : '';
        $breakup['actual_points'] = isset($array[$k]) ? $array[$k] : '';
        }

        if (array_key_exists(key($array),$get_name_to_show)) {
        $breakup['event_name'] = $get_name_to_show[key($array)];
        array_push($array_diff,$breakup);
          } else {
        unset($breakup);
          }


        // $not_in_events = ['credit'];
        // if (in_array(key($array), $not_in_events)) {
        //  unset($breakup);
        // } else {
      //  array_push($array_diff,$breakup);
        // }


        }

      next($array);
      }
      $result[$key]->breakup_points = $array_diff;
         $breakup = [];
         $array_diff = [];
    }
    $result = $players;
        $total_teams = JoinTeam::where('matchkey', $matchkey)->where('sport_type', $sportType->id)->count();

         $totalTeams = $total_teams;


      if ($players->isEmpty() || $players==null || $players=="") {

        $players =  (object) [];

      }

      //



//print_r($players); exit();
    //View Page
    return view('web.team.points_breakup',compact('matchkey','url','players'));
  }
  public function myteam($matchkey=null,$sport_key = "CRICKET"){
    //Url
      $url = $this->geturl();
    //Match Id
    $matchkey = $matchkey;
    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    //User Id
    $userid = $_SESSION['id'];

   //  print_r($sportType);die;
    //$userid = $_SESSION['id'];
    //Get User Team Data Show in My Team Page
     $useramount = DB::table('userbalances')->where('user_id',$userid)->first();
    $findjointeam = JoinTeam::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->where('userid',$userid)->orderBy('teamnumber','ASC')->select('id','teamnumber')->get();

    //print_r($findjointeam);die;
    $team_view_list=array();
    if(!empty($findjointeam)){
      $i=0;
      foreach($findjointeam as $jointeams){
        $team_view_list[$i]['teamnumber'] = $jointeams->teamnumber;
        $team_view_list[$i]['teamid'] = $jointeams->id;
        $jointeam = JoinTeam::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->where('userid',$userid)->where('teamnumber',$jointeams->teamnumber)->select('*')->get();
          if(!empty($jointeam)){
            foreach($jointeam as $team){
              $playersarr = explode(',',$team->players);
              $findmatch = ListMatch::where('matchkey',$team->matchkey)->where('listmatches.sport_type',$team->sport_type)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.team1','listmatches.team2','listmatches.team1display','listmatches.team2display','t1.color as team1color','t2.color as team2color')->first();
               $boplayerdetails = DB::table('matchplayers')->whereIn('matchplayers.playerid',$playersarr)
              ->leftJoin("players",function($join){
                    $join->on("matchplayers.sport_type","=","players.sport_type")
                      ->on("matchplayers.playerid","=",'players.id');})
             // ->join('players','matchplayers.playerid','=','players.id')
              ->leftJoin("playerdetails",function($join){
                    $join->on("players.sport_type","=","playerdetails.sport_type")
                      ->on('players.player_key','=','playerdetails.player_key');})
             // ->join('playerdetails','players.player_key','=','playerdetails.player_key')
              ->select('players.team','playerdetails.image','matchplayers.role as playerrole','matchplayers.credit as playercredit','matchplayers.role','players.player_name as playername','matchplayers.playerid as pid','players.sport_type as sport_type')
              ->where('matchplayers.matchkey',$team->matchkey)->
              get();
            //  print_r( $boplayerdetails);die;

              if(!empty($boplayerdetails)){
                $j=0;
                foreach($boplayerdetails as $bowler){
                  $team_view_list[$i]['player'][$j]['id'] = $bowler->pid;
                  $team_view_list[$i]['player'][$j]['player_name'] = $bowler->playername;
                  $team_view_list[$i]['player'][$j]['role'] = $bowler->playerrole;
                  $team_view_list[$i]['player'][$j]['credit'] = $bowler->playercredit;
                  $team_view_list[$i]['player'][$j]['sport_type'] = $bowler->sport_type;
                  $team_view_list[$i]['player'][$j]['image'] = $bowler->image;
                  //echo PLAYERS_DIRECTORY_URL;exit;
                  if($this->checkRemoteFile($bowler->image)){
                      $team_view_list[$i]['player'][$j]['image'] = PLAYERS_DIRECTORY_URL.$bowler->image;
                  }
                  else{
                    $team_view_list[$i]['player'][$j]['image'] = DEFAULT_PLAYERS_IMAGE;
                  }


                  if($bowler->team==$findmatch->team1){
                    $team_view_list[$i]['player'][$j]['team'] = 'team1';
                    $team_view_list[$i]['player'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team1color));
                  }
                  if($bowler->team==$findmatch->team2){
                    $team_view_list[$i]['player'][$j]['team'] = 'team2';
                    $team_view_list[$i]['player'][$j]['teamcolor'] = ucwords(str_replace(' ','-',$findmatch->team2color));
                  }
                  $vicecaptain=0;
                  $captain=0;
                  if($team->vicecaptain==$bowler->pid){
                    $vicecaptain=1;
                  }
                  if($team->captain==$bowler->pid){
                    $captain=1;
                  }
                  $team_view_list[$i]['player'][$j]['vicecaptain'] = $vicecaptain;
                  $team_view_list[$i]['player'][$j]['captain'] = $captain;
                  $findlastow=array();
                  $findlastow = Player::where('id',$bowler->pid)->select('points')->first();
                  // echo '<pre>';print_r($findlastow);die;
                  $team_view_list[$i]['player'][$j]['points'] = $findlastow->points;
                  $j++;
                }
              }
            }
          }
        $i++;
      }
    }
    //Match Data

    $total_data['total_joined_contest'] = JoinedLeague::where('matchkey', $matchkey)->where('sport_type',$sportType->id)->where('userid', $userid)->count('id');
    $total_data['total_teams'] = JoinTeam::where('matchkey', $matchkey)->where('sport_type',$sportType->id)->where('userid', $userid)->count('id');

   $match_detail =  ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();
    //If Team data Not Empty Show Team List in View Page
    //  echo "<pre>";print_r($team_view_list);die;

    if(!empty($team_view_list)){
     return view('web.team.team_view',compact('team_view_list','matchkey','match_detail','url','total_data','useramount','sport_key'));
    //If Team data Empty Show Create Team View Page
    }else{
      return view('web.team.team',compact('matchkey','match_detail','url','total_data','useramount','sport_key'));
    }
  }//End Function

    //User preview team
  public function preview_team($team_id,$sport_key){
    //Url
    $userid = $_SESSION['id'];
      // print_r($userid); die();
    $geturl = $this->geturl();
    $findmatch='';
    //Get Data To Show User Team Preview
$sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    //  print_r($sport_type);  die();
      $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
      $team_info = JoinTeam::where('id', $team_id)->first();
    //print_r($team_info); die();


      if(!empty($team_info)){
        $user_id = $team_info->userid;
      }else{
         $user_id = 0;
      }

      if($userid != $user_id){

         return Redirect::back();
      }

      $matchkey = $team_info->matchkey;
          //  print_r($user_id); die();
         $match_detail = DB::table('listmatches')->where('matchkey',$matchkey)->first();

         // print_r($match_detail); die();
      Cache::forget('matchdetails_of_'.$matchkey);
      if(Cache::has('matchdetails_of_'.$matchkey)){
        $findmatch = Cache::get('matchdetails_of_'.$matchkey);
      }else{
        /*$teamplayer_list = Cache::remember('matchdetails_of_'.$matchkey,10, function() use ($matchkey, $geturl, $team_id){
        $query_data =   ListMatch::where('listmatches.matchkey',$matchkey)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->join('matchplayers','matchplayers.matchkey','=','listmatches.matchkey')->join('players','matchplayers.playerid','=','players.id')->join('playerdetails','players.player_key','=','playerdetails.player_key')
          ->leftJoin("seriesplayers",function($join){
                    $join->on("seriesplayers.series","=","listmatches.series")
                      ->on("matchplayers.playerid","=","seriesplayers.player");
                })
          ->Join("jointeam",DB::raw("find_in_set(matchplayers.playerid, jointeam.players) AND jointeam.id = ".$team_id."") , DB::raw('1'),DB::raw(''))
          ->select(DB::raw('CONCAT("'.PLAYERS_DIRECTORY_URL.'", playerdetails.image) as image, "false" as isSelected, CASE WHEN listmatches.team1=players.team THEN "team1" ELSE "team2" END as team, CASE WHEN listmatches.team1=players.team THEN t1.short_name ELSE t2.short_name END as teamname, CASE WHEN listmatches.team1=players.team THEN t1.color ELSE t2.color END as teamcolor, CASE WHEN seriesplayers.totalpoints IS NULL OR seriesplayers.totalpoints = "" THEN 0 ELSE seriesplayers.totalpoints END AS totalpoints'),'matchplayers.role as role','matchplayers.credit as credit','matchplayers.role','players.player_name as name','players.id as id','players.player_key as playerkey','listmatches.team1display as team1_code','listmatches.team2display as team2_code','jointeam.players')->orderBy('players.points','DESC')->get();
          return $query_data;
              });*/

        $teamplayer_list = Cache::remember('matchdetails_of_'.$matchkey,10, function() use ($matchkey, $geturl, $team_id){
        $query_data =  ListMatch::where('listmatches.matchkey',$matchkey)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->join('matchplayers','matchplayers.matchkey','=','listmatches.matchkey')
       // ->join('players','matchplayers.playerid','=','players.id')
        //->join('playerdetails','players.player_key','=','playerdetails.player_key')
        ->leftJoin("players",function($join){
                    $join->on("matchplayers.sport_type","=","players.sport_type")
                      ->on('matchplayers.playerid','=','players.id');})
        ->leftJoin("playerdetails",function($join){
                    $join->on("players.sport_type","=","playerdetails.sport_type")
                      ->on('players.player_key','=','playerdetails.player_key');})
          ->leftJoin("seriesplayers",function($join){
                    $join->on("seriesplayers.series","=","listmatches.series")
                      ->on("matchplayers.playerid","=","seriesplayers.player");})

        // ->join("players",function($join){
        //             $join->on("matchplayers.sport_type","=","players.sport_type")
        //               ->on("matchplayers.playerid","=",'players.id');})
        //  ->join("playerdetails",function($join){
        //             $join->on("players.sport_type","=","playerdetails.sport_type")
        //               ->on('players.player_key','=','playerdetails.player_key');})
        //   ->join("matchplayers",function($join){
        //             $join->on("matchplayers.sport_type","=","listmatches.sport_type")
        //               ->on('matchplayers.matchkey','=','listmatches.matchkey');})
          ->Join("jointeam",DB::raw("find_in_set(matchplayers.playerid, jointeam.players) AND jointeam.id = ".$team_id."") , DB::raw('1'),DB::raw(''))



          ->select(DB::raw('CONCAT("'.PLAYERS_DIRECTORY_URL.'", playerdetails.image) as image, "false" as isSelected, CASE WHEN listmatches.team1=players.team THEN "team1" ELSE "team2" END as team, CASE WHEN listmatches.team1=players.team THEN t1.short_name ELSE t2.short_name END as teamname, CASE WHEN listmatches.team1=players.team THEN t1.color ELSE t2.color END as teamcolor, matchplayers.points AS totalpoints'),'matchplayers.role as role','matchplayers.credit as credit','matchplayers.role','players.player_name as name','players.id as id','players.player_key as playerkey','listmatches.team1display as team1_code','listmatches.team2display as team2_code','jointeam.players')->orderBy('players.points','DESC') ->get();
            return $query_data;
              });

      }
      $return_data = array();

     // print_r($return_data); die();

      /*foreach ($teamplayer_list as $key => $value) {
            if(!($this->checkRemoteFile($value->image))){
              $value->image = DEFAULT_PLAYERS_IMAGE;
           }
           $players[$value->role][] =  $value;
      }*/

      foreach ($teamplayer_list as $key => $value) {
          if($this->checkRemoteFile($value->image)){
              $value['image'] = $value->image;
          }
          else{
              $value->image = DEFAULT_PLAYERS_IMAGE;
          }
          if($value->id == $team_info->captain)
              $value->totalpoints = $value->totalpoints * 2;
          if($value->id == $team_info->vicecaptain)
              $value->totalpoints = $value->totalpoints * 1.5;
          if(!isset($value->totalpoints) && $value->totalpoints == '')
              $value->totalpoints = 0;

          $players[$value->role][] =  $value;
      }

     // print_r($players); die();

    //Show View Page
   return view('web.team.preview_team',compact('players','match_detail','matchkey','team_id','team_info','sport_key'));
  }
  //create team
  public function create_team(){
    $getteamid="";
    date_default_timezone_set('Asia/Kolkata');
    $userid = $_SESSION['id'];
    $matchkey = $_POST['match_id'];
    $sport_key = $_POST['sport_key'];
    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    //  print_r($sport_type);  die();
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $players = $_POST['players'];
    $vicecaptain = $_POST['vice_captain'];
    $captain = $_POST['captain_id'];
    $json = array();
    $playersarray = $players;
 //same team
$teamid_exist = JoinTeam::find($getteamid);
 $teamDataa = JoinTeam::where('userid',$userid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->get();
    // $checkPlayer[]  = 1;
    if(!$teamDataa->isEmpty()) {
      $checkPlayer  = [];
    if($teamid_exist)
    {
      // echo 1; exit;
      foreach($teamDataa as $playerKey => $playerTeams)
      {
        $isPlayer = [];
        if(count($teamDataa) > 1)
        {
          if($teamid_exist->id != $playerTeams->id)
          {
            // pr($playerTeams);
            if(!empty($playerTeams->players))
            {
              $players2 = array_filter(explode(',', $playerTeams->players));
              foreach($players2 as $playerDetail)
              {
                if(in_array($playerDetail,$playersarray) and $playerTeams->vicecaptain == $vicecaptain and $playerTeams->captain == $captain)
                {
                  $isPlayer[] = 1;
                }
                else
                {
                  $isPlayer[] = 0;
                }
              }
            }

            if(in_array(0,$isPlayer))

            {
              $checkPlayer[$playerKey]  = 1;
            }
            else
            {
              $checkPlayer[$playerKey]  = 0;
            }
          }
          if(in_array(0,$checkPlayer))
    {

        $Json['message'] = 'Cannot create same team multiple time.';
      $Json['status'] = "error";
      echo json_encode($Json);die;
    }  else {
    }
        }
        else
        {
          $checkPlayer[0] = 1;
        }
      }
    }
    else
    { //echo 1; exit;
      foreach($teamDataa as $playerKey => $playerTeams)
      {
        $isPlayer = [];
        if(!empty($playerTeams->players))
        {
          $players2 = array_filter(explode(',', $playerTeams->players));
          foreach($players2 as $playerDetail)
          {
            if(in_array($playerDetail,$playersarray) and $playerTeams->vicecaptain == $vicecaptain and $playerTeams->captain == $captain)

            {
              $isPlayer[] = 1;
            }
            else
            {
              $isPlayer[] = 0;
            }
          }
        } //print_r($isPlayer); exit;

        // if(in_array(0,$isPlayer))
        if(in_array(0,$isPlayer))
        {
          $checkPlayer[$playerKey]  = 1;
        }
        else
        {
          $checkPlayer[$playerKey]  = 0;
        }
      }
        // print_r($checkPlayer); exit;
    if(in_array(0,$checkPlayer))
    {

       $Json['message'] = 'Cannot create same team multiple time.';
      $Json['status'] = "error";
      echo json_encode($Json);die;
    }  else {
    }
    }

    }

//end same team

    $findallplayerdetails = MatchPlayer::whereIn('playerid',$playersarray)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->select('credit')->get();

    if(!empty($findallplayerdetails)){
      $allc = 0;
      foreach($findallplayerdetails as $pcred){
        $allc+=$pcred->credit;
      }
      if($allc>100){
        $Json['message'] = "Player credits exceed";
        $Json['status'] = "error";
        echo json_encode($Json);die;
      }
    }
    $getcurrentdate = date('Y-m-d H:i:s');
    $findmatchdetails = ListMatch::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->where('start_date','>=',$getcurrentdate)->select('start_date')->first();
    //print_r($findmatchdetails);die;
    if(!empty($findmatchdetails)){
      $matchremainingdate = $findmatchdetails->start_date;
      if($getcurrentdate>=$matchremainingdate){
        $Json['message'] = 'match closed';
        $Json['status'] = "error";
        echo json_encode($Json);die;
      }
    } else {
      $Json['message'] = 'sorry match closed';
      $Json['status'] = "error";
      echo json_encode($Json);die;
    }
      $json['marathonstatus'] = 0;
      $data['userid'] = $userid;
      $data['matchkey'] = $matchkey;
      $data['sport_type'] = $sportType->id;
      $data['players'] = implode(',', $players);
      $data['vicecaptain'] = $vicecaptain;
      $data['captain'] = $captain;
        $findlastteam = JoinTeam::where('userid',$userid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->orderBy('teamnumber','DESC')->select('teamnumber')->first();
        if(!empty($findlastteam)){
          $finnewteamnumber = $findlastteam->teamnumber+1;
          if($finnewteamnumber<6){
            $data['teamnumber'] = $finnewteamnumber;
          }
        }else{
          $data['teamnumber'] = 1;
          $finnewteamnumber = 1;
        }
        //print_r($data['teamnumber']);die;
         if($finnewteamnumber<7){
           $data['teamnumber'] = $finnewteamnumber;
            $getteamid = DB::table('jointeam')->insertGetId($data);

            $json['status'] = "success";
            $json['teamid'] = $getteamid;
           // $json['message'] = "Already teams";
          } else {
            $json['status'] = "error";
            $json['error_code'] = 3;
            $json['message'] = "Already created with 6 teams";
            // $json['teamid'] = $getteamid;
          }

      echo json_encode($json);die;
  // return view('web.team.preview_team');
  }

   //select-captain-vice-captain
  public function selectcvc(){
    $url = $this->geturl();

    $data = json_decode($_POST['team_data']);
   // print_r($data); exit;
     $user_id=$_SESSION['id'];
    $matchkey = $data->match_id;
    $user_id=$_SESSION['id'];
     $sport_key = $data->sport_key;
      $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $players =   ListMatch::where('listmatches.matchkey',$matchkey)->where('listmatches.sport_type', $sportType->id)->join('teams as t1','t1.id','=','listmatches.team1')
      ->join('teams as t2','t2.id','=','listmatches.team2')
       ->join("matchplayers",function($join){
                    $join->on("matchplayers.matchkey","=","listmatches.matchkey")
                      ->on("matchplayers.sport_type","=","listmatches.sport_type");
                })
       ->join("players",function($join){
                    $join->on("matchplayers.playerid","=","players.id")
                      ->on("matchplayers.sport_type","=","players.sport_type");
                })
      ->join('playerdetails','players.player_key','=','playerdetails.player_key')
      ->leftJoin("seriesplayers",function($join){
                $join->on("seriesplayers.series","=","listmatches.series")
                ->on("matchplayers.playerid","=","seriesplayers.player");
            })->whereIn('players.id', $data->players)->select(DB::raw('CONCAT("'.PLAYERS_DIRECTORY_URL.'", playerdetails.image) as image, "false" as isSelected, CASE WHEN listmatches.team1=players.team THEN "team1" ELSE "team2" END as team, CASE WHEN listmatches.team1=players.team THEN t1.short_name ELSE t2.short_name END as teamname, CASE WHEN listmatches.team1=players.team THEN t1.color ELSE t2.color END as teamcolor, CASE WHEN seriesplayers.totalpoints IS NULL OR seriesplayers.totalpoints = "" THEN 0 ELSE seriesplayers.totalpoints END AS totalpoints'),'matchplayers.role as role','matchplayers.credit as credit','matchplayers.role','players.player_name as name','players.id as id','players.player_key as playerkey','listmatches.team1display as team1_code','listmatches.team2display as team2_code','listmatches.start_date','matchplayers.selected_percent as selected_by','matchplayers.selected_captain_percent','matchplayers.selected_vicecaptain_percent')->orderBy('players.points','DESC')->get();
             foreach ($players as $key => $value) {
                    if(!($this->checkRemoteFile($value->image))){
                        $value->image = DEFAULT_PLAYERS_IMAGE;
                     }
                     $players->image =  $value->image;
                  }

 $series = DB::table('listmatches')->where('matchkey',$matchkey)->where('listmatches.sport_type', $sportType->id)->select('series')->first();
      $findallmatches = DB::table('listmatches')->where('series',$series->series)->select('listmatches.matchkey')->get();


      if(!empty($findallmatches)){

        foreach($findallmatches as $matches){

          $allmatchkey[] = $matches->matchkey;

        }

      }
       foreach ($players as $key => $value) {
          $totalpoints = DB::table('matchplayers')
          ->whereIn('matchkey',$allmatchkey)
          ->where('playerid',$players[$key]->id)
          ->select(DB::raw("SUM(points) as totalpoints"))->get();

        $players[$key]->totalpoints = (float) $totalpoints[0]->totalpoints;

        if ($players[$key]->totalpoints == "") {
          $players[$key]->totalpoints = 0;
        }

      }

                 $match_detail =  ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();



                 if($match_detail->team1logo != '' && $this->checkDirectoryFile(TEAMS_DIRECTORY.$match_detail->team1logo))
                  $match_detail->team1logo = TEAMS_DIRECTORY_URL.$match_detail->team1logo;
                else
                  $match_detail->team1logo = DEFAULT_TEAM_IMAGE;

                if($match_detail->team2logo != '' && $this->checkDirectoryFile(TEAMS_DIRECTORY.$match_detail->team2logo))
                  $match_detail->team2logo = TEAMS_DIRECTORY_URL.$match_detail->team2logo;
                else
                  $match_detail->team2logo = DEFAULT_TEAM_IMAGE;
                 $useramount = DB::table('userbalances')->where('user_id',$user_id)->first();
  //echo "<pre>";   print_r($players); exit;
    return view('web.team.selectcvc',compact('players','data','matchkey','match_detail','url','useramount','sport_key'));
  }


  //update-captain-vice-captain

 public function updatecvc(){
      $url = $this->geturl();
    $data = json_decode($_POST['team_data']);
    $matchkey = $data->match_id;
    $user_id=$_SESSION['id'];
     $sport_key = $data->sport_key;
      $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $players =   ListMatch::where('listmatches.matchkey',$matchkey)->where('listmatches.sport_type', $sportType->id)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')
    ->join("matchplayers",function($join){
                    $join->on("matchplayers.matchkey","=","listmatches.matchkey")
                      ->on("matchplayers.sport_type","=","listmatches.sport_type");
                })
       ->join("players",function($join){
                    $join->on("matchplayers.playerid","=","players.id")
                      ->on("matchplayers.sport_type","=","players.sport_type");
                })
    ->join('playerdetails','players.player_key','=','playerdetails.player_key')
      ->leftJoin("seriesplayers",function($join){
                $join->on("seriesplayers.series","=","listmatches.series")
                  ->on("matchplayers.playerid","=","seriesplayers.player");
            })->whereIn('players.id', $data->players)->select(DB::raw('CONCAT("'.PLAYERS_DIRECTORY_URL.'", playerdetails.image) as image, "false" as isSelected, CASE WHEN listmatches.team1=players.team THEN "team1" ELSE "team2" END as team, CASE WHEN listmatches.team1=players.team THEN t1.short_name ELSE t2.short_name END as teamname, CASE WHEN listmatches.team1=players.team THEN t1.color ELSE t2.color END as teamcolor, CASE WHEN seriesplayers.totalpoints IS NULL OR seriesplayers.totalpoints = "" THEN 0 ELSE seriesplayers.totalpoints END AS totalpoints'),'matchplayers.role as role','matchplayers.credit as credit','matchplayers.role','players.player_name as name','players.id as id','players.player_key as playerkey','listmatches.team1display as team1_code','listmatches.team2display as team2_code','listmatches.start_date','matchplayers.selected_percent as selected_by','matchplayers.selected_captain_percent','matchplayers.selected_vicecaptain_percent')->orderBy('players.points','DESC')->get();
        foreach ($players as $key => $value) {
                    if(!($this->checkRemoteFile($value->image))){
                        $value->image = DEFAULT_PLAYERS_IMAGE;
                     }
                     $players->image =  $value->image;
                  }

                    $series = DB::table('listmatches')->where('matchkey',$matchkey)->where('listmatches.sport_type', $sportType->id)->select('series')->first();
      $findallmatches = DB::table('listmatches')->where('series',$series->series)->select('listmatches.matchkey')->get();


      if(!empty($findallmatches)){

        foreach($findallmatches as $matches){

          $allmatchkey[] = $matches->matchkey;

        }

      }
       foreach ($players as $key => $value) {
          $totalpoints = DB::table('matchplayers')
          ->whereIn('matchkey',$allmatchkey)
          ->where('playerid',$players[$key]->id)
          ->select(DB::raw("SUM(points) as totalpoints"))->get();

        $players[$key]->totalpoints = (float) $totalpoints[0]->totalpoints;

        if ($players[$key]->totalpoints == "") {
          $players[$key]->totalpoints = 0;
        }

      }

        $match_detail =  ListMatch::join('series', 'series.id', '=', 'listmatches.series')->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->select('listmatches.*','t1.short_name as team1key','t2.short_name as team2key','series.name as series','t1.logo as team1logo','t2.logo as team2logo')->where('matchkey', $matchkey)->where('listmatches.sport_type', $sportType->id)->first();
         if($match_detail->team1logo != '' && $this->checkDirectoryFile(TEAMS_DIRECTORY.$match_detail->team1logo))
                  $match_detail->team1logo = TEAMS_DIRECTORY_URL.$match_detail->team1logo;
                else
                  $match_detail->team1logo = DEFAULT_TEAM_IMAGE;

                if($match_detail->team2logo != '' && $this->checkDirectoryFile(TEAMS_DIRECTORY.$match_detail->team2logo))
                  $match_detail->team2logo = TEAMS_DIRECTORY_URL.$match_detail->team2logo;
                else
                  $match_detail->team2logo = DEFAULT_TEAM_IMAGE;
         $useramount = DB::table('userbalances')->where('user_id',$user_id)->first();
         // echo "<pre>";print_r($players);print_r($data);die();
    return view('web.team.updatecvc',compact('players','data','matchkey','match_detail','url','useramount','sport_key'));
  }

   //Edit team
  public function edit_team($team_id,$sport_key){
    $geturl = $this->geturl();
    $findmatch='';
       $userid = $_SESSION['id'];
    //Get User Team Name Show in My Team Page
     $userteamanme = RegisterUser::where('id',$userid)->select('team')->first();
      $team_info = JoinTeam::where('id', $team_id)->first();
      $matchkey = $team_info->matchkey;
      $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    //  print_r($sport_type);  die();
      $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
      Cache::forget('matchdetails_of_'.$matchkey);
      if(Cache::has('matchdetails_of_'.$matchkey)){
        $findmatch = Cache::get('matchdetails_of_'.$matchkey);
      }else{
        $teamplayer_list = Cache::remember('matchdetails_of_'.$matchkey,10, function() use ($matchkey, $geturl, $team_id){
        $query_data =   ListMatch::where('listmatches.matchkey',$matchkey)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->join('matchplayers','matchplayers.matchkey','=','listmatches.matchkey')->join('players','matchplayers.playerid','=','players.id')->join('playerdetails','players.player_key','=','playerdetails.player_key')
          ->leftJoin("seriesplayers",function($join){
            $join->on("seriesplayers.series","=","listmatches.series")
            ->on("matchplayers.playerid","=","seriesplayers.player");
          })->leftJoin("jointeam",DB::raw("find_in_set(players.id, jointeam.players) AND jointeam.id = ".$team_id."") , DB::raw('1'),DB::raw(''))->select(DB::raw('CONCAT("'.PLAYERS_DIRECTORY_URL.'", playerdetails.image) as image, "false" as isSelected, CASE WHEN listmatches.team1=players.team THEN "team1" ELSE "team2" END as team, CASE WHEN listmatches.team1=players.team THEN t1.short_name ELSE t2.short_name END as teamname, CASE WHEN listmatches.team1=players.team THEN t1.color ELSE t2.color END as teamcolor, CASE WHEN seriesplayers.totalpoints IS NULL OR seriesplayers.totalpoints = "" THEN 0 ELSE seriesplayers.totalpoints END AS totalpoints'),'matchplayers.role as role','matchplayers.credit as credit','matchplayers.selected_captain_percent','matchplayers.selected_vicecaptain_percent','players.player_name as name','players.id as id','players.player_key as playerkey','listmatches.team1display as team1_code','listmatches.team2display as team2_code','jointeam.players','listmatches.start_date','matchplayers.selected_percent as selected_by')->orderBy('matchplayers.credit','DESC')->groupBy('players.id')->get();
          return $query_data;
              });
      }
      $return_data = array();
      foreach ($teamplayer_list as $key => $value) {
         if(!($this->checkRemoteFile($value->image))){
            $value->image = DEFAULT_PLAYERS_IMAGE;
         }
         $players[$value->role][] =  $value;
      }

       $match_detail = ListMatch::where('matchkey', $matchkey)->where('listmatches.sport_type',$sportType->id)->join('teams as t1', 'listmatches.team1','=','t1.id')->join('teams as t2', 'listmatches.team2','=','t2.id')->select('listmatches.*','t1.logo as team1_icon','t2.logo as team2_icon')->first();

       $playing11 = array();
      date_default_timezone_set('Asia/Kolkata');
      $getcurrentdate = date('Y-m-d H:i:s');

      $tosstime = date('Y-m-d H:i:s', strtotime('-30 minutes', strtotime($match_detail['start_date'])));
      if($getcurrentdate>$tosstime){
        $find_playing_11 = MatchPlaying11::where('match_key', $matchkey)->first();
        if(empty($find_playing_11)) {
          $playing11 = $this->get_playing_11($matchkey);
        } else {
          $playing11 = unserialize($find_playing_11->player_ids);
        }
      }

      foreach ($teamplayer_list as $key => $value) {
          $teamplayer_list[$key]->is_playing = in_array($value->id,$playing11) ? 1 : 0;
          if(!empty($playing11)) {
            $teamplayer_list[$key]->is_playing_show = 1;
          } else {
            $teamplayer_list[$key]->is_playing_show = 0;
            $teamplayer_list[$key]->is_playing = -1;
          }

      }
    $playerLimit = CommonHelper::$playerLimit[$sport_type];


        $total_teams = JoinTeam::where('matchkey', $matchkey)->where('sport_type',$sportType->id)->select(DB::raw("COUNT(id) as total_count"))->get();

      foreach ($teamplayer_list as $key => $value) {

         $total_choose = JoinTeam::whereRaw('FIND_IN_SET('.$teamplayer_list[$key]->id.',players)')->where('matchkey', $matchkey)->where('sport_type',$sportType->id)->select(DB::raw("COUNT(id) as total_count"))->get();

            $teamplayer_list[$key]->selected_by = number_format((($total_choose[0]->total_count * 100) / $total_teams[0]->total_count),2);
      }

      $series = DB::table('listmatches')->where('matchkey',$matchkey)->where('listmatches.sport_type',$sportType->id)->select('series')->first();
      $findallmatches = DB::table('listmatches')->where('series',$series->series)->select('listmatches.matchkey')->get();


      if(!empty($findallmatches)){

        foreach($findallmatches as $matches){

          $allmatchkey[] = $matches->matchkey;

        }

      }

      foreach ($teamplayer_list as $key => $value) {
          $totalpoints = DB::table('matchplayers')
          ->whereIn('matchkey',$allmatchkey)
          ->where('playerid',$teamplayer_list[$key]->id)
          ->select(DB::raw("SUM(points) as totalpoints"))->get();

        $teamplayer_list[$key]->totalpoints = (float) $totalpoints[0]->totalpoints;

        if ($teamplayer_list[$key]->totalpoints == "") {
          $teamplayer_list[$key]->totalpoints = 0;
        }

      }

  $findjointeam = JoinTeam::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->where('userid',$userid)->orderBy('teamnumber','ASC')->select('id','teamnumber')->get();
  //echo "<pre>";print_r($findjointeam);exit;


     // echo "<pre>";print_r($players);exit;

      if($match_detail->team1_icon != ''){
          if($this->checkRemoteFile(TEAMS_DIRECTORY_URL.$match_detail->team1_icon)){
              $match_detail->team1_icon = TEAMS_DIRECTORY_URL.$match_detail->team1_icon;
          }
          else{
            $match_detail->team1_icon = TEAMS_DIRECTORY_URL.'dummy-team.png';
          }
      }else{
        $match_detail->team1_icon = TEAMS_DIRECTORY_URL.'dummy-team.png';
      }

      if($match_detail->team2_icon != ''){
          if($this->checkRemoteFile(TEAMS_DIRECTORY_URL.$match_detail->team2_icon)){
              $match_detail->team2_icon = TEAMS_DIRECTORY_URL.$match_detail->team2_icon;
          }
          else{
            $match_detail->team2_icon = TEAMS_DIRECTORY_URL.'dummy-team.png';
          }
      }else{
        $match_detail->team2_icon = TEAMS_DIRECTORY_URL.'dummy-team.png';
      }

 // print_r($players);die();
      return view('web.team.edit_team',compact('players','matchkey','team_id','match_detail','userteamanme','findjointeam','sport_key','playerLimit'));
  }

  //create team
  public function update_team(){
    date_default_timezone_set('Asia/Kolkata');
    $getteamid="";
    $user_team_id=$_POST['user_team_id'];
    $userid = $_SESSION['id'];
    $matchkey = $_POST['match_id'];
    $sport_key = $_POST['sport_key'];
    $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    //  print_r($sport_type);  die();
    $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
    $players = $_POST['players'];
    $vicecaptain = $_POST['vice_captain'];
    $captain = $_POST['captain_id'];

    $json = array();
    $playersarray = $players;
 //same team
$teamid_exist = JoinTeam::find($getteamid);
 $teamDataa = JoinTeam::where('userid',$userid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->get();
    // $checkPlayer[]  = 1;
    if(!$teamDataa->isEmpty()) {
      $checkPlayer  = [];
    if($teamid_exist)
    {
      // echo 1; exit;
      foreach($teamDataa as $playerKey => $playerTeams)
      {
        $isPlayer = [];
        if(count($teamDataa) > 1)
        {
          if($teamid_exist->id != $playerTeams->id)
          {
            // pr($playerTeams);
            if(!empty($playerTeams->players))
            {
              $players2 = array_filter(explode(',', $playerTeams->players));
              foreach($players2 as $playerDetail)
              {
                if(in_array($playerDetail,$playersarray) and $playerTeams->vicecaptain == $vicecaptain and $playerTeams->captain == $captain)
                {
                  $isPlayer[] = 1;
                }
                else
                {
                  $isPlayer[] = 0;
                }
              }
            }

            if(in_array(0,$isPlayer))

            {
              $checkPlayer[$playerKey]  = 1;
            }
            else
            {
              $checkPlayer[$playerKey]  = 0;
            }
          }
          if(in_array(0,$checkPlayer))
    {

        $Json['message'] = 'Cannot create same team multiple time.';
      $Json['status'] = "error";
      echo json_encode($Json);die;
    }  else {
    }
        }
        else
        {
          $checkPlayer[0] = 1;
        }
      }
    }
    else
    { //echo 1; exit;
      foreach($teamDataa as $playerKey => $playerTeams)
      {
        $isPlayer = [];
        if(!empty($playerTeams->players))
        {
          $players2 = array_filter(explode(',', $playerTeams->players));
          foreach($players2 as $playerDetail)
          {
            if(in_array($playerDetail,$playersarray) and $playerTeams->vicecaptain == $vicecaptain and $playerTeams->captain == $captain)

            {
              $isPlayer[] = 1;
            }
            else
            {
              $isPlayer[] = 0;
            }
          }
        } //print_r($isPlayer); exit;

        // if(in_array(0,$isPlayer))
        if(in_array(0,$isPlayer))
        {
          $checkPlayer[$playerKey]  = 1;
        }
        else
        {
          $checkPlayer[$playerKey]  = 0;
        }
      }
        // print_r($checkPlayer); exit;
    if(in_array(0,$checkPlayer))
    {

       $Json['message'] = 'Cannot create same team multiple time.';
      $Json['status'] = "error";
      echo json_encode($Json);die;
    }  else {
    }
    }

    }

//end same team

    $findallplayerdetails = MatchPlayer::whereIn('playerid',$playersarray)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->select('credit')->get();

    if(!empty($findallplayerdetails)){
      $allc = 0;
      foreach($findallplayerdetails as $pcred){
        $allc+=$pcred->credit;
      }
      if($allc>100){
        $Json['message'] = "Player credits exceed";
        $Json['status'] = "error";
        echo json_encode($Json);die;
      }

    }
    $getcurrentdate = date('Y-m-d H:i:s');
    $findmatchdetails = ListMatch::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->where('start_date','>=',$getcurrentdate)->select('start_date')->first();
    if(!empty($findmatchdetails)){


      $matchremainingdate = $findmatchdetails->start_date;
      if($getcurrentdate>=$matchremainingdate){
        $Json['message'] = 'match closed';
        $Json['status'] = "error";
        echo json_encode($Json);die;
      }
    } else {
      $Json['message'] = 'sorry match closed';
      $Json['status'] = "error";
      echo json_encode($Json);die;
    }
      $json['marathonstatus'] = 0;
      $data['userid'] = $userid;
      $data['matchkey'] = $matchkey;
       $data['sport_type'] = $sportType->id;
      // $data['teamnumber'] = $teamnumber;
      $data['players'] = implode(',', $players);
      $data['vicecaptain'] = $vicecaptain;
      $data['captain'] = $captain;

      $findcreateteam = JoinTeam::where('userid',$userid)->where('matchkey',$matchkey)->where('sport_type',$sportType->id)->where('id',$user_team_id)->select('id')->first();


      if(!empty($findcreateteam)){
          DB::table('jointeam')->where('id',$findcreateteam->id)->update($data);
        $getteamid = $findcreateteam->id;

      }

      $json['status'] = "success";
      $json['teamid'] = $getteamid;
      echo json_encode($json);die;


  }

  //create team
  public function clone_team($team_id,$sport_key){

     $geturl = $this->geturl();
      $findmatch='';
       $userid = $_SESSION['id'];
    //Get User Team Name Show in My Team Page
     $userteamanme = RegisterUser::where('id',$userid)->select('team')->first();
      $team_info = JoinTeam::where('id', $team_id)->first();
      $matchkey = $team_info->matchkey;
       $sport_type = (isset($sport_key) ? $sport_key : CRICKET);
    //  print_r($sport_type);  die();
      $sportType = DB::table('sport_types')->where('sport_key',$sport_type)->first();
     Cache::forget('matchdetails_of_'.$matchkey);
      if(Cache::has('matchdetails_of_'.$matchkey)){
        $findmatch = Cache::get('matchdetails_of_'.$matchkey);
      }else{
        $teamplayer_list = Cache::remember('matchdetails_of_'.$matchkey,10, function() use ($matchkey, $geturl, $team_id){
        $query_data =   ListMatch::where('listmatches.matchkey',$matchkey)->join('teams as t1','t1.id','=','listmatches.team1')->join('teams as t2','t2.id','=','listmatches.team2')->join('matchplayers','matchplayers.matchkey','=','listmatches.matchkey')->join('players','matchplayers.playerid','=','players.id')->join('playerdetails','players.player_key','=','playerdetails.player_key')
          ->leftJoin("seriesplayers",function($join){
                    $join->on("seriesplayers.series","=","listmatches.series")
                      ->on("matchplayers.playerid","=","seriesplayers.player");
                })->leftJoin("jointeam",DB::raw("find_in_set(players.id, jointeam.players) AND jointeam.id = ".$team_id."") , DB::raw('1'),DB::raw('1'))->select(DB::raw('CONCAT("'.PLAYERS_DIRECTORY_URL.'", playerdetails.image) as image, "false" as isSelected, CASE WHEN listmatches.team1=players.team THEN "team1" ELSE "team2" END as team, CASE WHEN listmatches.team1=players.team THEN t1.short_name ELSE t2.short_name END as teamname, CASE WHEN listmatches.team1=players.team THEN t1.color ELSE t2.color END as teamcolor, CASE WHEN seriesplayers.totalpoints IS NULL OR seriesplayers.totalpoints = "" THEN 0 ELSE seriesplayers.totalpoints END AS totalpoints'),'matchplayers.role as role','matchplayers.credit as credit','matchplayers.role','players.player_name as name','players.id as id','players.player_key as playerkey','listmatches.team1display as team1_code','listmatches.team2display as team2_code','jointeam.players','listmatches.start_date','matchplayers.selected_percent as selected_by')->orderBy('matchplayers.credit','DESC')->groupBy('players.id')->get();
          return $query_data;
              });
      }
      $return_data = array();
      foreach ($teamplayer_list as $key => $value) {
         if(!($this->checkRemoteFile($value->image))){
            $value->image = DEFAULT_PLAYERS_IMAGE;
         }
         $players[$value->role][] =  $value;
      }

       $match_detail = ListMatch::where('matchkey', $matchkey)->where('listmatches.sport_type',$sportType->id)->join('teams as t1', 'listmatches.team1','=','t1.id')->join('teams as t2', 'listmatches.team2','=','t2.id')->select('listmatches.*','t1.logo as team1_icon','t2.logo as team2_icon')->first();

       $playing11 = array();
      date_default_timezone_set('Asia/Kolkata');
      $getcurrentdate = date('Y-m-d H:i:s');

      $tosstime = date('Y-m-d H:i:s', strtotime('-30 minutes', strtotime($match_detail['start_date'])));
      if($getcurrentdate>$tosstime){
        $find_playing_11 = MatchPlaying11::where('match_key', $matchkey)->first();
        if(empty($find_playing_11)) {
          $playing11 = $this->get_playing_11($matchkey);
        } else {
          $playing11 = unserialize($find_playing_11->player_ids);
        }
      }

       foreach ($teamplayer_list as $key => $value) {
          $teamplayer_list[$key]->is_playing = in_array($value->id,$playing11) ? 1 : 0;
          if(!empty($playing11)) {
            $teamplayer_list[$key]->is_playing_show = 1;
          } else {
            $teamplayer_list[$key]->is_playing_show = 0;
            $teamplayer_list[$key]->is_playing = -1;
          }

      }
    $playerLimit = CommonHelper::$playerLimit[$sport_type];

        $total_teams = JoinTeam::where('matchkey', $matchkey)->where('sport_type',$sportType->id)->select(DB::raw("COUNT(id) as total_count"))->get();

      foreach ($teamplayer_list as $key => $value) {

         $total_choose = JoinTeam::whereRaw('FIND_IN_SET('.$teamplayer_list[$key]->id.',players)')->where('matchkey', $matchkey)->where('sport_type',$sportType->id)->select(DB::raw("COUNT(id) as total_count"))->get();

            $teamplayer_list[$key]->selected_by = number_format((($total_choose[0]->total_count * 100) / $total_teams[0]->total_count),2);
      }

        $series = DB::table('listmatches')->where('matchkey',$matchkey)->where('listmatches.sport_type',$sportType->id)->select('series')->first();
      $findallmatches = DB::table('listmatches')->where('series',$series->series)->select('listmatches.matchkey')->get();


      if(!empty($findallmatches)){

        foreach($findallmatches as $matches){

          $allmatchkey[] = $matches->matchkey;

        }

      }

      foreach ($teamplayer_list as $key => $value) {
          $totalpoints = DB::table('matchplayers')
          ->whereIn('matchkey',$allmatchkey)
          ->where('playerid',$teamplayer_list[$key]->id)
          ->select(DB::raw("SUM(points) as totalpoints"))->get();

        $teamplayer_list[$key]->totalpoints = (float) $totalpoints[0]->totalpoints;

        if ($teamplayer_list[$key]->totalpoints == "") {
          $teamplayer_list[$key]->totalpoints = 0;
        }

      }


  $findjointeam = JoinTeam::where('matchkey',$matchkey)->where('sport_type',$sportType->id)->where('userid',$userid)->orderBy('teamnumber','ASC')->select('id','teamnumber')->get();



      //echo "<pre>";print_r($value);exit;

       if($this->checkRemoteFile(TEAMS_DIRECTORY_URL.$match_detail->team1_icon))
          $match_detail->team1_icon = TEAMS_DIRECTORY_URL.$match_detail->team1_icon;
      else
          $match_detail->team1_icon = TEAMS_DIRECTORY_URL.'dummy-team.png';

      if($this->checkRemoteFile(TEAMS_DIRECTORY_URL.$match_detail->team2_icon))
          $match_detail->team2_icon = TEAMS_DIRECTORY_URL.$match_detail->team2_icon;
      else
          $match_detail->team2_icon = TEAMS_DIRECTORY_URL.'dummy-team.png';

      // echo "<pre>";print_r($players);die();

       return view('web.team.clone_team',compact('players','matchkey','team_id','match_detail','userteamanme','findjointeam','sport_key','playerLimit'));
  }



  //Player Info
  public function player_info(Request $request,$playerid,$matchkey,$team_id=0){
    $url = $this->geturl();
        $userid = $_SESSION['id'];
     // $playerid = $request->playerid;

      // $matchkey = $request->matchkey;

      $findseries = ListMatch::where('matchkey',$matchkey)->select('series')->first();

      $findplayerdetails = MatchPlayer::join('players','players.id','=','matchplayers.playerid')->join('playerdetails','playerdetails.player_key','=','players.player_key')->where('matchplayers.matchkey',$matchkey)->where('matchplayers.playerid',$playerid)->select('playerdetails.fullname as playername','matchplayers.credit as playercredit','matchplayers.role as playerrole','players.points as playerpoints','playerdetails.image as playerimage','players.player_key as playerkey','playerdetails.batting_style','playerdetails.bowling_style','playerdetails.country','playerdetails.id','playerdetails.dob')->first();


      $Json = array();

      $findjoinedleauges = JoinTeam::where('jointeam.matchkey',$matchkey)->select('jointeam.players')->get();

      $joinedlength = count($findjoinedleauges);

      $joinplayers = array();

      $joinplayerslist = array();

      if(!empty($findjoinedleauges)){

        foreach($findjoinedleauges as $joinleauges){

          $joinplayers[] = $joinleauges->players;

        }

      }

      if(!empty($joinplayers)){

        foreach($joinplayers as $jp=>$jpkey){

          $joinplayerslist[] = explode(',',$jpkey);

        }

      }

      if(!empty($findplayerdetails)){

        $totalpoints = 0;

        $Json['id'] = $findplayerdetails->id;

        $Json['playername'] = $findplayerdetails->playername;

        // $Json['totalpoints'] = "354";

        $Json['playerkey'] = $findplayerdetails->playerkey;

        $Json['playercredit'] = $findplayerdetails->playercredit;

        if($findplayerdetails->playerimage==""){

          $Json['playerimage'] = DEFAULT_PLAYERS_IMAGE;

        }else{

          $Json['playerimage'] =  PLAYERS_DIRECTORY_URL.$findplayerdetails->playerimage;

        }

        $Json['playerpoints'] = $findplayerdetails->playerpoints ? $findplayerdetails->playerpoints : 0;

        $Json['battingstyle'] = $findplayerdetails->batting_style;

        $Json['bowlingstyle'] = $findplayerdetails->bowling_style;

        $Json['country'] = is_null($findplayerdetails->country) ? "" : $findplayerdetails->country;

        // echo $findplayerdetails->dob;die;

        if($findplayerdetails->dob!='0000-00-00'){

          $Json['dob'] = ($findplayerdetails->dob == '1970-01-01') ? "" : $findplayerdetails->dob ;

        }else{

          $Json['dob'] = "";

        }



        if($findplayerdetails->playerrole=='allrounder'){

          $Json['playerrole'] = 'All Rounder';

        }

        else if($findplayerdetails->playerrole=='keeper'){

          $Json['playerrole'] = 'Wicket Keeper';

        }

        else{

          $Json['playerrole'] = ucwords($findplayerdetails->playerrole);

        }

        $getteam="";

        $findallteams = Player::where('player_key',$findplayerdetails->playerkey)->join('teams','teams.id','=','players.team')->select('teams.team')->get();

        if(!empty($findallteams)){

          foreach($findallteams as $teams){

            $getteam.=$teams->team.', ';

          }

        }

        $Json['teams'] =  rtrim($getteam,', ');

        $cnt=0;

        if(!empty($joinplayerslist)){

          foreach($joinplayerslist as $jn){

            if(in_array($playerid,$jn)){

              $cnt++;

            }

          }

          $Json['per']= 0;//(float) number_format((float)$this->total_winning((($cnt*100)/$joinedlength)), 2, '.', '');

        }else{

          $Json['per'] = 0;

        }

        $findallmatches = ListMatch::join('matchplayers','matchplayers.matchkey','=','listmatches.matchkey')->join('players','players.id','=','matchplayers.playerid')->leftjoin('result_points','result_points.matchkey','=','listmatches.matchkey')->where('result_points.playerid',$playerid)->where('listmatches.series',$findseries->series)->select('listmatches.title','listmatches.matchkey','listmatches.start_date','listmatches.short_name','result_points.total as totalpoints','result_points.id as rid','players.player_name as playername','players.id as player_id','result_points.*')->groupBy('listmatches.matchkey')->orderBy('start_date','DESC')->get();

        // $findallmatches = DB::table('resultmatches')->join('listmatches','listmatches.matchkey','=','resultmatches.match_key')->where('resultmatches.player_id',$playerid)->where('listmatches.series',$findseries->series)->select('resultmatches.*','listmatches.start_date','listmatches.title','listmatches.short_name')->orderBy('listmatches.start_date','DESC')->get();

        if(!empty($findallmatches)){

          $i=0;

          foreach($findallmatches as $player){

            $Json['matches'][$i]['playername'] = $findplayerdetails->playername;

            $Json['matches'][$i]['matchname'] = $player->title;

            $Json['matches'][$i]['short_name'] = $player->short_name;

            $Json['matches'][$i]['total_points'] = $player->totalpoints;

            $totalpoints += $player->totalpoints;

            $finduselectthisplayer = JoinTeam::where('matchkey',$player->matchkey)->select('players')->get();

            $countlenght = count($finduselectthisplayer);

            $allplayers=array();$countplayer=0;

            if(!empty($finduselectthisplayer)){

              foreach($finduselectthisplayer as $pp){

                $fplayers = array();

                $fplayers = explode(',',$pp->players);

                foreach($fplayers as $fpl){

                  $allplayers[] = $fpl;

                }

              }

            }

            if(!empty($allplayers)){

              foreach($allplayers as $pl){

                if($pl==$player->playerid){

                  $countplayer++;

                }

              }

            }

            if($countplayer>0){

              $countper = round(($countplayer/$countlenght)*100,2);

            }else{

              $countper = 0;

            }

            $Json['matches'][$i]['selectper'] = $countper.'%';

            $Json['matches'][$i]['matchdate'] = date('d M, Y',strtotime($player->start_date));

            $i++;

          }





        }

        $Json['total_points'] = (string)$totalpoints;
        $Json['playerpoints'] = (string)$totalpoints;



      }



        //  print_r($player_details->image); exit;
    if($request->ajax()){
        $res = array("player_details"=> $Json,"status"=>200);
        echo json_encode($res);
        die();
    }
    else{
        return view('web.team.player_info', compact('player_details'));
    }


  }

public function livescoreboard()
{
  return view('web.team.live_scoreboard');
}

  function checkRemoteFile($url) {
      $url = str_replace(' ', '%20', $url);
      $file_headers = @get_headers($url);
      if (!empty($file_headers[0]) && strpos($file_headers[0], "200 OK") > 0) {
         return true;
      } else {
        return false;
      }
  }


 //file check in folder
  public function checkDirectoryFile($url) {
    if(file_exists($url))
        return true;
    else
        return false;
  }
  //end file check
}
?>
