<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\JoinedLeague;
use App\MatchPriceCard;
use App\Helpers\Helpers;

class JoincodeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */

    public function toArray($request)
    {
      $image = PLAYER_MEN_DEFAULT_IMAGE;
      if(isset($this->image)){
          if(!empty($this->image)){
              $image = $this->image;
          }
      }
      $challenge_text = '';
      if(@$this->maximum_user == @$this->joinedusers) {
        $challenge_text = 'Canceled due to clash';
      } elseif (@$this->maximum_user > @$this->joinedusers) {
        $challenge_text = 'Canceled due to not fill';
      }

      if(@$this->matchstatus=='IsCanceled' || @$this->matchstatus=='IsAbandoned') {
        $challenge_text = 'Match Canceled';
      }


      $firstRankPrizeVal = (string) @$this->is_leaderboard != 1 ? (@$this->first_rank_prize ? $this->first_rank_prize : (is_null($winners =  MatchPriceCard::where('matchkey',$request->matchkey)->where('challenge_id',$this->id)->max('price')) ? 0 : $winners)) : 0;
      if(@$this->get_challenge_new==1 && (in_array($this->id, explode(',',@$this->joined_challenge_ids)) && $this->multi_entry==0)){
        return (object)array();
      }
        // $challenge_text = '';
         return [
                "id"=> isset($this->id) ? $this->id : 0,
                "challenge_id"=> isset($this->challenge_id) ? $this->challenge_id : 0,
                "real_challenge_id"=> isset($this->real_challenge_id) ? $this->real_challenge_id : 0,
                "name"=> isset($this->name) ? $this->name : '',
                "challenge_type"=> isset($this->challenge_type) ? $this->challenge_type : "",
                "winning_percentage"=> isset($this->winning_percentage) ? $this->winning_percentage : 0,
                // "entryfee"=> (int) (isset($this->entryfee) ? $this->entryfee : 0),
                //@nirmal@rg
                "is_fav_contest"=>(isset($this->user_fav_contests_ids) && !empty($this->user_fav_contests_ids) && !is_null($this->user_fav_contests_ids)) ? (in_array($this->real_challenge_id, explode(',', $this->user_fav_contests_ids)) ? 1 : 0) : ((isset($this->is_selected) && !empty($this->is_selected) && !is_null($this->is_selected)) ? $this->is_selected: 0),
                "challenge_status" => @$this->challenge_status ? $this->challenge_status : '',
                "challenge_text" => $challenge_text,
                // "challenge_status" => 'canceled',
                // "challenge_text" => @$this->maximum_user == @$this->joinedusers ? 'Canceled due to clash' : 'Canceled due to not fill',
                "is_fav_visible"=>1,
                "real_challenge_id"=>@$this->real_challenge_id ? @$this->real_challenge_id : 0,
                "entryfee"=> (string) (int) (isset($this->entryfee) ? $this->entryfee : 0),
                "winning_amount" => isset($this->winningamount) ? ($this->winningamount!="" ? number_format((float)$this->winningamount, 2, '.', '') : 0) : "0",
                // "win_amount"=>(int) (isset($this->win_amount) ? $this->win_amount : 0),

                // "win_amount"=> (int) @$this->is_champion == 1 ? ((int)$this->entryfee * 2) : (int) (isset($this->win_amount) ? $this->win_amount : 0),
                "win_amount"=>  (int) (isset($this->win_amount) ? $this->win_amount : 0),

                "maximum_user"=>(int) (isset($this->maximum_user) ? $this->maximum_user : 0),
                "getjoinedpercentage"=>(int) (round( isset($this->maximum_user) ? $this->maximum_user : 0) == 0 ? 0 :round(((isset($this->joinedusers) ? $this->joinedusers : 0)/$this->maximum_user)*100,0)),
                "winners"=> isset($this->winners) ? $this->winners : 0,
                "userid"=> isset($this->user_id) ? $this->user_id : 0,
                "userrank"=> isset($this->userrank) ? ((@$this->is_league_detail2 == 1 || @$this->is_leaderboard == 1)  ? (string)$this->userrank : (int)$this->userrank) : 0,
                "team_id"=> isset($this->team_id) ? $this->team_id : 0,
                "join_id" => isset($this->join_id) ? $this->join_id : 0,
                "matchkey"=>(string) (isset($this->matchkey) ? $this->matchkey : ''),
                "joinedusers"=>(int) isset($this->joinedusers) ? (@$this->is_champion==1 ? $this->joinedusers - 1 : $this->joinedusers) : 0,
                "team1display" => (string) strtoupper(isset($this->team1display) ? $this->team1display : ''),
                "team2display" => (string) strtoupper(isset($this->team1display) ? $this->team1display : ''),
                "multi_entry"=>(int) isset($this->multi_entry) ? $this->multi_entry : '',
                "confirmed_challenge"=>(int) (isset($this->confirmed_challenge) ? $this->confirmed_challenge : 0),
                "is_running"=>(int) (isset($this->is_running) ? $this->confirmed_challenge : 0),
                // "is_free"=>(int) (isset($this->is_free) ? $this->is_free : 1),
                "is_free"=>(int) (isset($this->is_giveaway) ? $this->is_giveaway : 1),
                "dis_price"=>(string) (isset($this->dis_price) ? $this->dis_price : 0),
                "is_bonus"=> (int) (isset($this->is_bonus) ? $this->is_bonus : (isset($this->bonus) ? $this->bonus : 0)),
                "bonus_percent" => (int) (isset($this->bonus_precent) ? $this->bonus_precent : 0)."%",
                //"isselected"=>(isset($this->team_id) && (@$this->is_league_detail2 == 1 || $this->is_leaderboard == 1)) ? ($this->user_id==$request->user_id ? true : false) : (isset($this->joined_challenge_ids) ? (in_array($this->id, explode(',', $this->joined_challenge_ids)) ? true : false) : (JoinedLeague::where('challengeid',$this->id)->where('userid',$request->user_id)->count())!=0 ? true : false),
                "isselected"=>false,
                "isselectedid"=>"",
                // "totalwinners" => 4,
                // "joinedleagueskey" => @$this->is_leaderboard != 1 ? $join_withcount($joinedleagues = JoinedLeague::where('challengeid',isset($this->challenge_id) ? $this->challenge_id : 0)->where('userid',$request->user_id)->get()) : 0,
                "joinedleagueskey" => @$this->is_leaderboard != 1 ? (isset($this->join_with) ? $this->join_with : 0) : 0,
                "points" => isset($this->points) ? number_format((float)$this->points, 2, '.', '') : 0,
                // "isjoined"=> (isset($this->team_id) && (@$this->is_league_detail2 == 1)) ? (count(JoinedLeague::where('challengeid',$this->challenge_id)->where('userid',$request->user_id)->where('teamid',$this->team_id)->get()) !=0 ? true : false) : (count(JoinedLeague::where('challengeid',$this->id)->where('userid',$request->user_id)->get())!=0 ? true : false),
                // "isjoined"=> (isset($this->team_id) && (@$this->is_league_detail2 == 1)) ? ($this->user_id==$request->user_id ? true : false) : ((JoinedLeague::where('challengeid',$this->id)->where('userid',$request->user_id)->count())!=0 ? true : false),
                // "isjoined"=> (isset($this->team_id) && (@$this->is_league_detail2 == 1 || $this->is_leaderboard == 1)) ? ($this->user_id==$request->user_id ? true : false) : (isset($this->joined_challenge_ids) ? (in_array($this->id, explode(',', $this->joined_challenge_ids)) ? true : false) : (JoinedLeague::where('challengeid',$this->id)->where('userid',$request->user_id)->count())!=0 ? true : false),
                "isjoined"=>false,
                "join_with" => isset($this->join_with) ? $this->join_with : 0,
                // "isselected"=> count ($joinedleagues) !=0 ?  (($this->multi_entry ==1 && count($joinedleagues)<6) ? false : true) : false,
                 "refercode"=> isset($this->refercode) ? $this->refercode : "",
                "totalwinners" => @$this->is_leaderboard != 1 ? (@$this->winners ? $this->winners : (is_null($winners =  MatchPriceCard::where('matchkey',$request->matchkey)->where('challenge_id',$this->id)->sum('winners')) ? 0 : $winners)) : 0,
                "first_rank_prize" => floatval(number_format($firstRankPrizeVal, 2, '.', '')),
                // "totalwinners"=>(int) ($winners = MatchPriceCard::where('matchkey',isset($this->matchkey) ? $this->matchkey : '')->where('challenge_id',isset($this->challenge_id) ? $this->challenge_id : 0)->winners) ? $winners : 0,
                "pdf" => isset($this->pdf) ? $this->pdf : "",
                "max_team_limit" => @$this->max_team_limit,
                "max_multi_entry_user" => @$this->max_team_limit,
                // "pdf" => BASE_URL.'pdffolders/join-leauges-12574.pdf',
                // "pdf" => "",
                "winners_zone" => isset($this->winners_zone) ? $this->winners_zone : array(),
                "announcement" => "Dummy Text",
                // "user_image" => isset($this->image) ? $this->image : ""
                "user_image" => $image,
                "min_ranks"=>isset($this->min_rank) ? $this->min_rank : 1000,
                "max_ranks"=>isset($this->max_rank) ? $this->max_rank :1000,
                // "is_winning_zone" => 0,
                "is_winning_zone" => (isset($this->min_rank) && isset($this->max_rank) && ($this->user_id==$request->user_id)) ? (($this->userrank >= @$this->min_rank && $this->userrank <= @$this->max_rank) ? 1 :0)  : 0,
                "is_first_time_free"=>isset($this->is_first_time_free) ? $this->is_first_time_free : 0,
                "first_time_free_amount"=>isset($this->first_time_free_amount) ? $this->first_time_free_amount : 0,
                // "user_image" => ""
                "is_giveaway_visible_text"=>isset($this->is_giveaway) ? $this->is_giveaway : 0,
                "is_giveaway_text"=>isset($this->giveaway_text) ? $this->giveaway_text : "",
                  "giveaway_color" => (!isset($this->giveaway_color) && empty($this->giveaway_color)) ? '' : $this->giveaway_color,
                  "prize_pool_color"=>"#000000",
                  "is_prizepool_color"=>0,
                  "is_offer_team" => @$this->is_offer_team,
                  "is_champion"=> @$this->is_champion,
                  "champion_player" => (int) @$this->is_champion == 1 ? BANNER_DIRECTORY_URL.@$this->champion_image : '',
                  "champion_x" => (int) @$this->is_champion == 1 ? '2x' : ''

            ];
    }
}
