<?php

namespace App\Http\Resources;

use App\Helpers\Helpers;

use App\Player;
use Illuminate\Http\Resources\Json\JsonResource;
use App\ListMatch;
use DB;
use App\MatchPlayer;

class MatchPlayerResource_new_v2 extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $arr_player_point = [];
        // $playerkey = DB::table('players')->where('id',$this->pid)->pluck('player_key');
        // $player_point_last = DB::table('last_match_player_points')->where('player_key',$playerkey)->get();
        // $player_point_last = DB::table('last_match_player_points')->where('sport_key',$this->sport_type_p)->where('player_key',$playerkey)->get();
        $player_point_last = [];
        foreach ($player_point_last as $key => $value_po) {
            array_push($arr_player_point, $value_po->points);
        }
        $matchTitle = $this->match_title ?? '';
        $match_season = $this->match_season ?? '';
        $defaultPlayerImage = PLAYER_MEN_DEFAULT_IMAGE;
        if (!empty($matchTitle)) {
            if (strpos('women', strtolower($matchTitle)) !== false) {
                $defaultPlayerImage = PLAYER_WOMEN_DEFAULT_IMAGE;
            }
        }
        if (!empty($match_season)) {
            // var_dump($match_season);
            // echo strpos('women',"hundred women");
            // exit;
            if (strpos(strtolower($match_season), 'women') !== false) {
                $defaultPlayerImage = PLAYER_WOMEN_DEFAULT_IMAGE;
            }
        }
        $display_role = '';
        $short_role = '';
        if (isset($this->playerrole)) {
            if (strtolower($this->playerrole) == 'goalkeeper') {
                $display_role = "Goal Keeper";
                $short_role = 'GK';
            }
            if (strtolower($this->playerrole) == 'catcher') {
                $display_role = "Catcher";
                $short_role = 'C';
            }
            if (strtolower($this->playerrole) == 'raider') {
                $display_role = "Raider";
                $short_role = 'RAID';
            }
            if (strtolower($this->playerrole) == 'defender') {
                $display_role = "Defender";
                $short_role = 'DEF';
            }
            if (strtolower($this->playerrole) == 'allrounder') {
                $display_role = "All Rounder";
                $short_role = 'AR';
            }

            if (strtolower($this->playerrole) == 'infielder') {
                $display_role = "Infielder";
                $short_role = 'IF';
            }

            if (strtolower($this->playerrole) == 'centre') {
                $display_role = "Centre";
                $short_role = 'C';
            }
            if (strtolower($this->playerrole) == 'center') {
                $display_role = "Center";
                $short_role = 'C';
            }
            if (strtolower($this->playerrole) == 'point guard') {
                $display_role = "Point Guard";
                $short_role = 'PG';
            }
            if (strtolower($this->playerrole) == 'shooting guard') {
                $display_role = "Shooting Guard";
                $short_role = 'SG';
            }
            if (strtolower($this->playerrole) == 'small forward') {
                $display_role = "Small Forward";
                $short_role = 'SF';
            }
            if (strtolower($this->playerrole) == 'power forward') {
                $display_role = "Power Forward";
                $short_role = 'PF';
            }
            if (strtolower($this->playerrole) == 'fullbacks') {
                $display_role = "Fullbacks";
                $short_role = 'GK';
            }

            if (strtolower($this->playerrole) == 'striker') {
                $display_role = "Striker";
                $short_role = 'ST';
            }
            if (strtolower($this->playerrole) == 'wingers') {
                $display_role = "Wingers";
                $short_role = 'GK';
            }
            if (strtolower($this->playerrole) == 'outfielder') {
                $display_role = "Outfielder";
                $short_role = 'OF';
            }
            if (strtolower($this->playerrole) == 'pitcher') {
                $display_role = "Pitcher";
                $short_role = 'P';
            }
            if (strtolower($this->playerrole) == 'forward') {
                $display_role = "State Forward";
                $short_role = 'SF';
            }

            if (strtolower($this->playerrole) == 'keeper') {
                $display_role = "Wicket Keeper";
                $short_role = 'WK';
            }
            if (strtolower($this->playerrole) == 'midfielder') {
                $display_role = "MidFielder";
                $short_role = 'MID';
            }
            if (strtolower($this->playerrole) == 'midfield') {
                $display_role = "MidFielder";
                $short_role = 'MID';
            }
            if (strtolower($this->playerrole) == 'bowler') {
                $display_role = "Bowler";
                $short_role = 'BOW';
            }
            if (strtolower($this->playerrole) == 'batsman') {
                $display_role = "Batsman";
                $short_role = 'BAT';
            }
        }
        $playername = '';
        if (isset($this->playername)) {
            $fullname = explode(" ", $this->playername);
            $fname = $fullname[0];

            if (!isset($fullname[1])) {
                $playername = $this->playername;
            } else {
                $sname = $fullname[1];
                if (isset($fullname[2])) {
                    $sname = $fullname[1] . ' ' . $fullname[2];
                }
                if (isset($fname[0])) {
                    $playername = $fname[0] . ' ' . $sname;
                } else {
                    $playername = $this->playername;
                }
            }
        }

        $last_match_played_info_text = 'Last 5 Matches Fantasy Points';
        $is_visible_last_match_played = 1;

        $lastmatchplayed_arr[0] = array(1, 2, 3, 4, 5);
        $lastmatchplayed_arr[1] = array(1, 2, 3);
        $lastmatchplayed_arr[2] = array(10, 20, 30);
        $lastmatchplayed_arr[3] = array();
        $lastmatchplayed_arr[4] = array(10, 202, 1);
        $lastmatchplayed_arr[5] = array(56, 22);

        $last_matchPlayed_rand = rand(0, 5);

        $isplaying = in_array($this->pid, (explode(',', $this->playing))) ? 1 : 0;
        // $supstitue = $this->is_substitute;
          $supstitue =0;
        if ($isplaying == 0 && $supstitue == 0) {
            $supstitue = 2;
        }


        //$dbPlayerPoints =  MatchPlayer::where('matchplayers.matchkey',$this->matchkey)->get();
        $issubstituteplayer = array();
        // foreach ($dbPlayerPoints as $key => $value) {
        //    if($value->is_substitute==1)
        //    {
        //$issubstituteplayer[$key]=$value->playerid;
        //   }
        // }
        $playing_players_array = explode(',', @$this->playing);
        $arraymerge = array_merge(@$playing_players_array, $issubstituteplayer);

        $imagepathcheck = '/var/www/html/XL11/fantasy-admin.xl11.in/';
        $exists = 1; // Helpers::checkImageExists('uploads/players/'.$this->image);
        //echo $exists;die;
        if ((file_exists($imagepathcheck . 'uploads/players/' . $this->image) && $this->image != "") || empty($exists)) //|| $this->matchkey=='72877'
        {
            $plyerimage = !empty($this->image) ? CDN_URL3 . 'uploads/players/' . $this->image : $defaultPlayerImage;
        } else if ($this->image != "") {
            $plyerimage = !empty($this->image) ? $this->image : $defaultPlayerImage;
        } else {
            $plyerimage =  $defaultPlayerImage;
        }
        return [
            "id" => $this->pid,
            "matchkey" => $this->matchkey,
            "name" => $playername,
            "role" => $this->playerrole,
            "short_role" => $short_role,
            "display_role" =>  $display_role,
            "credit" => $this->playercredit,
            //  "last_match" => (count(explode(',', $this->playing)) < 7) ? ($this->last_match_played=='true' ? 1 : 0) : 0,
            "last_match" => (count(explode(',', $this->playing)) < 7) ? ($this->last_match_played == 'true' ? 1 : 0) : 0,
            "last_match_text" => "Played last match",
            // "team"=>($this->team1 == $this->team) ? 'team1' : ($this->team2 == $this->team ? 'team2' : ''),
            "team" => is_string($this->team) ?  $this->team : (($this->team1 == $this->team) ? 'team1' : ($this->team2 == $this->team ? 'team2' : '')),
            "teamcode" =>    !is_null($this->teamcode) ? $this->teamcode : (($this->team1 == $this->team) ? strtoupper($this->team1display) : ($this->team2 == $this->team ? strtoupper($this->team2display) : '')),
            "last_played_points" => $arr_player_point,
            "last_match_played_info_text" => $last_match_played_info_text,
            "is_visible_last_match_played" => $is_visible_last_match_played,

            "teamcolor" => ($this->team1 == $this->team) ? $this->team1color : ($this->team2 == $this->team ? $this->team2color : ''),

            "teamcolor" => !is_null($this->teamcolor) ? $this->teamcolor : (($this->team1 == $this->team) ? $this->team1color : ($this->team2 == $this->team ? $this->team2color : '')),
            // "image"=> !empty($this->image) ? CDN_URL3.'uploads/players/'.$this->image : $defaultPlayerImage,
            "image" => $plyerimage,
            "vicecaptain" => is_null($this->vicecaptain) ? 0 : $this->vicecaptain,
            "captain" => is_null($this->captain) ? 0 : $this->captain,
            // "points"=> (is_null($this->points) || !isset($this->points)) ? 0 : $this->points,
            "points" => $this->points,
            //"is_playing" =>  in_array($this->pid,(explode(',', $this->playing))) ? 1 : 0,

            "is_playing" =>  in_array($this->pid, $arraymerge) ? 1 : 0,
            // "is_playing_new" =>  $this->playing,
            // "is_playing" =>  is_null($this->is_playing) ? 0 : $this->is_playing,

            //  "is_playing_show" => (count(explode(',', $this->playing)) > 7) ? 1 : 0,

            "is_playing_show" => (count($arraymerge) > 7) ? 1 : 0,
            "is_substitute" =>  $supstitue,
            "series_points" => $this->formatNumber((isset($this->series_points[$this->pid]) ? $this->series_points[$this->pid] : 0)),
            // "series_points"=> number_format((isset($this->series_points[$this->pid]) ? $this->series_points[$this->pid] : 0), 2, '.', ''),
            "selected_by" => "" . @$this->selected_percent,
            "vice_captain_selected_by" => "" . @$this->selected_vicecaptain_percent,
            "captain_selected_by" => "" . @$this->selected_captain_percent,
            "batting_order" => "" . @$this->batting_order,
        ];
    }

    public function formatNumber($number)
    {
        // Format the number with 2 decimal places
        $formatted = number_format($number, 2, '.', '');
        $formatted = rtrim($formatted, '0');
        $formatted = rtrim($formatted, '.');

        return $formatted;
    }
}
