<?php



namespace App;
use Tymon\JWTAuth\Contracts\JWTSubject;
use JWTAuth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;


class RegisterUser extends Model implements JWTSubject

{

    protected $table = 'registerusers';

    protected $fillable = ['username','email','preferance_email','password','mobile','year','month','day','paytm_n','paytm_mobile','payt_benid','banid','link','password_link','dob','refer_id','activation_status','new_phone_verify','jwt_token',

        'gender','code','playing_status','provider','address','city','state','country','pincode','team','mobile_verify','email_verify','pan_verify','bank_verify','refercode','emailbonus','mobilebonus','panbonus','token','signupbonus','referbonus','team','refer_code' , 'is_email_updated',
    'fcmToken','device_type', 'delete_status'];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function bank() {

        return $this->hasOne('App\Bank');

    }

    public function pan_card() {

        return $this->hasOne('App\PanCard');

    }

    public function user_balance() {

        return $this->hasOne('App\UserBalance');

    }

    public function final_results() {

        return $this->hasMany('App\FinalResult');

    }

    public function withdraw() {

        return $this->hasMany('App\Withdraw');

    }

    //  joined_league and user_id will be sharing ManyToMany relationship

    public function join_teams() {

        return $this->hasMany('App\JoinTeam');

    }

    public function notifications() {

        return $this->hasMany('App\Notification');

    }

    public function joined_leagues() {

        return $this->hasMany('App\JoinedLeague');

    }

    public function transactions() {

        return $this->hasMany('App\Transaction');

    }



}
