<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Series extends Model
{
	protected $table = 'series';
	protected $fillable = ['name', 'start_date', 'end_date', 'slug', 'series_status'];

	public function final_results()
	{
		return $this->belongsToMany('App\FinalResult');
	}

	public function matches()
	{
		return $this->hasMany(ListMatch::class, 'series')
			->leftJoin('match_playing11', 'match_playing11.match_key', '=', 'listmatches.matchkey')
			->join('teams as t1', 't1.id', '=', 'listmatches.team1')
			->join('teams as t2', 't2.id', '=', 'listmatches.team2')
			->whereNotIn('listmatches.status', ['completed', 'started'])
			->where(function ($q) {
				$q->where('listmatches.launch_status', 'launched')
					->orWhere('listmatches.is_release', 1);
			})
			->where('listmatches.series', '!=', '0')
			->groupBy('listmatches.matchkey')
			->orderBy('listmatches.sort', 'ASC')
			->orderBy('listmatches.start_date', 'ASC')
			
			->take(25);
	}
}
