function initAOSBasedOnScreenSize() {
  if (window.innerWidth > 768) { // Check if screen width is greater than 768px
    if (!document.body.classList.contains('aos-initialized')) { // Check if AOS has not already been initialized
      AOS.init({
        duration: 1200, // Set animation duration
      });
    }
  } else {
    // Disable AOS by removing any initialized animations or refreshing AOS
    AOS.refresh();  // Optionally refresh AOS to remove animations
    console.log('AOS animations are disabled on mobile.');
  }
}

// Initialize AOS initially when the page loads
initAOSBasedOnScreenSize();

// Listen for window resize and adjust AOS initialization accordingly
window.addEventListener('resize', initAOSBasedOnScreenSize);


$(document).ready(() => {
  var swiper = new Swiper(".mySwiper2", {
    slidesPerView: 3,
    slidesPerGroup: 1,
    speed: 1500,
    // autoplay: {
    //   delay: 1500,
    //   disableOnInteraction: false
    // },
    // loop: true,
    spaceBetween: 20,
    loopFillGroupWithBlank: true,
      navigation: {
      nextEl: ".swiper-button-next",
      prevEl: ".swiper-button-prev",
    },
    breakpoints: {

      0: {
        slidesPerView: 1,
        spaceBetween: 20
      },

      575: {
        slidesPerView: 2,
        spaceBetween: 20
      },
      1024: {
        slidesPerView: 3,
        spaceBetween: 20
      },
      1200: {
        slidesPerView: 3,
        spaceBetween: 20
      }
    }
  });
});
