<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\RegisterUser;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class CreateBotUsers extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:bot-users';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create bot users';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            $this->info("Starting to create bot users");
            $mobile = 8960000000;
            for ($i = 1; $i <= 40; $i++) {
                RegisterUser::updateOrCreate(
                    ['mobile' => $mobile + $i], // Condition to check existing record
                    [
                        'username' => "PnW-$i",
                        'email' => "PnW.$i@gmail.com",
                        'gender' => "M",
                        'password' => bcrypt("SachinBhai"),
                        'code' => 'asd',
                        'team' => $this->uniqueTeamName('team'),
                        'refercode' => $this->uniqueTeamName('refercode'),
                        'is_register_with_client' => 0,
                        'is_bot' => 1,
                    ]
                );
            }
            $this->info("Bot users created");
        } catch (\Exception $e) {
            $this->info($e->getMessage());
        }
    }


    private function uniqueTeamName(string $column): string
    {
        do {
            $randomString = Str::random(9);
        } while (\DB::table('registerusers')->where($column, $randomString)->exists());

        return $randomString;
    }
}
