<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\BaseController;
use App\Model\AdminUser;
use App\Services\Input;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;

/**
 * AdminDashBoard Controller
 *
 * Add your methods in the class below
 *
 * This file will render views\admin\dashboard
 */

class AdminDashboardController extends BaseController {

	 /**
	 * Function for display admin dashboard
	 */
    //
	public function showdashboard(){
		$unAllowedUserRoles		= [TEXT_ADMIN_ID];
		$month					=	date('m');
		$year					=	date('Y');
		for ($i = 0; $i < 12; $i++) {
			$months[] 			= 	date("Y-m", strtotime( date( 'Y-m-01' )." -$i months"));
		}
		$months					=	array_reverse($months);
		$num					=	0;
		$num1					=	0;
		foreach($months as $month){

			$monthStartDate							=	date('Y-m-01 00:00:00', strtotime($month));
			$monthEndDate							=	date('Y-m-t 23:59:59', strtotime($month));
			$formData								=	Input::all();
			if(!empty($formData)){
				$userType							=	(isset($formData['user_type'])) ? $formData['user_type'] : '';

				switch($userType){

					case AdminUser::MEMBER:
						$allUsers[$num]['month']	=	$month;
						$allUsers[$num]['users']    =   AdminUser::where('user_role_id',AdminUser::MEMBER)
															->where('created_at', '>' , $monthStartDate)
															->where('created_at','<' , $monthEndDate)
															->where('active',1)
															->where('is_deleted',0)
															->count();
						break;

					case 2:
						$allUsers[$num]['month']	=	$month;
						$allUsers[$num]['users']    =   AdminUser::where('user_role_id',2)
															->where('created_at', '>' , $monthStartDate)
															->where('created_at','<' , $monthEndDate)
															->where('active',1)
															->where('is_deleted',0)
															->count();
						break;

					case 3:
						$allUsers[$num]['month']	=	$month;
						$allUsers[$num]['users']    =   AdminUser::where('created_at', '>' , $monthStartDate)
															->where('created_at','<' , $monthEndDate)
															->where('active',1)
															->where('is_deleted',0)
															->whereNotIn('user_role_id',$unAllowedUserRoles)
															->count();
						break;

					default:
						$allUsers[$num]['month']	=	$month;
						$allUsers[$num]['users']    =   AdminUser::where('created_at', '>' , $monthStartDate)
															->where('created_at','<' , $monthEndDate)
															->where('active',1)
															->where('is_deleted',0)
															->whereNotIn('user_role_id',$unAllowedUserRoles)
															->count();
					break;

				}
			}else{
				$allUsers[$num]['month']			=	$month;
				$allUsers[$num]['users']   			=   AdminUser::where('created_at', '>' , $monthStartDate)
															->where('created_at','<' , $monthEndDate)
															->where('active',1)
															->where('is_deleted',0)
															->where('user_role_id',3)
															->whereNotIn('user_role_id',$unAllowedUserRoles)
															->count();
			}
			$num ++;
		}
		foreach($months as $month){

			$monthStartDate							=	date('Y-m-01 00:00:00', strtotime($month));
			$monthEndDate							=	date('Y-m-t 23:59:59', strtotime($month));
			$allinactive[$num]['month']				=	$month;
			$allinactive[$num]['users']     		=   AdminUser::where('created_at', '>' , $monthStartDate)
															->where('created_at','<' , $monthEndDate)
															->where('active',0)
															->where('is_deleted',0)
															->whereNotIn('user_role_id',$unAllowedUserRoles)
															->where('user_role_id', AdminUser::MEMBER)
															->count();
			$num ++;
		}
		// count total student
		$totalstudents								=	AdminUser::where('is_deleted',0)
															->where('user_role_id', AdminUser::MEMBER)
															->count();
		//count total service provider
		$totalserviceprovider						=	AdminUser::where('is_deleted',0)
															->where('user_role_id',2)
															->count();

		//count total inactive student
		$totalinactivestudents 						= 	AdminUser::where('is_deleted',0)
															->where('user_role_id',AdminUser::MEMBER)
															->where('active',INACTIVE)
															->count();
		//count total active student
		$totalActiveStudents 						= 	AdminUser::where('is_deleted',0)
															->where('user_role_id',AdminUser::MEMBER)
															->where('active',ACTIVE)
															->count();

		//count total inactive service provider
		$totalinactive_serviceprovider 				= 	AdminUser::where('is_deleted',0)
															->where('user_role_id',2)
															->where('active',INACTIVE)
															->count();

        //count total active service provider
        $totalActiveServiceProvider 				= 	AdminUser::where('is_deleted',0)
															->where('user_role_id',2)
															->where('active',ACTIVE)
															->count();

		//count total user
		$totalInActiveUser							=	 AdminUser::where('active',0)
															->where('is_deleted',0)
															->whereNotIn('user_role_id',$unAllowedUserRoles)
															->count();

		return  View::make('admin.Dashboard.dashboard',compact('data','allUsers','allinactive','totalstudents','totalinactivestudents','totalinactive_serviceprovider','totalserviceprovider','totalInActiveUser','userType','totalActiveServiceProvider','totalActiveStudents'));
	}// end showdashboard()

	/**
	 * Function for display admin account detail
	 *
	 */
	public function myaccount(){
		return view("admin.Dashboard.myaccount");
	}// end myaccount()

	/**
	 * Function for update admin account update
	 */
	public function myaccountUpdate(){
		$old_password     	= 	Input::get('old_password');
        $password         	= 	Input::get('new_password');
        $confirm_password 	= 	Input::get('confirm_password');
        $message			=	array(

		'new_password.min'		=> 	trans('AdminUser Password'),
		'old_password.min'		=> 	trans('The old password must be at least 6 characters.'),
		'confirm_password.min'	=> 	trans('The confirm password must be at least 6 characters.')
								);
        $ValidationRule = array(
            'username' 				=> 	'required',
            'email' 				=> 	'required',
            'image'					=> 	'mimes:'.IMAGE_EXTENSION
        );
        if($old_password != '' || $password != '' || $confirm_password != '') {
            $rules          = array(
                'old_password' 		=> 	'required|min:6',
                'new_password' 		=> 	'required|min:6',
                'confirm_password' 	=> 	'required|min:6|same:new_password'
            );
            $ValidationRule = array_merge($ValidationRule, $rules);
        }

        $validator = Validator::make(Input::all(), $ValidationRule,$message);
        if(!empty($password)){

			$password	=	Hash::make($password);

		}

		if ($validator->fails()){
			return Redirect::route('Admin.account')
				->withErrors($validator)->withInput();
		}else{
			$user 					= 	AdminUser::find(Auth::user()->id);
			$old_password 			= 	strip_tags(Input::get('old_password'));
			$password 				= 	strip_tags(Input::get('new_password'));
			$confirm_password 		= 	strip_tags(Input::get('confirm_password'));
			$username    			= 	strip_tags(Input::get('username'));

			if(Input::hasFile('image')){
				$extension 			=	Input::file('image')->getClientOriginalExtension();
				$fileName			=	time().'-user-image.'.$extension;

				if(Input::file('image')->move(USER_PROFILE_IMAGE_ROOT_PATH, $fileName)){
					$user->image	=	$fileName;
				}
				$image 				=	AdminUser::where('id',Auth::user()->id)->pluck('image');
				@unlink(USER_PROFILE_IMAGE_ROOT_PATH.$image);
			}
			if($old_password!=''){
				if(!Hash::check($old_password, $user->password)){
					return Redirect::route('Admin.account')
						->with('error', trans("Account password incorrect"));
				}
			}
			if(!empty($old_password) && !empty($password ) && !empty($confirm_password )){
				if(Hash::check($old_password, $user->password)){
					$user->password = 	Hash::make($password);
					$user->username = 	$username;
				// save the new password
					if($user->save()) {
						return Redirect::route('Admin.account')
							->with('success',trans("Account update profile success"));
					}
				} else {
					return Redirect::route('Admin.account')
						->with('error', trans("Account password incorrect"));
				}
			}else{
				$user->username 	= 	$username;
				if($user->save()) {
					return Redirect::route('Admin.account')
						->with('success',trans("Account update profile success"));
				}
			}
		}
	}// end myaccountUpdate()

} //end AdminDashBoardController()
